# mypy-boto3-s3

[![PyPI - mypy-boto3-s3](https://img.shields.io/pypi/v/mypy-boto3-s3.svg?color=blue)](https://pypi.org/project/mypy-boto3-s3)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-s3.svg?color=blue)](https://pypi.org/project/mypy-boto3-s3)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.S3 1.17.37](https://boto3.amazonaws.com/v1/documentation/api/1.17.37/reference/services/s3.html#S3) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 4.4.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-s3](#mypy-boto3-s3)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `S3` service.

```bash
python -m pip install boto3-stubs[s3]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[s3]` in your environment: `python -m pip install 'boto3-stubs[s3]'`

Both type checking and auto-complete should work for `S3` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[s3]` in your environment: `python -m pip install 'boto3-stubs[s3]'`

Both type checking and auto-complete should work for `S3` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[s3]` in your environment: `python -m pip install 'boto3-stubs[s3]'`
- Run `mypy` as usual

Type checking should work for `S3` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[s3]` in your environment: `python -m pip install 'boto3-stubs[s3]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `S3` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`S3Client` provides annotations for `boto3.client("s3")`.

```python
import boto3

from mypy_boto3_s3 import S3Client

client: S3Client = boto3.client("s3")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: S3Client = session.client("s3")
```

### Paginators annotations

`mypy_boto3_s3.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_s3 import S3Client
from mypy_boto3_s3.paginator import (
    ListMultipartUploadsPaginator,
    ListObjectVersionsPaginator,
    ListObjectsPaginator,
    ListObjectsV2Paginator,
    ListPartsPaginator,
)

client: S3Client = boto3.client("s3")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_multipart_uploads_paginator: ListMultipartUploadsPaginator = client.get_paginator("list_multipart_uploads")
list_object_versions_paginator: ListObjectVersionsPaginator = client.get_paginator("list_object_versions")
list_objects_paginator: ListObjectsPaginator = client.get_paginator("list_objects")
list_objects_v2_paginator: ListObjectsV2Paginator = client.get_paginator("list_objects_v2")
list_parts_paginator: ListPartsPaginator = client.get_paginator("list_parts")
```


### Waiters annotations

`mypy_boto3_s3.waiter` module contains type annotations for all waiters.

```python
from mypy_boto3_s3 import S3Client
from mypy_boto3_s3.waiter import (
    BucketExistsWaiter,
    BucketNotExistsWaiter,
    ObjectExistsWaiter,
    ObjectNotExistsWaiter,
)

client: S3Client = boto3.client("s3")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
bucket_exists_waiter: BucketExistsWaiter = client.get_waiter("bucket_exists")
bucket_not_exists_waiter: BucketNotExistsWaiter = client.get_waiter("bucket_not_exists")
object_exists_waiter: ObjectExistsWaiter = client.get_waiter("object_exists")
object_not_exists_waiter: ObjectNotExistsWaiter = client.get_waiter("object_not_exists")
```


### Service Resource annotations

`S3ServiceResource` provides annotations for `boto3.resource("s3")`.

```python
from mypy_boto3_s3 import S3ServiceResource

resource: S3ServiceResource = boto3.resource("s3")

# now resource usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_resource: S3ServiceResource = session.resource("s3")
```


### Other resources annotations

`mypy_boto3_s3.service_resource` module contains type annotations for all resources.

```python
from mypy_boto3_s3 import S3ServiceResource
from mypy_boto3_s3.service_resource import (
    Bucket,
    BucketAcl,
    BucketCors,
    BucketLifecycle,
    BucketLifecycleConfiguration,
    BucketLogging,
    BucketNotification,
    BucketPolicy,
    BucketRequestPayment,
    BucketTagging,
    BucketVersioning,
    BucketWebsite,
    MultipartUpload,
    MultipartUploadPart,
    Object,
    ObjectAcl,
    ObjectSummary,
    ObjectVersion,
)

resource: S3ServiceResource = boto3.resource("s3")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
my_bucket: Bucket = resource.Bucket(...)
my_bucket_acl: BucketAcl = resource.BucketAcl(...)
my_bucket_cors: BucketCors = resource.BucketCors(...)
my_bucket_lifecycle: BucketLifecycle = resource.BucketLifecycle(...)
my_bucket_lifecycle_configuration: BucketLifecycleConfiguration = resource.BucketLifecycleConfiguration(...)
my_bucket_logging: BucketLogging = resource.BucketLogging(...)
my_bucket_notification: BucketNotification = resource.BucketNotification(...)
my_bucket_policy: BucketPolicy = resource.BucketPolicy(...)
my_bucket_request_payment: BucketRequestPayment = resource.BucketRequestPayment(...)
my_bucket_tagging: BucketTagging = resource.BucketTagging(...)
my_bucket_versioning: BucketVersioning = resource.BucketVersioning(...)
my_bucket_website: BucketWebsite = resource.BucketWebsite(...)
my_multipart_upload: MultipartUpload = resource.MultipartUpload(...)
my_multipart_upload_part: MultipartUploadPart = resource.MultipartUploadPart(...)
my_object: Object = resource.Object(...)
my_object_acl: ObjectAcl = resource.ObjectAcl(...)
my_object_summary: ObjectSummary = resource.ObjectSummary(...)
my_object_version: ObjectVersion = resource.ObjectVersion(...)
```



### Collections annotations

`mypy_boto3_s3.service_resource` module contains type annotations
for all `S3ServiceResource` collections.

```python
from mypy_boto3_s3 import S3ServiceResource
from mypy_boto3_s3.service_resource import (
    ServiceResourceBucketsCollection,
)

resource: S3ServiceResource = boto3.resource("s3")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
buckets: s3_resources.ServiceResourceBucketsCollection = resource.buckets
```




### Typed dictionations

`mypy_boto3_s3.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_s3.type_defs import (
    AbortIncompleteMultipartUploadTypeDef,
    AccessControlTranslationTypeDef,
    AnalyticsAndOperatorTypeDef,
    AnalyticsConfigurationTypeDef,
    AnalyticsExportDestinationTypeDef,
    AnalyticsFilterTypeDef,
    AnalyticsS3BucketDestinationTypeDef,
    BucketTypeDef,
    CORSRuleTypeDef,
    CSVInputTypeDef,
    CSVOutputTypeDef,
    CloudFunctionConfigurationTypeDef,
    CommonPrefixTypeDef,
    CompletedPartTypeDef,
    ConditionTypeDef,
    CopyObjectResultTypeDef,
    CopyPartResultTypeDef,
    DefaultRetentionTypeDef,
    DeleteMarkerEntryTypeDef,
    DeleteMarkerReplicationTypeDef,
    DeletedObjectTypeDef,
    DestinationTypeDef,
    EncryptionConfigurationTypeDef,
    EncryptionTypeDef,
    ErrorDocumentTypeDef,
    ErrorTypeDef,
    ExistingObjectReplicationTypeDef,
    FilterRuleTypeDef,
    GlacierJobParametersTypeDef,
    GrantTypeDef,
    GranteeTypeDef,
    IndexDocumentTypeDef,
    InitiatorTypeDef,
    InputSerializationTypeDef,
    IntelligentTieringAndOperatorTypeDef,
    IntelligentTieringConfigurationTypeDef,
    IntelligentTieringFilterTypeDef,
    InventoryConfigurationTypeDef,
    InventoryDestinationTypeDef,
    InventoryEncryptionTypeDef,
    InventoryFilterTypeDef,
    InventoryS3BucketDestinationTypeDef,
    InventoryScheduleTypeDef,
    JSONInputTypeDef,
    JSONOutputTypeDef,
    LambdaFunctionConfigurationTypeDef,
    LifecycleExpirationTypeDef,
    LifecycleRuleAndOperatorTypeDef,
    LifecycleRuleFilterTypeDef,
    LifecycleRuleTypeDef,
    LoggingEnabledTypeDef,
    MetadataEntryTypeDef,
    MetricsAndOperatorTypeDef,
    MetricsConfigurationTypeDef,
    MetricsFilterTypeDef,
    MetricsTypeDef,
    MultipartUploadTypeDef,
    NoncurrentVersionExpirationTypeDef,
    NoncurrentVersionTransitionTypeDef,
    NotificationConfigurationFilterTypeDef,
    ObjectIdentifierTypeDef,
    ObjectLockConfigurationTypeDef,
    ObjectLockLegalHoldTypeDef,
    ObjectLockRetentionTypeDef,
    ObjectLockRuleTypeDef,
    ObjectTypeDef,
    ObjectVersionTypeDef,
    OutputLocationTypeDef,
    OutputSerializationTypeDef,
    OwnerTypeDef,
    OwnershipControlsRuleTypeDef,
    OwnershipControlsTypeDef,
    PartTypeDef,
    PolicyStatusTypeDef,
    ProgressEventTypeDef,
    ProgressTypeDef,
    PublicAccessBlockConfigurationTypeDef,
    QueueConfigurationDeprecatedTypeDef,
    QueueConfigurationTypeDef,
    RecordsEventTypeDef,
    RedirectAllRequestsToTypeDef,
    RedirectTypeDef,
    ReplicaModificationsTypeDef,
    ReplicationConfigurationTypeDef,
    ReplicationRuleAndOperatorTypeDef,
    ReplicationRuleFilterTypeDef,
    ReplicationRuleTypeDef,
    ReplicationTimeTypeDef,
    ReplicationTimeValueTypeDef,
    ResponseMetadata,
    RoutingRuleTypeDef,
    RuleTypeDef,
    S3KeyFilterTypeDef,
    S3LocationTypeDef,
    SSEKMSTypeDef,
    SelectObjectContentEventStreamTypeDef,
    SelectParametersTypeDef,
    ServerSideEncryptionByDefaultTypeDef,
    ServerSideEncryptionConfigurationTypeDef,
    ServerSideEncryptionRuleTypeDef,
    SourceSelectionCriteriaTypeDef,
    SseKmsEncryptedObjectsTypeDef,
    StatsEventTypeDef,
    StatsTypeDef,
    StorageClassAnalysisDataExportTypeDef,
    StorageClassAnalysisTypeDef,
    TagTypeDef,
    TaggingTypeDef,
    TargetGrantTypeDef,
    TieringTypeDef,
    TopicConfigurationDeprecatedTypeDef,
    TopicConfigurationTypeDef,
    TransitionTypeDef,
    AbortMultipartUploadOutputTypeDef,
    AccelerateConfigurationTypeDef,
    AccessControlPolicyTypeDef,
    BucketLifecycleConfigurationTypeDef,
    BucketLoggingStatusTypeDef,
    CORSConfigurationTypeDef,
    CompleteMultipartUploadOutputTypeDef,
    CompletedMultipartUploadTypeDef,
    CopyObjectOutputTypeDef,
    CopySourceTypeDef,
    CreateBucketConfigurationTypeDef,
    CreateBucketOutputTypeDef,
    CreateMultipartUploadOutputTypeDef,
    DeleteObjectOutputTypeDef,
    DeleteObjectTaggingOutputTypeDef,
    DeleteObjectsOutputTypeDef,
    DeleteTypeDef,
    GetBucketAccelerateConfigurationOutputTypeDef,
    GetBucketAclOutputTypeDef,
    GetBucketAnalyticsConfigurationOutputTypeDef,
    GetBucketCorsOutputTypeDef,
    GetBucketEncryptionOutputTypeDef,
    GetBucketIntelligentTieringConfigurationOutputTypeDef,
    GetBucketInventoryConfigurationOutputTypeDef,
    GetBucketLifecycleConfigurationOutputTypeDef,
    GetBucketLifecycleOutputTypeDef,
    GetBucketLocationOutputTypeDef,
    GetBucketLoggingOutputTypeDef,
    GetBucketMetricsConfigurationOutputTypeDef,
    GetBucketOwnershipControlsOutputTypeDef,
    GetBucketPolicyOutputTypeDef,
    GetBucketPolicyStatusOutputTypeDef,
    GetBucketReplicationOutputTypeDef,
    GetBucketRequestPaymentOutputTypeDef,
    GetBucketTaggingOutputTypeDef,
    GetBucketVersioningOutputTypeDef,
    GetBucketWebsiteOutputTypeDef,
    GetObjectAclOutputTypeDef,
    GetObjectLegalHoldOutputTypeDef,
    GetObjectLockConfigurationOutputTypeDef,
    GetObjectOutputTypeDef,
    GetObjectRetentionOutputTypeDef,
    GetObjectTaggingOutputTypeDef,
    GetObjectTorrentOutputTypeDef,
    GetPublicAccessBlockOutputTypeDef,
    HeadObjectOutputTypeDef,
    LifecycleConfigurationTypeDef,
    ListBucketAnalyticsConfigurationsOutputTypeDef,
    ListBucketIntelligentTieringConfigurationsOutputTypeDef,
    ListBucketInventoryConfigurationsOutputTypeDef,
    ListBucketMetricsConfigurationsOutputTypeDef,
    ListBucketsOutputTypeDef,
    ListMultipartUploadsOutputTypeDef,
    ListObjectVersionsOutputTypeDef,
    ListObjectsOutputTypeDef,
    ListObjectsV2OutputTypeDef,
    ListPartsOutputTypeDef,
    NotificationConfigurationDeprecatedTypeDef,
    NotificationConfigurationTypeDef,
    PaginatorConfigTypeDef,
    PutObjectAclOutputTypeDef,
    PutObjectLegalHoldOutputTypeDef,
    PutObjectLockConfigurationOutputTypeDef,
    PutObjectOutputTypeDef,
    PutObjectRetentionOutputTypeDef,
    PutObjectTaggingOutputTypeDef,
    RequestPaymentConfigurationTypeDef,
    RequestProgressTypeDef,
    RestoreObjectOutputTypeDef,
    RestoreRequestTypeDef,
    ScanRangeTypeDef,
    SelectObjectContentOutputTypeDef,
    UploadPartCopyOutputTypeDef,
    UploadPartOutputTypeDef,
    VersioningConfigurationTypeDef,
    WaiterConfigTypeDef,
    WebsiteConfigurationTypeDef,
)

def get_structure() -> AbortIncompleteMultipartUploadTypeDef:
    return {
      ...
    }
```
