# data-repo-client
<details><summary>This document defines the REST API for the Terra Data Repository.</summary> <p> **Status: design in progress**
There are a few top-level endpoints (besides some used by swagger):
 * / - generated by swagger: swagger API page that provides this
documentation and a live UI for submitting REST requests
 * /status - provides the operational status of the service
 * /configuration - provides the basic configuration and information about the service
 * /api - is the authenticated and authorized Data Repository API
 * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API

The API endpoints are organized by interface. Each interface is separately versioned. <p> **Notes on Naming** <p> All of the reference items are suffixed with \\\"Model\\\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. </details>


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.0
- Package version: 2.316.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import data_repo_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import data_repo_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import data_repo_client
from data_repo_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = data_repo_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure OAuth2 access token for authorization: oidc
configuration = data_repo_client.Configuration(
    host = "http://localhost"
)
configuration.access_token = 'YOUR_ACCESS_TOKEN'


# Enter a context with an instance of the API client
with data_repo_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = data_repo_client.DataRepositoryServiceApi(api_client)
    object_id = 'object_id_example' # str | An `id` of a Data Object
access_id = 'access_id_example' # str | An `access_id` from the `access_methods` list of a Data Object
x_user_project = 'x_user_project_example' # str | For GCP hosted files, this will indicate the user project to bill when accessing the signed url.  This value must be a valid Terra billing project ID that the caller has access to and only applies to GCP hosted data.  (optional)

    try:
        # Get a URL for fetching bytes.
        api_response = api_instance.get_access_url(object_id, access_id, x_user_project=x_user_project)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling DataRepositoryServiceApi->get_access_url: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DataRepositoryServiceApi* | [**get_access_url**](docs/DataRepositoryServiceApi.md#get_access_url) | **GET** /ga4gh/drs/v1/objects/{object_id}/access/{access_id} | Get a URL for fetching bytes.
*DataRepositoryServiceApi* | [**get_object**](docs/DataRepositoryServiceApi.md#get_object) | **GET** /ga4gh/drs/v1/objects/{object_id} | Get info about an &#x60;Object&#x60;.
*DataRepositoryServiceApi* | [**get_service_info**](docs/DataRepositoryServiceApi.md#get_service_info) | **GET** /ga4gh/drs/v1/service-info | Get information about this implementation.
*DataRepositoryServiceApi* | [**options_object**](docs/DataRepositoryServiceApi.md#options_object) | **OPTIONS** /ga4gh/drs/v1/objects/{object_id} | Get Authorization info about a DRS Object.
*DataRepositoryServiceApi* | [**post_access_url**](docs/DataRepositoryServiceApi.md#post_access_url) | **POST** /ga4gh/drs/v1/objects/{object_id}/access/{access_id} | Get a URL for fetching bytes through POST&#39;ing a Passport
*DataRepositoryServiceApi* | [**post_object**](docs/DataRepositoryServiceApi.md#post_object) | **POST** /ga4gh/drs/v1/objects/{object_id} | Get info about a DrsObject through POST&#39;ing a Passport.
*SnapshotAccessRequestApi* | [**add_snapshot_access_request_group_member**](docs/SnapshotAccessRequestApi.md#add_snapshot_access_request_group_member) | **POST** /api/repository/v1/snapshotAccessRequests/{id}/members | 
*SnapshotAccessRequestApi* | [**approve_snapshot_access_request**](docs/SnapshotAccessRequestApi.md#approve_snapshot_access_request) | **PUT** /api/repository/v1/snapshotAccessRequests/{id}/approve | 
*SnapshotAccessRequestApi* | [**create_snapshot_access_request**](docs/SnapshotAccessRequestApi.md#create_snapshot_access_request) | **POST** /api/repository/v1/snapshotAccessRequests | 
*SnapshotAccessRequestApi* | [**delete_snapshot_access_request**](docs/SnapshotAccessRequestApi.md#delete_snapshot_access_request) | **DELETE** /api/repository/v1/snapshotAccessRequests/{id} | 
*SnapshotAccessRequestApi* | [**delete_snapshot_access_request_group_member**](docs/SnapshotAccessRequestApi.md#delete_snapshot_access_request_group_member) | **DELETE** /api/repository/v1/snapshotAccessRequests/{id}/members/{memberEmail} | 
*SnapshotAccessRequestApi* | [**enumerate_snapshot_access_requests**](docs/SnapshotAccessRequestApi.md#enumerate_snapshot_access_requests) | **GET** /api/repository/v1/snapshotAccessRequests | 
*SnapshotAccessRequestApi* | [**get_snapshot_access_request**](docs/SnapshotAccessRequestApi.md#get_snapshot_access_request) | **GET** /api/repository/v1/snapshotAccessRequests/{id} | 
*SnapshotAccessRequestApi* | [**get_snapshot_access_request_details**](docs/SnapshotAccessRequestApi.md#get_snapshot_access_request_details) | **GET** /api/repository/v1/snapshotAccessRequests/{id}/details | 
*SnapshotAccessRequestApi* | [**get_snapshot_access_request_group_members**](docs/SnapshotAccessRequestApi.md#get_snapshot_access_request_group_members) | **GET** /api/repository/v1/snapshotAccessRequests/{id}/members | 
*SnapshotAccessRequestApi* | [**reject_snapshot_access_request**](docs/SnapshotAccessRequestApi.md#reject_snapshot_access_request) | **PUT** /api/repository/v1/snapshotAccessRequests/{id}/reject | 
*AdminApi* | [**admin_retrieve_dataset**](docs/AdminApi.md#admin_retrieve_dataset) | **GET** /api/admin/v1/datasets/{id} | 
*AdminApi* | [**admin_retrieve_snapshot**](docs/AdminApi.md#admin_retrieve_snapshot) | **GET** /api/admin/v1/snapshots/{id} | 
*AdminApi* | [**register_drs_aliases**](docs/AdminApi.md#register_drs_aliases) | **POST** /api/repository/v1/admin/register-drs-aliases | 
*ConfigsApi* | [**get_config**](docs/ConfigsApi.md#get_config) | **GET** /api/repository/v1/configs/{name} | 
*ConfigsApi* | [**get_config_list**](docs/ConfigsApi.md#get_config_list) | **GET** /api/repository/v1/configs | 
*ConfigsApi* | [**reset_config**](docs/ConfigsApi.md#reset_config) | **PUT** /api/repository/v1/configs/reset | 
*ConfigsApi* | [**set_config_list**](docs/ConfigsApi.md#set_config_list) | **PUT** /api/repository/v1/configs | 
*ConfigsApi* | [**set_fault**](docs/ConfigsApi.md#set_fault) | **PUT** /api/repository/v1/configs/{name} | 
*DatasetsApi* | [**add_dataset_asset_specifications**](docs/DatasetsApi.md#add_dataset_asset_specifications) | **POST** /api/repository/v1/datasets/{id}/assets | 
*DatasetsApi* | [**add_dataset_policy_member**](docs/DatasetsApi.md#add_dataset_policy_member) | **POST** /api/repository/v1/datasets/{id}/policies/{policyName}/members | 
*DatasetsApi* | [**adjust_members_inherit_steward**](docs/DatasetsApi.md#adjust_members_inherit_steward) | **PUT** /api/repository/v1/datasets/{id}/adjustMembersInheritSteward | 
*DatasetsApi* | [**apply_dataset_data_deletion**](docs/DatasetsApi.md#apply_dataset_data_deletion) | **POST** /api/repository/v1/datasets/{id}/deletes | 
*DatasetsApi* | [**bulk_file_load**](docs/DatasetsApi.md#bulk_file_load) | **POST** /api/repository/v1/datasets/{id}/files/bulk | 
*DatasetsApi* | [**bulk_file_load_array**](docs/DatasetsApi.md#bulk_file_load_array) | **POST** /api/repository/v1/datasets/{id}/files/bulk/array | 
*DatasetsApi* | [**bulk_file_results_delete**](docs/DatasetsApi.md#bulk_file_results_delete) | **DELETE** /api/repository/v1/datasets/{id}/files/bulk/{loadTag} | 
*DatasetsApi* | [**close_transaction**](docs/DatasetsApi.md#close_transaction) | **POST** /api/repository/v1/datasets/{id}/transactions/{transactionId} | 
*DatasetsApi* | [**create_dataset**](docs/DatasetsApi.md#create_dataset) | **POST** /api/repository/v1/datasets | 
*DatasetsApi* | [**delete_dataset**](docs/DatasetsApi.md#delete_dataset) | **DELETE** /api/repository/v1/datasets/{id} | 
*DatasetsApi* | [**delete_dataset_policy_member**](docs/DatasetsApi.md#delete_dataset_policy_member) | **DELETE** /api/repository/v1/datasets/{id}/policies/{policyName}/members/{memberEmail} | 
*DatasetsApi* | [**delete_file**](docs/DatasetsApi.md#delete_file) | **DELETE** /api/repository/v1/datasets/{id}/files/{fileid} | 
*DatasetsApi* | [**enumerate_datasets**](docs/DatasetsApi.md#enumerate_datasets) | **GET** /api/repository/v1/datasets | 
*DatasetsApi* | [**enumerate_transactions**](docs/DatasetsApi.md#enumerate_transactions) | **GET** /api/repository/v1/datasets/{id}/transactions | 
*DatasetsApi* | [**get_dataset_tags**](docs/DatasetsApi.md#get_dataset_tags) | **GET** /api/repository/v1/datasets/tags | 
*DatasetsApi* | [**get_load_history_for_load_tag**](docs/DatasetsApi.md#get_load_history_for_load_tag) | **GET** /api/repository/v1/datasets/{id}/files/bulk/{loadTag} | 
*DatasetsApi* | [**ingest_dataset**](docs/DatasetsApi.md#ingest_dataset) | **POST** /api/repository/v1/datasets/{id}/ingest | 
*DatasetsApi* | [**ingest_file**](docs/DatasetsApi.md#ingest_file) | **POST** /api/repository/v1/datasets/{id}/files | 
*DatasetsApi* | [**list_files**](docs/DatasetsApi.md#list_files) | **GET** /api/repository/v1/datasets/{id}/files | 
*DatasetsApi* | [**lock_dataset**](docs/DatasetsApi.md#lock_dataset) | **PUT** /api/repository/v1/datasets/{id}/lock | 
*DatasetsApi* | [**lookup_dataset_column_statistics_by_id**](docs/DatasetsApi.md#lookup_dataset_column_statistics_by_id) | **GET** /api/repository/v1/datasets/{id}/data/{table}/statistics/{column} | 
*DatasetsApi* | [**lookup_dataset_data_by_id**](docs/DatasetsApi.md#lookup_dataset_data_by_id) | **GET** /api/repository/v1/datasets/{id}/data/{table} | 
*DatasetsApi* | [**lookup_file_by_id**](docs/DatasetsApi.md#lookup_file_by_id) | **GET** /api/repository/v1/datasets/{id}/files/{fileid} | 
*DatasetsApi* | [**lookup_file_by_path**](docs/DatasetsApi.md#lookup_file_by_path) | **GET** /api/repository/v1/datasets/{id}/filesystem/objects | 
*DatasetsApi* | [**open_transaction**](docs/DatasetsApi.md#open_transaction) | **POST** /api/repository/v1/datasets/{id}/transactions | 
*DatasetsApi* | [**patch_dataset**](docs/DatasetsApi.md#patch_dataset) | **PATCH** /api/repository/v1/datasets/{id} | 
*DatasetsApi* | [**query_dataset_column_statistics_by_id**](docs/DatasetsApi.md#query_dataset_column_statistics_by_id) | **POST** /api/repository/v1/datasets/{id}/data/{table}/statistics/{column} | 
*DatasetsApi* | [**query_dataset_data_by_id**](docs/DatasetsApi.md#query_dataset_data_by_id) | **POST** /api/repository/v1/datasets/{id}/data/{table} | 
*DatasetsApi* | [**remove_dataset_asset_specifications**](docs/DatasetsApi.md#remove_dataset_asset_specifications) | **DELETE** /api/repository/v1/datasets/{id}/assets/{assetid} | 
*DatasetsApi* | [**retrieve_dataset**](docs/DatasetsApi.md#retrieve_dataset) | **GET** /api/repository/v1/datasets/{id} | 
*DatasetsApi* | [**retrieve_dataset_policies**](docs/DatasetsApi.md#retrieve_dataset_policies) | **GET** /api/repository/v1/datasets/{id}/policies | 
*DatasetsApi* | [**retrieve_dataset_summary**](docs/DatasetsApi.md#retrieve_dataset_summary) | **GET** /api/repository/v1/datasets/{id}/summary | 
*DatasetsApi* | [**retrieve_transaction**](docs/DatasetsApi.md#retrieve_transaction) | **GET** /api/repository/v1/datasets/{id}/transactions/{transactionId} | 
*DatasetsApi* | [**retrieve_user_dataset_roles**](docs/DatasetsApi.md#retrieve_user_dataset_roles) | **GET** /api/repository/v1/datasets/{id}/roles | 
*DatasetsApi* | [**set_inherit_steward**](docs/DatasetsApi.md#set_inherit_steward) | **PUT** /api/repository/v1/datasets/{id}/inheritSteward | 
*DatasetsApi* | [**unlock_dataset**](docs/DatasetsApi.md#unlock_dataset) | **PUT** /api/repository/v1/datasets/{id}/unlock | 
*DatasetsApi* | [**update_dataset_tags**](docs/DatasetsApi.md#update_dataset_tags) | **PATCH** /api/repository/v1/datasets/{id}/tags | 
*DatasetsApi* | [**update_schema**](docs/DatasetsApi.md#update_schema) | **POST** /api/repository/v1/datasets/{id}/updateSchema | 
*DuosApi* | [**retrieve_duos_firecloud_group**](docs/DuosApi.md#retrieve_duos_firecloud_group) | **GET** /api/repository/v1/duos/{duosId} | 
*DuosApi* | [**retrieve_duos_firecloud_groups**](docs/DuosApi.md#retrieve_duos_firecloud_groups) | **GET** /api/repository/v1/duos | 
*DuosApi* | [**sync_duos_dataset_authorized_users**](docs/DuosApi.md#sync_duos_dataset_authorized_users) | **PUT** /api/repository/v1/duos/{duosId}/syncAuthorizedUsers | 
*DuosApi* | [**sync_duos_datasets_authorized_users**](docs/DuosApi.md#sync_duos_datasets_authorized_users) | **PUT** /api/repository/v1/duos/syncAuthorizedUsers | 
*JobsApi* | [**enumerate_jobs**](docs/JobsApi.md#enumerate_jobs) | **GET** /api/repository/v1/jobs | 
*JobsApi* | [**retrieve_job**](docs/JobsApi.md#retrieve_job) | **GET** /api/repository/v1/jobs/{id} | 
*JobsApi* | [**retrieve_job_result**](docs/JobsApi.md#retrieve_job_result) | **GET** /api/repository/v1/jobs/{id}/result | 
*JournalApi* | [**retrieve_journal_entries**](docs/JournalApi.md#retrieve_journal_entries) | **GET** /api/repository/v1/journal/{resourceKey} | 
*ProfilesApi* | [**add_profile_policy_member**](docs/ProfilesApi.md#add_profile_policy_member) | **POST** /api/resources/v1/profiles/{id}/policies/{policyName}/members | 
*ProfilesApi* | [**create_profile**](docs/ProfilesApi.md#create_profile) | **POST** /api/resources/v1/profiles | 
*ProfilesApi* | [**delete_profile**](docs/ProfilesApi.md#delete_profile) | **DELETE** /api/resources/v1/profiles/{id} | 
*ProfilesApi* | [**delete_profile_policy_member**](docs/ProfilesApi.md#delete_profile_policy_member) | **DELETE** /api/resources/v1/profiles/{id}/policies/{policyName}/members/{memberEmail} | 
*ProfilesApi* | [**enumerate_profiles**](docs/ProfilesApi.md#enumerate_profiles) | **GET** /api/resources/v1/profiles | 
*ProfilesApi* | [**get_profile_resources**](docs/ProfilesApi.md#get_profile_resources) | **GET** /api/resources/v1/profiles/{id}/resources | 
*ProfilesApi* | [**retrieve_profile**](docs/ProfilesApi.md#retrieve_profile) | **GET** /api/resources/v1/profiles/{id} | 
*ProfilesApi* | [**retrieve_profile_policies**](docs/ProfilesApi.md#retrieve_profile_policies) | **GET** /api/resources/v1/profiles/{id}/policies | 
*ProfilesApi* | [**update_profile**](docs/ProfilesApi.md#update_profile) | **PUT** /api/resources/v1/profiles | 
*RegisterApi* | [**user**](docs/RegisterApi.md#user) | **GET** /api/repository/v1/register/user | 
*RepositoryApi* | [**add_dataset_asset_specifications**](docs/RepositoryApi.md#add_dataset_asset_specifications) | **POST** /api/repository/v1/datasets/{id}/assets | 
*RepositoryApi* | [**add_dataset_policy_member**](docs/RepositoryApi.md#add_dataset_policy_member) | **POST** /api/repository/v1/datasets/{id}/policies/{policyName}/members | 
*RepositoryApi* | [**add_snapshot_auth_domain**](docs/RepositoryApi.md#add_snapshot_auth_domain) | **PATCH** /api/repository/v1/snapshots/{id}/authDomain | 
*RepositoryApi* | [**add_snapshot_policy_member**](docs/RepositoryApi.md#add_snapshot_policy_member) | **POST** /api/repository/v1/snapshots/{id}/policies/{policyName}/members | 
*RepositoryApi* | [**adjust_members_inherit_steward**](docs/RepositoryApi.md#adjust_members_inherit_steward) | **PUT** /api/repository/v1/datasets/{id}/adjustMembersInheritSteward | 
*RepositoryApi* | [**apply_dataset_data_deletion**](docs/RepositoryApi.md#apply_dataset_data_deletion) | **POST** /api/repository/v1/datasets/{id}/deletes | 
*RepositoryApi* | [**bulk_file_load**](docs/RepositoryApi.md#bulk_file_load) | **POST** /api/repository/v1/datasets/{id}/files/bulk | 
*RepositoryApi* | [**bulk_file_load_array**](docs/RepositoryApi.md#bulk_file_load_array) | **POST** /api/repository/v1/datasets/{id}/files/bulk/array | 
*RepositoryApi* | [**bulk_file_results_delete**](docs/RepositoryApi.md#bulk_file_results_delete) | **DELETE** /api/repository/v1/datasets/{id}/files/bulk/{loadTag} | 
*RepositoryApi* | [**close_transaction**](docs/RepositoryApi.md#close_transaction) | **POST** /api/repository/v1/datasets/{id}/transactions/{transactionId} | 
*RepositoryApi* | [**create_dataset**](docs/RepositoryApi.md#create_dataset) | **POST** /api/repository/v1/datasets | 
*RepositoryApi* | [**create_snapshot**](docs/RepositoryApi.md#create_snapshot) | **POST** /api/repository/v1/snapshots | 
*RepositoryApi* | [**delete_dataset**](docs/RepositoryApi.md#delete_dataset) | **DELETE** /api/repository/v1/datasets/{id} | 
*RepositoryApi* | [**delete_dataset_policy_member**](docs/RepositoryApi.md#delete_dataset_policy_member) | **DELETE** /api/repository/v1/datasets/{id}/policies/{policyName}/members/{memberEmail} | 
*RepositoryApi* | [**delete_file**](docs/RepositoryApi.md#delete_file) | **DELETE** /api/repository/v1/datasets/{id}/files/{fileid} | 
*RepositoryApi* | [**delete_snapshot**](docs/RepositoryApi.md#delete_snapshot) | **DELETE** /api/repository/v1/snapshots/{id} | 
*RepositoryApi* | [**delete_snapshot_policy_member**](docs/RepositoryApi.md#delete_snapshot_policy_member) | **DELETE** /api/repository/v1/snapshots/{id}/policies/{policyName}/members/{memberEmail} | 
*RepositoryApi* | [**delete_snapshot_snapshot_builder_settings**](docs/RepositoryApi.md#delete_snapshot_snapshot_builder_settings) | **DELETE** /api/repository/v1/snapshots/{id}/snapshotBuilder/settings | 
*RepositoryApi* | [**enumerate_concepts**](docs/RepositoryApi.md#enumerate_concepts) | **GET** /api/repository/v1/snapshots/{id}/snapshotBuilder/concepts | 
*RepositoryApi* | [**enumerate_datasets**](docs/RepositoryApi.md#enumerate_datasets) | **GET** /api/repository/v1/datasets | 
*RepositoryApi* | [**enumerate_jobs**](docs/RepositoryApi.md#enumerate_jobs) | **GET** /api/repository/v1/jobs | 
*RepositoryApi* | [**enumerate_snapshots**](docs/RepositoryApi.md#enumerate_snapshots) | **GET** /api/repository/v1/snapshots | 
*RepositoryApi* | [**enumerate_transactions**](docs/RepositoryApi.md#enumerate_transactions) | **GET** /api/repository/v1/datasets/{id}/transactions | 
*RepositoryApi* | [**export_snapshot**](docs/RepositoryApi.md#export_snapshot) | **GET** /api/repository/v1/snapshots/{id}/export | 
*RepositoryApi* | [**get_concept_children**](docs/RepositoryApi.md#get_concept_children) | **GET** /api/repository/v1/snapshots/{id}/snapshotBuilder/concepts/{conceptId}/children | 
*RepositoryApi* | [**get_concept_hierarchy**](docs/RepositoryApi.md#get_concept_hierarchy) | **GET** /api/repository/v1/snapshots/{id}/snapshotBuilder/concepts/{conceptId}/hierarchy | 
*RepositoryApi* | [**get_config**](docs/RepositoryApi.md#get_config) | **GET** /api/repository/v1/configs/{name} | 
*RepositoryApi* | [**get_config_list**](docs/RepositoryApi.md#get_config_list) | **GET** /api/repository/v1/configs | 
*RepositoryApi* | [**get_dataset_tags**](docs/RepositoryApi.md#get_dataset_tags) | **GET** /api/repository/v1/datasets/tags | 
*RepositoryApi* | [**get_load_history_for_load_tag**](docs/RepositoryApi.md#get_load_history_for_load_tag) | **GET** /api/repository/v1/datasets/{id}/files/bulk/{loadTag} | 
*RepositoryApi* | [**get_snapshot_builder_count**](docs/RepositoryApi.md#get_snapshot_builder_count) | **POST** /api/repository/v1/snapshots/{id}/snapshotBuilder/count | 
*RepositoryApi* | [**get_snapshot_ids_and_roles**](docs/RepositoryApi.md#get_snapshot_ids_and_roles) | **GET** /api/repository/v1/snapshots/roleMap | 
*RepositoryApi* | [**get_snapshot_snapshot_builder_settings**](docs/RepositoryApi.md#get_snapshot_snapshot_builder_settings) | **GET** /api/repository/v1/snapshots/{id}/snapshotBuilder/settings | 
*RepositoryApi* | [**get_snapshot_tags**](docs/RepositoryApi.md#get_snapshot_tags) | **GET** /api/repository/v1/snapshots/tags | 
*RepositoryApi* | [**ingest_dataset**](docs/RepositoryApi.md#ingest_dataset) | **POST** /api/repository/v1/datasets/{id}/ingest | 
*RepositoryApi* | [**ingest_file**](docs/RepositoryApi.md#ingest_file) | **POST** /api/repository/v1/datasets/{id}/files | 
*RepositoryApi* | [**link_duos_dataset_to_snapshot**](docs/RepositoryApi.md#link_duos_dataset_to_snapshot) | **PUT** /api/repository/v1/snapshots/{id}/linkDuosDataset/{duosId} | 
*RepositoryApi* | [**list_files**](docs/RepositoryApi.md#list_files) | **GET** /api/repository/v1/snapshots/{id}/files | 
*RepositoryApi* | [**list_files_0**](docs/RepositoryApi.md#list_files_0) | **GET** /api/repository/v1/datasets/{id}/files | 
*RepositoryApi* | [**lock_dataset**](docs/RepositoryApi.md#lock_dataset) | **PUT** /api/repository/v1/datasets/{id}/lock | 
*RepositoryApi* | [**lock_snapshot**](docs/RepositoryApi.md#lock_snapshot) | **PUT** /api/repository/v1/snapshots/{id}/lock | 
*RepositoryApi* | [**lookup_dataset_data_by_id**](docs/RepositoryApi.md#lookup_dataset_data_by_id) | **GET** /api/repository/v1/datasets/{id}/data/{table} | 
*RepositoryApi* | [**lookup_file_by_id**](docs/RepositoryApi.md#lookup_file_by_id) | **GET** /api/repository/v1/datasets/{id}/files/{fileid} | 
*RepositoryApi* | [**lookup_file_by_path**](docs/RepositoryApi.md#lookup_file_by_path) | **GET** /api/repository/v1/datasets/{id}/filesystem/objects | 
*RepositoryApi* | [**lookup_snapshot_file_by_id**](docs/RepositoryApi.md#lookup_snapshot_file_by_id) | **GET** /api/repository/v1/snapshots/{id}/files/{fileid} | 
*RepositoryApi* | [**lookup_snapshot_file_by_path**](docs/RepositoryApi.md#lookup_snapshot_file_by_path) | **GET** /api/repository/v1/snapshots/{id}/filesystem/objects | 
*RepositoryApi* | [**lookup_snapshot_preview_by_id**](docs/RepositoryApi.md#lookup_snapshot_preview_by_id) | **GET** /api/repository/v1/snapshots/{id}/data/{table} | 
*RepositoryApi* | [**open_transaction**](docs/RepositoryApi.md#open_transaction) | **POST** /api/repository/v1/datasets/{id}/transactions | 
*RepositoryApi* | [**patch_dataset**](docs/RepositoryApi.md#patch_dataset) | **PATCH** /api/repository/v1/datasets/{id} | 
*RepositoryApi* | [**patch_snapshot**](docs/RepositoryApi.md#patch_snapshot) | **PATCH** /api/repository/v1/snapshots/{id} | 
*RepositoryApi* | [**query_dataset_data_by_id**](docs/RepositoryApi.md#query_dataset_data_by_id) | **POST** /api/repository/v1/datasets/{id}/data/{table} | 
*RepositoryApi* | [**query_snapshot_data_by_id**](docs/RepositoryApi.md#query_snapshot_data_by_id) | **POST** /api/repository/v1/snapshots/{id}/data/{table} | 
*RepositoryApi* | [**register_drs_aliases**](docs/RepositoryApi.md#register_drs_aliases) | **POST** /api/repository/v1/admin/register-drs-aliases | 
*RepositoryApi* | [**remove_dataset_asset_specifications**](docs/RepositoryApi.md#remove_dataset_asset_specifications) | **DELETE** /api/repository/v1/datasets/{id}/assets/{assetid} | 
*RepositoryApi* | [**reset_config**](docs/RepositoryApi.md#reset_config) | **PUT** /api/repository/v1/configs/reset | 
*RepositoryApi* | [**retrieve_dataset**](docs/RepositoryApi.md#retrieve_dataset) | **GET** /api/repository/v1/datasets/{id} | 
*RepositoryApi* | [**retrieve_dataset_policies**](docs/RepositoryApi.md#retrieve_dataset_policies) | **GET** /api/repository/v1/datasets/{id}/policies | 
*RepositoryApi* | [**retrieve_dataset_summary**](docs/RepositoryApi.md#retrieve_dataset_summary) | **GET** /api/repository/v1/datasets/{id}/summary | 
*RepositoryApi* | [**retrieve_duos_firecloud_group**](docs/RepositoryApi.md#retrieve_duos_firecloud_group) | **GET** /api/repository/v1/duos/{duosId} | 
*RepositoryApi* | [**retrieve_duos_firecloud_groups**](docs/RepositoryApi.md#retrieve_duos_firecloud_groups) | **GET** /api/repository/v1/duos | 
*RepositoryApi* | [**retrieve_job**](docs/RepositoryApi.md#retrieve_job) | **GET** /api/repository/v1/jobs/{id} | 
*RepositoryApi* | [**retrieve_job_result**](docs/RepositoryApi.md#retrieve_job_result) | **GET** /api/repository/v1/jobs/{id}/result | 
*RepositoryApi* | [**retrieve_snapshot**](docs/RepositoryApi.md#retrieve_snapshot) | **GET** /api/repository/v1/snapshots/{id} | 
*RepositoryApi* | [**retrieve_snapshot_policies**](docs/RepositoryApi.md#retrieve_snapshot_policies) | **GET** /api/repository/v1/snapshots/{id}/policies | 
*RepositoryApi* | [**retrieve_snapshot_summary**](docs/RepositoryApi.md#retrieve_snapshot_summary) | **GET** /api/repository/v1/snapshots/{id}/summary | 
*RepositoryApi* | [**retrieve_transaction**](docs/RepositoryApi.md#retrieve_transaction) | **GET** /api/repository/v1/datasets/{id}/transactions/{transactionId} | 
*RepositoryApi* | [**retrieve_user_dataset_roles**](docs/RepositoryApi.md#retrieve_user_dataset_roles) | **GET** /api/repository/v1/datasets/{id}/roles | 
*RepositoryApi* | [**retrieve_user_snapshot_roles**](docs/RepositoryApi.md#retrieve_user_snapshot_roles) | **GET** /api/repository/v1/snapshots/{id}/roles | 
*RepositoryApi* | [**set_config_list**](docs/RepositoryApi.md#set_config_list) | **PUT** /api/repository/v1/configs | 
*RepositoryApi* | [**set_fault**](docs/RepositoryApi.md#set_fault) | **PUT** /api/repository/v1/configs/{name} | 
*RepositoryApi* | [**set_inherit_steward**](docs/RepositoryApi.md#set_inherit_steward) | **PUT** /api/repository/v1/datasets/{id}/inheritSteward | 
*RepositoryApi* | [**set_snapshot_public**](docs/RepositoryApi.md#set_snapshot_public) | **PUT** /api/repository/v1/snapshots/{id}/public | 
*RepositoryApi* | [**sync_duos_dataset_authorized_users**](docs/RepositoryApi.md#sync_duos_dataset_authorized_users) | **PUT** /api/repository/v1/duos/{duosId}/syncAuthorizedUsers | 
*RepositoryApi* | [**sync_duos_datasets_authorized_users**](docs/RepositoryApi.md#sync_duos_datasets_authorized_users) | **PUT** /api/repository/v1/duos/syncAuthorizedUsers | 
*RepositoryApi* | [**unlink_duos_dataset_from_snapshot**](docs/RepositoryApi.md#unlink_duos_dataset_from_snapshot) | **DELETE** /api/repository/v1/snapshots/{id}/unlinkDuosDataset | 
*RepositoryApi* | [**unlock_dataset**](docs/RepositoryApi.md#unlock_dataset) | **PUT** /api/repository/v1/datasets/{id}/unlock | 
*RepositoryApi* | [**unlock_snapshot**](docs/RepositoryApi.md#unlock_snapshot) | **PUT** /api/repository/v1/snapshots/{id}/unlock | 
*RepositoryApi* | [**update_dataset_tags**](docs/RepositoryApi.md#update_dataset_tags) | **PATCH** /api/repository/v1/datasets/{id}/tags | 
*RepositoryApi* | [**update_schema**](docs/RepositoryApi.md#update_schema) | **POST** /api/repository/v1/datasets/{id}/updateSchema | 
*RepositoryApi* | [**update_snapshot_snapshot_builder_settings**](docs/RepositoryApi.md#update_snapshot_snapshot_builder_settings) | **PUT** /api/repository/v1/snapshots/{id}/snapshotBuilder/settings | 
*RepositoryApi* | [**update_snapshot_tags**](docs/RepositoryApi.md#update_snapshot_tags) | **PATCH** /api/repository/v1/snapshots/{id}/tags | 
*RepositoryApi* | [**upgrade**](docs/RepositoryApi.md#upgrade) | **POST** /api/repository/v1/upgrade | 
*RepositoryApi* | [**user**](docs/RepositoryApi.md#user) | **GET** /api/repository/v1/register/user | 
*ResourcesApi* | [**add_profile_policy_member**](docs/ResourcesApi.md#add_profile_policy_member) | **POST** /api/resources/v1/profiles/{id}/policies/{policyName}/members | 
*ResourcesApi* | [**create_profile**](docs/ResourcesApi.md#create_profile) | **POST** /api/resources/v1/profiles | 
*ResourcesApi* | [**delete_profile**](docs/ResourcesApi.md#delete_profile) | **DELETE** /api/resources/v1/profiles/{id} | 
*ResourcesApi* | [**delete_profile_policy_member**](docs/ResourcesApi.md#delete_profile_policy_member) | **DELETE** /api/resources/v1/profiles/{id}/policies/{policyName}/members/{memberEmail} | 
*ResourcesApi* | [**enumerate_profiles**](docs/ResourcesApi.md#enumerate_profiles) | **GET** /api/resources/v1/profiles | 
*ResourcesApi* | [**get_profile_resources**](docs/ResourcesApi.md#get_profile_resources) | **GET** /api/resources/v1/profiles/{id}/resources | 
*ResourcesApi* | [**retrieve_profile**](docs/ResourcesApi.md#retrieve_profile) | **GET** /api/resources/v1/profiles/{id} | 
*ResourcesApi* | [**retrieve_profile_policies**](docs/ResourcesApi.md#retrieve_profile_policies) | **GET** /api/resources/v1/profiles/{id}/policies | 
*ResourcesApi* | [**update_profile**](docs/ResourcesApi.md#update_profile) | **PUT** /api/resources/v1/profiles | 
*SearchApi* | [**lookup_dataset_data_by_id**](docs/SearchApi.md#lookup_dataset_data_by_id) | **GET** /api/repository/v1/datasets/{id}/data/{table} | 
*SearchApi* | [**lookup_snapshot_preview_by_id**](docs/SearchApi.md#lookup_snapshot_preview_by_id) | **GET** /api/repository/v1/snapshots/{id}/data/{table} | 
*SearchApi* | [**query_dataset_data_by_id**](docs/SearchApi.md#query_dataset_data_by_id) | **POST** /api/repository/v1/datasets/{id}/data/{table} | 
*SearchApi* | [**query_snapshot_data_by_id**](docs/SearchApi.md#query_snapshot_data_by_id) | **POST** /api/repository/v1/snapshots/{id}/data/{table} | 
*SnapshotsApi* | [**add_snapshot_auth_domain**](docs/SnapshotsApi.md#add_snapshot_auth_domain) | **PATCH** /api/repository/v1/snapshots/{id}/authDomain | 
*SnapshotsApi* | [**add_snapshot_policy_member**](docs/SnapshotsApi.md#add_snapshot_policy_member) | **POST** /api/repository/v1/snapshots/{id}/policies/{policyName}/members | 
*SnapshotsApi* | [**create_snapshot**](docs/SnapshotsApi.md#create_snapshot) | **POST** /api/repository/v1/snapshots | 
*SnapshotsApi* | [**delete_snapshot**](docs/SnapshotsApi.md#delete_snapshot) | **DELETE** /api/repository/v1/snapshots/{id} | 
*SnapshotsApi* | [**delete_snapshot_policy_member**](docs/SnapshotsApi.md#delete_snapshot_policy_member) | **DELETE** /api/repository/v1/snapshots/{id}/policies/{policyName}/members/{memberEmail} | 
*SnapshotsApi* | [**delete_snapshot_snapshot_builder_settings**](docs/SnapshotsApi.md#delete_snapshot_snapshot_builder_settings) | **DELETE** /api/repository/v1/snapshots/{id}/snapshotBuilder/settings | 
*SnapshotsApi* | [**enumerate_concepts**](docs/SnapshotsApi.md#enumerate_concepts) | **GET** /api/repository/v1/snapshots/{id}/snapshotBuilder/concepts | 
*SnapshotsApi* | [**enumerate_snapshots**](docs/SnapshotsApi.md#enumerate_snapshots) | **GET** /api/repository/v1/snapshots | 
*SnapshotsApi* | [**export_snapshot**](docs/SnapshotsApi.md#export_snapshot) | **GET** /api/repository/v1/snapshots/{id}/export | 
*SnapshotsApi* | [**get_concept_children**](docs/SnapshotsApi.md#get_concept_children) | **GET** /api/repository/v1/snapshots/{id}/snapshotBuilder/concepts/{conceptId}/children | 
*SnapshotsApi* | [**get_concept_hierarchy**](docs/SnapshotsApi.md#get_concept_hierarchy) | **GET** /api/repository/v1/snapshots/{id}/snapshotBuilder/concepts/{conceptId}/hierarchy | 
*SnapshotsApi* | [**get_snapshot_builder_count**](docs/SnapshotsApi.md#get_snapshot_builder_count) | **POST** /api/repository/v1/snapshots/{id}/snapshotBuilder/count | 
*SnapshotsApi* | [**get_snapshot_ids_and_roles**](docs/SnapshotsApi.md#get_snapshot_ids_and_roles) | **GET** /api/repository/v1/snapshots/roleMap | 
*SnapshotsApi* | [**get_snapshot_snapshot_builder_settings**](docs/SnapshotsApi.md#get_snapshot_snapshot_builder_settings) | **GET** /api/repository/v1/snapshots/{id}/snapshotBuilder/settings | 
*SnapshotsApi* | [**get_snapshot_tags**](docs/SnapshotsApi.md#get_snapshot_tags) | **GET** /api/repository/v1/snapshots/tags | 
*SnapshotsApi* | [**link_duos_dataset_to_snapshot**](docs/SnapshotsApi.md#link_duos_dataset_to_snapshot) | **PUT** /api/repository/v1/snapshots/{id}/linkDuosDataset/{duosId} | 
*SnapshotsApi* | [**list_files**](docs/SnapshotsApi.md#list_files) | **GET** /api/repository/v1/snapshots/{id}/files | 
*SnapshotsApi* | [**lock_snapshot**](docs/SnapshotsApi.md#lock_snapshot) | **PUT** /api/repository/v1/snapshots/{id}/lock | 
*SnapshotsApi* | [**lookup_snapshot_file_by_id**](docs/SnapshotsApi.md#lookup_snapshot_file_by_id) | **GET** /api/repository/v1/snapshots/{id}/files/{fileid} | 
*SnapshotsApi* | [**lookup_snapshot_file_by_path**](docs/SnapshotsApi.md#lookup_snapshot_file_by_path) | **GET** /api/repository/v1/snapshots/{id}/filesystem/objects | 
*SnapshotsApi* | [**lookup_snapshot_preview_by_id**](docs/SnapshotsApi.md#lookup_snapshot_preview_by_id) | **GET** /api/repository/v1/snapshots/{id}/data/{table} | 
*SnapshotsApi* | [**patch_snapshot**](docs/SnapshotsApi.md#patch_snapshot) | **PATCH** /api/repository/v1/snapshots/{id} | 
*SnapshotsApi* | [**query_snapshot_data_by_id**](docs/SnapshotsApi.md#query_snapshot_data_by_id) | **POST** /api/repository/v1/snapshots/{id}/data/{table} | 
*SnapshotsApi* | [**retrieve_snapshot**](docs/SnapshotsApi.md#retrieve_snapshot) | **GET** /api/repository/v1/snapshots/{id} | 
*SnapshotsApi* | [**retrieve_snapshot_policies**](docs/SnapshotsApi.md#retrieve_snapshot_policies) | **GET** /api/repository/v1/snapshots/{id}/policies | 
*SnapshotsApi* | [**retrieve_snapshot_summary**](docs/SnapshotsApi.md#retrieve_snapshot_summary) | **GET** /api/repository/v1/snapshots/{id}/summary | 
*SnapshotsApi* | [**retrieve_user_snapshot_roles**](docs/SnapshotsApi.md#retrieve_user_snapshot_roles) | **GET** /api/repository/v1/snapshots/{id}/roles | 
*SnapshotsApi* | [**set_snapshot_public**](docs/SnapshotsApi.md#set_snapshot_public) | **PUT** /api/repository/v1/snapshots/{id}/public | 
*SnapshotsApi* | [**unlink_duos_dataset_from_snapshot**](docs/SnapshotsApi.md#unlink_duos_dataset_from_snapshot) | **DELETE** /api/repository/v1/snapshots/{id}/unlinkDuosDataset | 
*SnapshotsApi* | [**unlock_snapshot**](docs/SnapshotsApi.md#unlock_snapshot) | **PUT** /api/repository/v1/snapshots/{id}/unlock | 
*SnapshotsApi* | [**update_snapshot_snapshot_builder_settings**](docs/SnapshotsApi.md#update_snapshot_snapshot_builder_settings) | **PUT** /api/repository/v1/snapshots/{id}/snapshotBuilder/settings | 
*SnapshotsApi* | [**update_snapshot_tags**](docs/SnapshotsApi.md#update_snapshot_tags) | **PATCH** /api/repository/v1/snapshots/{id}/tags | 
*UnauthenticatedApi* | [**retrieve_repository_config**](docs/UnauthenticatedApi.md#retrieve_repository_config) | **GET** /configuration | 
*UnauthenticatedApi* | [**service_status**](docs/UnauthenticatedApi.md#service_status) | **GET** /status | 
*UnauthenticatedApi* | [**shutdown_request**](docs/UnauthenticatedApi.md#shutdown_request) | **GET** /shutdown | 
*UpgradeApi* | [**upgrade**](docs/UpgradeApi.md#upgrade) | **POST** /api/repository/v1/upgrade | 


## Documentation For Models

 - [AccessInfoBigQueryModel](docs/AccessInfoBigQueryModel.md)
 - [AccessInfoBigQueryModelTable](docs/AccessInfoBigQueryModelTable.md)
 - [AccessInfoModel](docs/AccessInfoModel.md)
 - [AccessInfoParquetModel](docs/AccessInfoParquetModel.md)
 - [AccessInfoParquetModelTable](docs/AccessInfoParquetModelTable.md)
 - [AddAuthDomainResponseModel](docs/AddAuthDomainResponseModel.md)
 - [AssetModel](docs/AssetModel.md)
 - [AssetTableModel](docs/AssetTableModel.md)
 - [BillingProfileModel](docs/BillingProfileModel.md)
 - [BillingProfileRequestModel](docs/BillingProfileRequestModel.md)
 - [BillingProfileUpdateModel](docs/BillingProfileUpdateModel.md)
 - [BulkLoadArrayRequestModel](docs/BulkLoadArrayRequestModel.md)
 - [BulkLoadArrayResultModel](docs/BulkLoadArrayResultModel.md)
 - [BulkLoadFileModel](docs/BulkLoadFileModel.md)
 - [BulkLoadFileResultModel](docs/BulkLoadFileResultModel.md)
 - [BulkLoadFileState](docs/BulkLoadFileState.md)
 - [BulkLoadHistoryModel](docs/BulkLoadHistoryModel.md)
 - [BulkLoadHistoryModelList](docs/BulkLoadHistoryModelList.md)
 - [BulkLoadRequestModel](docs/BulkLoadRequestModel.md)
 - [BulkLoadResultModel](docs/BulkLoadResultModel.md)
 - [CloudPlatform](docs/CloudPlatform.md)
 - [ColumnModel](docs/ColumnModel.md)
 - [ColumnStatisticsDoubleModel](docs/ColumnStatisticsDoubleModel.md)
 - [ColumnStatisticsDoubleModelAllOf](docs/ColumnStatisticsDoubleModelAllOf.md)
 - [ColumnStatisticsIntModel](docs/ColumnStatisticsIntModel.md)
 - [ColumnStatisticsIntModelAllOf](docs/ColumnStatisticsIntModelAllOf.md)
 - [ColumnStatisticsModel](docs/ColumnStatisticsModel.md)
 - [ColumnStatisticsTextModel](docs/ColumnStatisticsTextModel.md)
 - [ColumnStatisticsTextModelAllOf](docs/ColumnStatisticsTextModelAllOf.md)
 - [ColumnStatisticsTextValue](docs/ColumnStatisticsTextValue.md)
 - [ConfigEnableModel](docs/ConfigEnableModel.md)
 - [ConfigFaultCountedModel](docs/ConfigFaultCountedModel.md)
 - [ConfigFaultModel](docs/ConfigFaultModel.md)
 - [ConfigGroupModel](docs/ConfigGroupModel.md)
 - [ConfigListModel](docs/ConfigListModel.md)
 - [ConfigModel](docs/ConfigModel.md)
 - [ConfigParameterModel](docs/ConfigParameterModel.md)
 - [DRSAccessMethod](docs/DRSAccessMethod.md)
 - [DRSAccessURL](docs/DRSAccessURL.md)
 - [DRSAuthorizations](docs/DRSAuthorizations.md)
 - [DRSChecksum](docs/DRSChecksum.md)
 - [DRSContentsObject](docs/DRSContentsObject.md)
 - [DRSError](docs/DRSError.md)
 - [DRSObject](docs/DRSObject.md)
 - [DRSPassportRequestModel](docs/DRSPassportRequestModel.md)
 - [DRSServiceInfo](docs/DRSServiceInfo.md)
 - [DataDeletionGcsFileModel](docs/DataDeletionGcsFileModel.md)
 - [DataDeletionJsonArrayModel](docs/DataDeletionJsonArrayModel.md)
 - [DataDeletionRequest](docs/DataDeletionRequest.md)
 - [DataDeletionTableModel](docs/DataDeletionTableModel.md)
 - [DatasetDataModel](docs/DatasetDataModel.md)
 - [DatasetModel](docs/DatasetModel.md)
 - [DatasetPatchRequestModel](docs/DatasetPatchRequestModel.md)
 - [DatasetRequestAccessIncludeModel](docs/DatasetRequestAccessIncludeModel.md)
 - [DatasetRequestModel](docs/DatasetRequestModel.md)
 - [DatasetRequestModelPolicies](docs/DatasetRequestModelPolicies.md)
 - [DatasetSchemaColumnUpdateModel](docs/DatasetSchemaColumnUpdateModel.md)
 - [DatasetSchemaUpdateModel](docs/DatasetSchemaUpdateModel.md)
 - [DatasetSchemaUpdateModelChanges](docs/DatasetSchemaUpdateModelChanges.md)
 - [DatasetSpecificationModel](docs/DatasetSpecificationModel.md)
 - [DatasetSummaryModel](docs/DatasetSummaryModel.md)
 - [DatePartitionOptionsModel](docs/DatePartitionOptionsModel.md)
 - [DeleteResponseModel](docs/DeleteResponseModel.md)
 - [DirectoryDetailModel](docs/DirectoryDetailModel.md)
 - [DrsAliasModel](docs/DrsAliasModel.md)
 - [DuosFirecloudGroupModel](docs/DuosFirecloudGroupModel.md)
 - [DuosFirecloudGroupsSyncResponse](docs/DuosFirecloudGroupsSyncResponse.md)
 - [EnumerateBillingProfileModel](docs/EnumerateBillingProfileModel.md)
 - [EnumerateBillingProfileResourcesModel](docs/EnumerateBillingProfileResourcesModel.md)
 - [EnumerateDatasetModel](docs/EnumerateDatasetModel.md)
 - [EnumerateSnapshotAccessRequest](docs/EnumerateSnapshotAccessRequest.md)
 - [EnumerateSnapshotModel](docs/EnumerateSnapshotModel.md)
 - [EnumerateSortByParam](docs/EnumerateSortByParam.md)
 - [ErrorModel](docs/ErrorModel.md)
 - [FileDetailModel](docs/FileDetailModel.md)
 - [FileLoadModel](docs/FileLoadModel.md)
 - [FileModel](docs/FileModel.md)
 - [FileModelType](docs/FileModelType.md)
 - [IamResourceTypeEnum](docs/IamResourceTypeEnum.md)
 - [InaccessibleWorkspacePolicyModel](docs/InaccessibleWorkspacePolicyModel.md)
 - [IngestRequestModel](docs/IngestRequestModel.md)
 - [IngestResponseModel](docs/IngestResponseModel.md)
 - [IntPartitionOptionsModel](docs/IntPartitionOptionsModel.md)
 - [JobModel](docs/JobModel.md)
 - [JobTargetResourceModel](docs/JobTargetResourceModel.md)
 - [JournalEntryModel](docs/JournalEntryModel.md)
 - [PolicyMemberRequest](docs/PolicyMemberRequest.md)
 - [PolicyModel](docs/PolicyModel.md)
 - [PolicyResponse](docs/PolicyResponse.md)
 - [ProfileOwnedResourceModel](docs/ProfileOwnedResourceModel.md)
 - [QueryColumnStatisticsRequestModel](docs/QueryColumnStatisticsRequestModel.md)
 - [QueryDataRequestModel](docs/QueryDataRequestModel.md)
 - [RelationshipModel](docs/RelationshipModel.md)
 - [RelationshipTermModel](docs/RelationshipTermModel.md)
 - [RepositoryConfigurationModel](docs/RepositoryConfigurationModel.md)
 - [RepositoryStatusModel](docs/RepositoryStatusModel.md)
 - [RepositoryStatusModelSystems](docs/RepositoryStatusModelSystems.md)
 - [ResourceLocks](docs/ResourceLocks.md)
 - [ResourcePolicyModel](docs/ResourcePolicyModel.md)
 - [SamPolicyModel](docs/SamPolicyModel.md)
 - [SnapshotAccessRequest](docs/SnapshotAccessRequest.md)
 - [SnapshotAccessRequestDetailsResponse](docs/SnapshotAccessRequestDetailsResponse.md)
 - [SnapshotAccessRequestMembersResponse](docs/SnapshotAccessRequestMembersResponse.md)
 - [SnapshotAccessRequestResponse](docs/SnapshotAccessRequestResponse.md)
 - [SnapshotAccessRequestStatus](docs/SnapshotAccessRequestStatus.md)
 - [SnapshotBuilderCohort](docs/SnapshotBuilderCohort.md)
 - [SnapshotBuilderConcept](docs/SnapshotBuilderConcept.md)
 - [SnapshotBuilderConceptsResponse](docs/SnapshotBuilderConceptsResponse.md)
 - [SnapshotBuilderCountRequest](docs/SnapshotBuilderCountRequest.md)
 - [SnapshotBuilderCountResponse](docs/SnapshotBuilderCountResponse.md)
 - [SnapshotBuilderCountResponseResult](docs/SnapshotBuilderCountResponseResult.md)
 - [SnapshotBuilderCriteria](docs/SnapshotBuilderCriteria.md)
 - [SnapshotBuilderCriteriaGroup](docs/SnapshotBuilderCriteriaGroup.md)
 - [SnapshotBuilderDatasetConceptSet](docs/SnapshotBuilderDatasetConceptSet.md)
 - [SnapshotBuilderDomainCriteria](docs/SnapshotBuilderDomainCriteria.md)
 - [SnapshotBuilderDomainCriteriaAllOf](docs/SnapshotBuilderDomainCriteriaAllOf.md)
 - [SnapshotBuilderDomainOption](docs/SnapshotBuilderDomainOption.md)
 - [SnapshotBuilderDomainOptionAllOf](docs/SnapshotBuilderDomainOptionAllOf.md)
 - [SnapshotBuilderGetConceptHierarchyResponse](docs/SnapshotBuilderGetConceptHierarchyResponse.md)
 - [SnapshotBuilderOption](docs/SnapshotBuilderOption.md)
 - [SnapshotBuilderOutputTable](docs/SnapshotBuilderOutputTable.md)
 - [SnapshotBuilderParentConcept](docs/SnapshotBuilderParentConcept.md)
 - [SnapshotBuilderProgramDataListCriteria](docs/SnapshotBuilderProgramDataListCriteria.md)
 - [SnapshotBuilderProgramDataListCriteriaAllOf](docs/SnapshotBuilderProgramDataListCriteriaAllOf.md)
 - [SnapshotBuilderProgramDataListItem](docs/SnapshotBuilderProgramDataListItem.md)
 - [SnapshotBuilderProgramDataListOption](docs/SnapshotBuilderProgramDataListOption.md)
 - [SnapshotBuilderProgramDataListOptionAllOf](docs/SnapshotBuilderProgramDataListOptionAllOf.md)
 - [SnapshotBuilderProgramDataOption](docs/SnapshotBuilderProgramDataOption.md)
 - [SnapshotBuilderProgramDataOptionAllOf](docs/SnapshotBuilderProgramDataOptionAllOf.md)
 - [SnapshotBuilderProgramDataRangeCriteria](docs/SnapshotBuilderProgramDataRangeCriteria.md)
 - [SnapshotBuilderProgramDataRangeCriteriaAllOf](docs/SnapshotBuilderProgramDataRangeCriteriaAllOf.md)
 - [SnapshotBuilderProgramDataRangeOption](docs/SnapshotBuilderProgramDataRangeOption.md)
 - [SnapshotBuilderProgramDataRangeOptionAllOf](docs/SnapshotBuilderProgramDataRangeOptionAllOf.md)
 - [SnapshotBuilderRequest](docs/SnapshotBuilderRequest.md)
 - [SnapshotBuilderRootTable](docs/SnapshotBuilderRootTable.md)
 - [SnapshotBuilderRootTableAllOf](docs/SnapshotBuilderRootTableAllOf.md)
 - [SnapshotBuilderSettings](docs/SnapshotBuilderSettings.md)
 - [SnapshotBuilderTable](docs/SnapshotBuilderTable.md)
 - [SnapshotExportResponseModel](docs/SnapshotExportResponseModel.md)
 - [SnapshotExportResponseModelFormat](docs/SnapshotExportResponseModelFormat.md)
 - [SnapshotExportResponseModelFormatParquet](docs/SnapshotExportResponseModelFormatParquet.md)
 - [SnapshotExportResponseModelFormatParquetLocation](docs/SnapshotExportResponseModelFormatParquetLocation.md)
 - [SnapshotExportResponseModelFormatParquetLocationTables](docs/SnapshotExportResponseModelFormatParquetLocationTables.md)
 - [SnapshotExportResponseModelFormatWorkspace](docs/SnapshotExportResponseModelFormatWorkspace.md)
 - [SnapshotIdsAndRolesModel](docs/SnapshotIdsAndRolesModel.md)
 - [SnapshotLinkDuosDatasetResponse](docs/SnapshotLinkDuosDatasetResponse.md)
 - [SnapshotModel](docs/SnapshotModel.md)
 - [SnapshotPatchRequestModel](docs/SnapshotPatchRequestModel.md)
 - [SnapshotPreviewModel](docs/SnapshotPreviewModel.md)
 - [SnapshotRequestAssetModel](docs/SnapshotRequestAssetModel.md)
 - [SnapshotRequestContentsModel](docs/SnapshotRequestContentsModel.md)
 - [SnapshotRequestIdModel](docs/SnapshotRequestIdModel.md)
 - [SnapshotRequestModel](docs/SnapshotRequestModel.md)
 - [SnapshotRequestModelPolicies](docs/SnapshotRequestModelPolicies.md)
 - [SnapshotRequestQueryModel](docs/SnapshotRequestQueryModel.md)
 - [SnapshotRequestRowIdModel](docs/SnapshotRequestRowIdModel.md)
 - [SnapshotRequestRowIdTableModel](docs/SnapshotRequestRowIdTableModel.md)
 - [SnapshotRetrieveIncludeModel](docs/SnapshotRetrieveIncludeModel.md)
 - [SnapshotSourceModel](docs/SnapshotSourceModel.md)
 - [SnapshotSummaryModel](docs/SnapshotSummaryModel.md)
 - [SqlSortDirectionAscDefault](docs/SqlSortDirectionAscDefault.md)
 - [SqlSortDirectionDescDefault](docs/SqlSortDirectionDescDefault.md)
 - [StorageResourceModel](docs/StorageResourceModel.md)
 - [TableDataType](docs/TableDataType.md)
 - [TableModel](docs/TableModel.md)
 - [TagCount](docs/TagCount.md)
 - [TagCountResultModel](docs/TagCountResultModel.md)
 - [TagUpdateRequestModel](docs/TagUpdateRequestModel.md)
 - [TransactionCloseModel](docs/TransactionCloseModel.md)
 - [TransactionCreateModel](docs/TransactionCreateModel.md)
 - [TransactionModel](docs/TransactionModel.md)
 - [UnlockResourceRequest](docs/UnlockResourceRequest.md)
 - [UpgradeModel](docs/UpgradeModel.md)
 - [UpgradeResponseModel](docs/UpgradeResponseModel.md)
 - [UserStatusInfo](docs/UserStatusInfo.md)
 - [WorkspacePolicyModel](docs/WorkspacePolicyModel.md)


## Documentation For Authorization


## oidc

- **Type**: OAuth
- **Flow**: accessCode
- **Authorization URL**: /oauth2/authorize
- **Scopes**: 
 - **openid**: open id authorization
 - **email**: email authorization
 - **profile**: profile authorization


## Author




