# coding: utf-8

"""
    Data Repository API

    <details><summary>This document defines the REST API for the Terra Data Repository.</summary> <p> **Status: design in progress** There are a few top-level endpoints (besides some used by swagger):  * / - generated by swagger: swagger API page that provides this documentation and a live UI for submitting REST requests  * /status - provides the operational status of the service  * /configuration - provides the basic configuration and information about the service  * /api - is the authenticated and authorized Data Repository API  * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API  The API endpoints are organized by interface. Each interface is separately versioned. <p> **Notes on Naming** <p> All of the reference items are suffixed with \\\"Model\\\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. </details>   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from data_repo_client.configuration import Configuration


class BulkLoadFileModel(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'source_path': 'str',
        'target_path': 'str',
        'mime_type': 'str',
        'description': 'str',
        'md5': 'str'
    }

    attribute_map = {
        'source_path': 'sourcePath',
        'target_path': 'targetPath',
        'mime_type': 'mimeType',
        'description': 'description',
        'md5': 'md5'
    }

    def __init__(self, source_path=None, target_path=None, mime_type=None, description=None, md5=None, local_vars_configuration=None):  # noqa: E501
        """BulkLoadFileModel - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._source_path = None
        self._target_path = None
        self._mime_type = None
        self._description = None
        self._md5 = None
        self.discriminator = None

        self.source_path = source_path
        self.target_path = target_path
        if mime_type is not None:
            self.mime_type = mime_type
        if description is not None:
            self.description = description
        if md5 is not None:
            self.md5 = md5

    @property
    def source_path(self):
        """Gets the source_path of this BulkLoadFileModel.  # noqa: E501

        gs URL of the source file to load  # noqa: E501

        :return: The source_path of this BulkLoadFileModel.  # noqa: E501
        :rtype: str
        """
        return self._source_path

    @source_path.setter
    def source_path(self, source_path):
        """Sets the source_path of this BulkLoadFileModel.

        gs URL of the source file to load  # noqa: E501

        :param source_path: The source_path of this BulkLoadFileModel.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and source_path is None:  # noqa: E501
            raise ValueError("Invalid value for `source_path`, must not be `None`")  # noqa: E501

        self._source_path = source_path

    @property
    def target_path(self):
        """Gets the target_path of this BulkLoadFileModel.  # noqa: E501

        Full path within the dataset where the file should be placed. The path must start with /.   # noqa: E501

        :return: The target_path of this BulkLoadFileModel.  # noqa: E501
        :rtype: str
        """
        return self._target_path

    @target_path.setter
    def target_path(self, target_path):
        """Sets the target_path of this BulkLoadFileModel.

        Full path within the dataset where the file should be placed. The path must start with /.   # noqa: E501

        :param target_path: The target_path of this BulkLoadFileModel.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and target_path is None:  # noqa: E501
            raise ValueError("Invalid value for `target_path`, must not be `None`")  # noqa: E501

        self._target_path = target_path

    @property
    def mime_type(self):
        """Gets the mime_type of this BulkLoadFileModel.  # noqa: E501

        A string providing the mime-type of the Data Object. For example, \"application/json\".  # noqa: E501

        :return: The mime_type of this BulkLoadFileModel.  # noqa: E501
        :rtype: str
        """
        return self._mime_type

    @mime_type.setter
    def mime_type(self, mime_type):
        """Sets the mime_type of this BulkLoadFileModel.

        A string providing the mime-type of the Data Object. For example, \"application/json\".  # noqa: E501

        :param mime_type: The mime_type of this BulkLoadFileModel.  # noqa: E501
        :type: str
        """

        self._mime_type = mime_type

    @property
    def description(self):
        """Gets the description of this BulkLoadFileModel.  # noqa: E501

        A human readable description of the contents of the Data Object.  # noqa: E501

        :return: The description of this BulkLoadFileModel.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this BulkLoadFileModel.

        A human readable description of the contents of the Data Object.  # noqa: E501

        :param description: The description of this BulkLoadFileModel.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def md5(self):
        """Gets the md5 of this BulkLoadFileModel.  # noqa: E501

        A hex representation of the  md5 for the file.  If an md5 exists for the file being ingested, it will be validated against this value and the file's ingest will fail if the values do not match.  If no md5 hash is present on the file being ingested, this value will be stored for the file.  If this value is not specified, then the md5 from the file being ingested (from the cloud provider) will be used   # noqa: E501

        :return: The md5 of this BulkLoadFileModel.  # noqa: E501
        :rtype: str
        """
        return self._md5

    @md5.setter
    def md5(self, md5):
        """Sets the md5 of this BulkLoadFileModel.

        A hex representation of the  md5 for the file.  If an md5 exists for the file being ingested, it will be validated against this value and the file's ingest will fail if the values do not match.  If no md5 hash is present on the file being ingested, this value will be stored for the file.  If this value is not specified, then the md5 from the file being ingested (from the cloud provider) will be used   # noqa: E501

        :param md5: The md5 of this BulkLoadFileModel.  # noqa: E501
        :type: str
        """

        self._md5 = md5

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BulkLoadFileModel):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, BulkLoadFileModel):
            return True

        return self.to_dict() != other.to_dict()
