# coding: utf-8

"""
    Data Repository API

    <details><summary>This document defines the REST API for the Terra Data Repository.</summary> <p> **Status: design in progress** There are a few top-level endpoints (besides some used by swagger):  * / - generated by swagger: swagger API page that provides this documentation and a live UI for submitting REST requests  * /status - provides the operational status of the service  * /configuration - provides the basic configuration and information about the service  * /api - is the authenticated and authorized Data Repository API  * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API  The API endpoints are organized by interface. Each interface is separately versioned. <p> **Notes on Naming** <p> All of the reference items are suffixed with \\\"Model\\\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. </details>   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from data_repo_client.configuration import Configuration


class DRSAuthorizations(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'supported_types': 'list[str]',
        'passport_auth_issuers': 'list[str]',
        'bearer_auth_issuers': 'list[str]'
    }

    attribute_map = {
        'supported_types': 'supported_types',
        'passport_auth_issuers': 'passport_auth_issuers',
        'bearer_auth_issuers': 'bearer_auth_issuers'
    }

    def __init__(self, supported_types=None, passport_auth_issuers=None, bearer_auth_issuers=None, local_vars_configuration=None):  # noqa: E501
        """DRSAuthorizations - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._supported_types = None
        self._passport_auth_issuers = None
        self._bearer_auth_issuers = None
        self.discriminator = None

        if supported_types is not None:
            self.supported_types = supported_types
        if passport_auth_issuers is not None:
            self.passport_auth_issuers = passport_auth_issuers
        if bearer_auth_issuers is not None:
            self.bearer_auth_issuers = bearer_auth_issuers

    @property
    def supported_types(self):
        """Gets the supported_types of this DRSAuthorizations.  # noqa: E501

        An Optional list of supported authorization types. More than one can be supported and tried in sequence. Defaults to `None` if empty or missing.  # noqa: E501

        :return: The supported_types of this DRSAuthorizations.  # noqa: E501
        :rtype: list[str]
        """
        return self._supported_types

    @supported_types.setter
    def supported_types(self, supported_types):
        """Sets the supported_types of this DRSAuthorizations.

        An Optional list of supported authorization types. More than one can be supported and tried in sequence. Defaults to `None` if empty or missing.  # noqa: E501

        :param supported_types: The supported_types of this DRSAuthorizations.  # noqa: E501
        :type: list[str]
        """
        allowed_values = ["None", "BasicAuth", "BearerAuth", "PassportAuth"]  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                not set(supported_types).issubset(set(allowed_values))):  # noqa: E501
            raise ValueError(
                "Invalid values for `supported_types` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(supported_types) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._supported_types = supported_types

    @property
    def passport_auth_issuers(self):
        """Gets the passport_auth_issuers of this DRSAuthorizations.  # noqa: E501

        If authorizations contain `PassportAuth`, this is a required list of visa issuers (as found in a visa's `iss` claim) that may authorize access to this object. The caller must only provide passports that contain visas from this list. It is strongly recommended that the caller validate that it is appropriate to send the requested passport/visa to the DRS server to mitigate attacks by malicious DRS servers requesting credentials they should not have.  # noqa: E501

        :return: The passport_auth_issuers of this DRSAuthorizations.  # noqa: E501
        :rtype: list[str]
        """
        return self._passport_auth_issuers

    @passport_auth_issuers.setter
    def passport_auth_issuers(self, passport_auth_issuers):
        """Sets the passport_auth_issuers of this DRSAuthorizations.

        If authorizations contain `PassportAuth`, this is a required list of visa issuers (as found in a visa's `iss` claim) that may authorize access to this object. The caller must only provide passports that contain visas from this list. It is strongly recommended that the caller validate that it is appropriate to send the requested passport/visa to the DRS server to mitigate attacks by malicious DRS servers requesting credentials they should not have.  # noqa: E501

        :param passport_auth_issuers: The passport_auth_issuers of this DRSAuthorizations.  # noqa: E501
        :type: list[str]
        """

        self._passport_auth_issuers = passport_auth_issuers

    @property
    def bearer_auth_issuers(self):
        """Gets the bearer_auth_issuers of this DRSAuthorizations.  # noqa: E501

        If authorizations contain `BearerAuth`, this is an optional list of issuers that may authorize access to this object. The caller must provide a token from one of these issuers. If this is empty or missing it is assumed that the caller knows which token to send via other means. It is strongly recommended that the caller validate that it is appropriate to send the requested token to the DRS server to mitigate attacks by malicious DRS servers requesting credentials they should not have.  # noqa: E501

        :return: The bearer_auth_issuers of this DRSAuthorizations.  # noqa: E501
        :rtype: list[str]
        """
        return self._bearer_auth_issuers

    @bearer_auth_issuers.setter
    def bearer_auth_issuers(self, bearer_auth_issuers):
        """Sets the bearer_auth_issuers of this DRSAuthorizations.

        If authorizations contain `BearerAuth`, this is an optional list of issuers that may authorize access to this object. The caller must provide a token from one of these issuers. If this is empty or missing it is assumed that the caller knows which token to send via other means. It is strongly recommended that the caller validate that it is appropriate to send the requested token to the DRS server to mitigate attacks by malicious DRS servers requesting credentials they should not have.  # noqa: E501

        :param bearer_auth_issuers: The bearer_auth_issuers of this DRSAuthorizations.  # noqa: E501
        :type: list[str]
        """

        self._bearer_auth_issuers = bearer_auth_issuers

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DRSAuthorizations):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, DRSAuthorizations):
            return True

        return self.to_dict() != other.to_dict()
