# coding: utf-8

"""
    Data Repository API

    <details><summary>This document defines the REST API for the Terra Data Repository.</summary> <p> **Status: design in progress** There are a few top-level endpoints (besides some used by swagger):  * / - generated by swagger: swagger API page that provides this documentation and a live UI for submitting REST requests  * /status - provides the operational status of the service  * /configuration - provides the basic configuration and information about the service  * /api - is the authenticated and authorized Data Repository API  * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API  The API endpoints are organized by interface. Each interface is separately versioned. <p> **Notes on Naming** <p> All of the reference items are suffixed with \\\"Model\\\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. </details>   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from data_repo_client.configuration import Configuration


class FileDetailModel(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'dataset_id': 'str',
        'mime_type': 'str',
        'access_url': 'str',
        'load_tag': 'str'
    }

    attribute_map = {
        'dataset_id': 'datasetId',
        'mime_type': 'mimeType',
        'access_url': 'accessUrl',
        'load_tag': 'loadTag'
    }

    def __init__(self, dataset_id=None, mime_type=None, access_url=None, load_tag=None, local_vars_configuration=None):  # noqa: E501
        """FileDetailModel - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._dataset_id = None
        self._mime_type = None
        self._access_url = None
        self._load_tag = None
        self.discriminator = None

        if dataset_id is not None:
            self.dataset_id = dataset_id
        if mime_type is not None:
            self.mime_type = mime_type
        if access_url is not None:
            self.access_url = access_url
        if load_tag is not None:
            self.load_tag = load_tag

    @property
    def dataset_id(self):
        """Gets the dataset_id of this FileDetailModel.  # noqa: E501

        Id of the dataset that holds the file  # noqa: E501

        :return: The dataset_id of this FileDetailModel.  # noqa: E501
        :rtype: str
        """
        return self._dataset_id

    @dataset_id.setter
    def dataset_id(self, dataset_id):
        """Sets the dataset_id of this FileDetailModel.

        Id of the dataset that holds the file  # noqa: E501

        :param dataset_id: The dataset_id of this FileDetailModel.  # noqa: E501
        :type: str
        """

        self._dataset_id = dataset_id

    @property
    def mime_type(self):
        """Gets the mime_type of this FileDetailModel.  # noqa: E501


        :return: The mime_type of this FileDetailModel.  # noqa: E501
        :rtype: str
        """
        return self._mime_type

    @mime_type.setter
    def mime_type(self, mime_type):
        """Sets the mime_type of this FileDetailModel.


        :param mime_type: The mime_type of this FileDetailModel.  # noqa: E501
        :type: str
        """

        self._mime_type = mime_type

    @property
    def access_url(self):
        """Gets the access_url of this FileDetailModel.  # noqa: E501

        URL of the file in cloud storage  # noqa: E501

        :return: The access_url of this FileDetailModel.  # noqa: E501
        :rtype: str
        """
        return self._access_url

    @access_url.setter
    def access_url(self, access_url):
        """Sets the access_url of this FileDetailModel.

        URL of the file in cloud storage  # noqa: E501

        :param access_url: The access_url of this FileDetailModel.  # noqa: E501
        :type: str
        """

        self._access_url = access_url

    @property
    def load_tag(self):
        """Gets the load_tag of this FileDetailModel.  # noqa: E501

        client-specified tag for a data or file load. If no id is specified, we use the string form of the job create time as the tag.   # noqa: E501

        :return: The load_tag of this FileDetailModel.  # noqa: E501
        :rtype: str
        """
        return self._load_tag

    @load_tag.setter
    def load_tag(self, load_tag):
        """Sets the load_tag of this FileDetailModel.

        client-specified tag for a data or file load. If no id is specified, we use the string form of the job create time as the tag.   # noqa: E501

        :param load_tag: The load_tag of this FileDetailModel.  # noqa: E501
        :type: str
        """

        self._load_tag = load_tag

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FileDetailModel):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, FileDetailModel):
            return True

        return self.to_dict() != other.to_dict()
