# coding: utf-8

"""
    Data Repository API

    <details><summary>This document defines the REST API for the Terra Data Repository.</summary> <p> **Status: design in progress** There are a few top-level endpoints (besides some used by swagger):  * / - generated by swagger: swagger API page that provides this documentation and a live UI for submitting REST requests  * /status - provides the operational status of the service  * /configuration - provides the basic configuration and information about the service  * /api - is the authenticated and authorized Data Repository API  * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API  The API endpoints are organized by interface. Each interface is separately versioned. <p> **Notes on Naming** <p> All of the reference items are suffixed with \\\"Model\\\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. </details>   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from data_repo_client.configuration import Configuration


class FileModel(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'file_id': 'str',
        'collection_id': 'str',
        'path': 'str',
        'size': 'int',
        'checksums': 'list[DRSChecksum]',
        'created': 'str',
        'description': 'str',
        'file_type': 'FileModelType',
        'file_detail': 'FileDetailModel',
        'directory_detail': 'DirectoryDetailModel'
    }

    attribute_map = {
        'file_id': 'fileId',
        'collection_id': 'collectionId',
        'path': 'path',
        'size': 'size',
        'checksums': 'checksums',
        'created': 'created',
        'description': 'description',
        'file_type': 'fileType',
        'file_detail': 'fileDetail',
        'directory_detail': 'directoryDetail'
    }

    def __init__(self, file_id=None, collection_id=None, path=None, size=None, checksums=None, created=None, description=None, file_type=None, file_detail=None, directory_detail=None, local_vars_configuration=None):  # noqa: E501
        """FileModel - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._file_id = None
        self._collection_id = None
        self._path = None
        self._size = None
        self._checksums = None
        self._created = None
        self._description = None
        self._file_type = None
        self._file_detail = None
        self._directory_detail = None
        self.discriminator = None

        if file_id is not None:
            self.file_id = file_id
        if collection_id is not None:
            self.collection_id = collection_id
        if path is not None:
            self.path = path
        if size is not None:
            self.size = size
        if checksums is not None:
            self.checksums = checksums
        if created is not None:
            self.created = created
        if description is not None:
            self.description = description
        if file_type is not None:
            self.file_type = file_type
        if file_detail is not None:
            self.file_detail = file_detail
        if directory_detail is not None:
            self.directory_detail = directory_detail

    @property
    def file_id(self):
        """Gets the file_id of this FileModel.  # noqa: E501

        Unique id of the filesystem object within the dataset  # noqa: E501

        :return: The file_id of this FileModel.  # noqa: E501
        :rtype: str
        """
        return self._file_id

    @file_id.setter
    def file_id(self, file_id):
        """Sets the file_id of this FileModel.

        Unique id of the filesystem object within the dataset  # noqa: E501

        :param file_id: The file_id of this FileModel.  # noqa: E501
        :type: str
        """

        self._file_id = file_id

    @property
    def collection_id(self):
        """Gets the collection_id of this FileModel.  # noqa: E501

        Id of the dataset or snapshot directory describing the object  # noqa: E501

        :return: The collection_id of this FileModel.  # noqa: E501
        :rtype: str
        """
        return self._collection_id

    @collection_id.setter
    def collection_id(self, collection_id):
        """Sets the collection_id of this FileModel.

        Id of the dataset or snapshot directory describing the object  # noqa: E501

        :param collection_id: The collection_id of this FileModel.  # noqa: E501
        :type: str
        """

        self._collection_id = collection_id

    @property
    def path(self):
        """Gets the path of this FileModel.  # noqa: E501

        full path of the file in the dataset  # noqa: E501

        :return: The path of this FileModel.  # noqa: E501
        :rtype: str
        """
        return self._path

    @path.setter
    def path(self, path):
        """Sets the path of this FileModel.

        full path of the file in the dataset  # noqa: E501

        :param path: The path of this FileModel.  # noqa: E501
        :type: str
        """

        self._path = path

    @property
    def size(self):
        """Gets the size of this FileModel.  # noqa: E501

        Always present for files - the file size in bytes Present for directories in snapshots - sum of sizes of objects in a directory   # noqa: E501

        :return: The size of this FileModel.  # noqa: E501
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size):
        """Sets the size of this FileModel.

        Always present for files - the file size in bytes Present for directories in snapshots - sum of sizes of objects in a directory   # noqa: E501

        :param size: The size of this FileModel.  # noqa: E501
        :type: int
        """

        self._size = size

    @property
    def checksums(self):
        """Gets the checksums of this FileModel.  # noqa: E501

        Always present for files - checksums; May include md5 and/or crc32c. Present for directories in snapshots - see DRS spec for algorithm for combining checksums of underlying directory contents.   # noqa: E501

        :return: The checksums of this FileModel.  # noqa: E501
        :rtype: list[DRSChecksum]
        """
        return self._checksums

    @checksums.setter
    def checksums(self, checksums):
        """Sets the checksums of this FileModel.

        Always present for files - checksums; May include md5 and/or crc32c. Present for directories in snapshots - see DRS spec for algorithm for combining checksums of underlying directory contents.   # noqa: E501

        :param checksums: The checksums of this FileModel.  # noqa: E501
        :type: list[DRSChecksum]
        """

        self._checksums = checksums

    @property
    def created(self):
        """Gets the created of this FileModel.  # noqa: E501

        timestamp of object creation in RFC3339  # noqa: E501

        :return: The created of this FileModel.  # noqa: E501
        :rtype: str
        """
        return self._created

    @created.setter
    def created(self, created):
        """Sets the created of this FileModel.

        timestamp of object creation in RFC3339  # noqa: E501

        :param created: The created of this FileModel.  # noqa: E501
        :type: str
        """

        self._created = created

    @property
    def description(self):
        """Gets the description of this FileModel.  # noqa: E501

        Human readable description of the file  # noqa: E501

        :return: The description of this FileModel.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this FileModel.

        Human readable description of the file  # noqa: E501

        :param description: The description of this FileModel.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def file_type(self):
        """Gets the file_type of this FileModel.  # noqa: E501


        :return: The file_type of this FileModel.  # noqa: E501
        :rtype: FileModelType
        """
        return self._file_type

    @file_type.setter
    def file_type(self, file_type):
        """Sets the file_type of this FileModel.


        :param file_type: The file_type of this FileModel.  # noqa: E501
        :type: FileModelType
        """

        self._file_type = file_type

    @property
    def file_detail(self):
        """Gets the file_detail of this FileModel.  # noqa: E501


        :return: The file_detail of this FileModel.  # noqa: E501
        :rtype: FileDetailModel
        """
        return self._file_detail

    @file_detail.setter
    def file_detail(self, file_detail):
        """Sets the file_detail of this FileModel.


        :param file_detail: The file_detail of this FileModel.  # noqa: E501
        :type: FileDetailModel
        """

        self._file_detail = file_detail

    @property
    def directory_detail(self):
        """Gets the directory_detail of this FileModel.  # noqa: E501


        :return: The directory_detail of this FileModel.  # noqa: E501
        :rtype: DirectoryDetailModel
        """
        return self._directory_detail

    @directory_detail.setter
    def directory_detail(self, directory_detail):
        """Sets the directory_detail of this FileModel.


        :param directory_detail: The directory_detail of this FileModel.  # noqa: E501
        :type: DirectoryDetailModel
        """

        self._directory_detail = directory_detail

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FileModel):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, FileModel):
            return True

        return self.to_dict() != other.to_dict()
