# coding: utf-8

"""
    Data Repository API

    <details><summary>This document defines the REST API for the Terra Data Repository.</summary> <p> **Status: design in progress** There are a few top-level endpoints (besides some used by swagger):  * / - generated by swagger: swagger API page that provides this documentation and a live UI for submitting REST requests  * /status - provides the operational status of the service  * /configuration - provides the basic configuration and information about the service  * /api - is the authenticated and authorized Data Repository API  * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API  The API endpoints are organized by interface. Each interface is separately versioned. <p> **Notes on Naming** <p> All of the reference items are suffixed with \\\"Model\\\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. </details>   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from data_repo_client.configuration import Configuration


class IntPartitionOptionsModel(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'column': 'str',
        'min': 'int',
        'max': 'int',
        'interval': 'int'
    }

    attribute_map = {
        'column': 'column',
        'min': 'min',
        'max': 'max',
        'interval': 'interval'
    }

    def __init__(self, column=None, min=None, max=None, interval=None, local_vars_configuration=None):  # noqa: E501
        """IntPartitionOptionsModel - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._column = None
        self._min = None
        self._max = None
        self._interval = None
        self.discriminator = None

        self.column = column
        self.min = min
        self.max = max
        self.interval = interval

    @property
    def column(self):
        """Gets the column of this IntPartitionOptionsModel.  # noqa: E501

        Column names follow this pattern. This should be used for the name of any column in the system. It enforces BigQuery naming rules except it disallows a leading underscore so we avoid collisions with any extra columns the DR adds. This is shorter than what BigQuery allows.   # noqa: E501

        :return: The column of this IntPartitionOptionsModel.  # noqa: E501
        :rtype: str
        """
        return self._column

    @column.setter
    def column(self, column):
        """Sets the column of this IntPartitionOptionsModel.

        Column names follow this pattern. This should be used for the name of any column in the system. It enforces BigQuery naming rules except it disallows a leading underscore so we avoid collisions with any extra columns the DR adds. This is shorter than what BigQuery allows.   # noqa: E501

        :param column: The column of this IntPartitionOptionsModel.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and column is None:  # noqa: E501
            raise ValueError("Invalid value for `column`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                column is not None and len(column) > 63):
            raise ValueError("Invalid value for `column`, length must be less than or equal to `63`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                column is not None and len(column) < 1):
            raise ValueError("Invalid value for `column`, length must be greater than or equal to `1`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                column is not None and not re.search(r'^[a-zA-Z][_a-zA-Z0-9]*$', column)):  # noqa: E501
            raise ValueError(r"Invalid value for `column`, must be a follow pattern or equal to `/^[a-zA-Z][_a-zA-Z0-9]*$/`")  # noqa: E501

        self._column = column

    @property
    def min(self):
        """Gets the min of this IntPartitionOptionsModel.  # noqa: E501

        The smallest value to partition within the target column. Any rows with a value smaller than this will be unpartitioned.   # noqa: E501

        :return: The min of this IntPartitionOptionsModel.  # noqa: E501
        :rtype: int
        """
        return self._min

    @min.setter
    def min(self, min):
        """Sets the min of this IntPartitionOptionsModel.

        The smallest value to partition within the target column. Any rows with a value smaller than this will be unpartitioned.   # noqa: E501

        :param min: The min of this IntPartitionOptionsModel.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and min is None:  # noqa: E501
            raise ValueError("Invalid value for `min`, must not be `None`")  # noqa: E501

        self._min = min

    @property
    def max(self):
        """Gets the max of this IntPartitionOptionsModel.  # noqa: E501

        The largest value to partition within the target column. Any rows with a value larger than this will be unpartitioned.   # noqa: E501

        :return: The max of this IntPartitionOptionsModel.  # noqa: E501
        :rtype: int
        """
        return self._max

    @max.setter
    def max(self, max):
        """Sets the max of this IntPartitionOptionsModel.

        The largest value to partition within the target column. Any rows with a value larger than this will be unpartitioned.   # noqa: E501

        :param max: The max of this IntPartitionOptionsModel.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and max is None:  # noqa: E501
            raise ValueError("Invalid value for `max`, must not be `None`")  # noqa: E501

        self._max = max

    @property
    def interval(self):
        """Gets the interval of this IntPartitionOptionsModel.  # noqa: E501

        The size to use when dividing the partitioning range into \"buckets\". (max - min) / (this value) cannot be larger than 4,000.   # noqa: E501

        :return: The interval of this IntPartitionOptionsModel.  # noqa: E501
        :rtype: int
        """
        return self._interval

    @interval.setter
    def interval(self, interval):
        """Sets the interval of this IntPartitionOptionsModel.

        The size to use when dividing the partitioning range into \"buckets\". (max - min) / (this value) cannot be larger than 4,000.   # noqa: E501

        :param interval: The interval of this IntPartitionOptionsModel.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and interval is None:  # noqa: E501
            raise ValueError("Invalid value for `interval`, must not be `None`")  # noqa: E501

        self._interval = interval

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, IntPartitionOptionsModel):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, IntPartitionOptionsModel):
            return True

        return self.to_dict() != other.to_dict()
