# coding: utf-8

"""
    Data Repository API

    <details><summary>This document defines the REST API for the Terra Data Repository.</summary> <p> **Status: design in progress** There are a few top-level endpoints (besides some used by swagger):  * / - generated by swagger: swagger API page that provides this documentation and a live UI for submitting REST requests  * /status - provides the operational status of the service  * /configuration - provides the basic configuration and information about the service  * /api - is the authenticated and authorized Data Repository API  * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API  The API endpoints are organized by interface. Each interface is separately versioned. <p> **Notes on Naming** <p> All of the reference items are suffixed with \\\"Model\\\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. </details>   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from data_repo_client.configuration import Configuration


class SnapshotBuilderCriteriaGroup(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'criteria': 'list[SnapshotBuilderCriteria]',
        'must_meet': 'bool',
        'meet_all': 'bool'
    }

    attribute_map = {
        'criteria': 'criteria',
        'must_meet': 'mustMeet',
        'meet_all': 'meetAll'
    }

    def __init__(self, criteria=None, must_meet=None, meet_all=None, local_vars_configuration=None):  # noqa: E501
        """SnapshotBuilderCriteriaGroup - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._criteria = None
        self._must_meet = None
        self._meet_all = None
        self.discriminator = None

        self.criteria = criteria
        self.must_meet = must_meet
        self.meet_all = meet_all

    @property
    def criteria(self):
        """Gets the criteria of this SnapshotBuilderCriteriaGroup.  # noqa: E501


        :return: The criteria of this SnapshotBuilderCriteriaGroup.  # noqa: E501
        :rtype: list[SnapshotBuilderCriteria]
        """
        return self._criteria

    @criteria.setter
    def criteria(self, criteria):
        """Sets the criteria of this SnapshotBuilderCriteriaGroup.


        :param criteria: The criteria of this SnapshotBuilderCriteriaGroup.  # noqa: E501
        :type: list[SnapshotBuilderCriteria]
        """
        if self.local_vars_configuration.client_side_validation and criteria is None:  # noqa: E501
            raise ValueError("Invalid value for `criteria`, must not be `None`")  # noqa: E501

        self._criteria = criteria

    @property
    def must_meet(self):
        """Gets the must_meet of this SnapshotBuilderCriteriaGroup.  # noqa: E501


        :return: The must_meet of this SnapshotBuilderCriteriaGroup.  # noqa: E501
        :rtype: bool
        """
        return self._must_meet

    @must_meet.setter
    def must_meet(self, must_meet):
        """Sets the must_meet of this SnapshotBuilderCriteriaGroup.


        :param must_meet: The must_meet of this SnapshotBuilderCriteriaGroup.  # noqa: E501
        :type: bool
        """
        if self.local_vars_configuration.client_side_validation and must_meet is None:  # noqa: E501
            raise ValueError("Invalid value for `must_meet`, must not be `None`")  # noqa: E501

        self._must_meet = must_meet

    @property
    def meet_all(self):
        """Gets the meet_all of this SnapshotBuilderCriteriaGroup.  # noqa: E501


        :return: The meet_all of this SnapshotBuilderCriteriaGroup.  # noqa: E501
        :rtype: bool
        """
        return self._meet_all

    @meet_all.setter
    def meet_all(self, meet_all):
        """Sets the meet_all of this SnapshotBuilderCriteriaGroup.


        :param meet_all: The meet_all of this SnapshotBuilderCriteriaGroup.  # noqa: E501
        :type: bool
        """
        if self.local_vars_configuration.client_side_validation and meet_all is None:  # noqa: E501
            raise ValueError("Invalid value for `meet_all`, must not be `None`")  # noqa: E501

        self._meet_all = meet_all

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SnapshotBuilderCriteriaGroup):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SnapshotBuilderCriteriaGroup):
            return True

        return self.to_dict() != other.to_dict()
