# coding: utf-8

"""
    Data Repository API

    <details><summary>This document defines the REST API for the Terra Data Repository.</summary> <p> **Status: design in progress** There are a few top-level endpoints (besides some used by swagger):  * / - generated by swagger: swagger API page that provides this documentation and a live UI for submitting REST requests  * /status - provides the operational status of the service  * /configuration - provides the basic configuration and information about the service  * /api - is the authenticated and authorized Data Repository API  * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API  The API endpoints are organized by interface. Each interface is separately versioned. <p> **Notes on Naming** <p> All of the reference items are suffixed with \\\"Model\\\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. </details>   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from data_repo_client.configuration import Configuration


class SnapshotBuilderSettings(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'description': 'str',
        'domain_options': 'list[SnapshotBuilderDomainOption]',
        'program_data_options': 'list[SnapshotBuilderProgramDataOption]',
        'dataset_concept_sets': 'list[SnapshotBuilderDatasetConceptSet]',
        'root_table': 'SnapshotBuilderRootTable',
        'dictionary_table': 'SnapshotBuilderTable'
    }

    attribute_map = {
        'name': 'name',
        'description': 'description',
        'domain_options': 'domainOptions',
        'program_data_options': 'programDataOptions',
        'dataset_concept_sets': 'datasetConceptSets',
        'root_table': 'rootTable',
        'dictionary_table': 'dictionaryTable'
    }

    def __init__(self, name=None, description=None, domain_options=None, program_data_options=None, dataset_concept_sets=None, root_table=None, dictionary_table=None, local_vars_configuration=None):  # noqa: E501
        """SnapshotBuilderSettings - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._description = None
        self._domain_options = None
        self._program_data_options = None
        self._dataset_concept_sets = None
        self._root_table = None
        self._dictionary_table = None
        self.discriminator = None

        self.name = name
        self.description = description
        self.domain_options = domain_options
        self.program_data_options = program_data_options
        self.dataset_concept_sets = dataset_concept_sets
        self.root_table = root_table
        if dictionary_table is not None:
            self.dictionary_table = dictionary_table

    @property
    def name(self):
        """Gets the name of this SnapshotBuilderSettings.  # noqa: E501


        :return: The name of this SnapshotBuilderSettings.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this SnapshotBuilderSettings.


        :param name: The name of this SnapshotBuilderSettings.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def description(self):
        """Gets the description of this SnapshotBuilderSettings.  # noqa: E501


        :return: The description of this SnapshotBuilderSettings.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this SnapshotBuilderSettings.


        :param description: The description of this SnapshotBuilderSettings.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and description is None:  # noqa: E501
            raise ValueError("Invalid value for `description`, must not be `None`")  # noqa: E501

        self._description = description

    @property
    def domain_options(self):
        """Gets the domain_options of this SnapshotBuilderSettings.  # noqa: E501


        :return: The domain_options of this SnapshotBuilderSettings.  # noqa: E501
        :rtype: list[SnapshotBuilderDomainOption]
        """
        return self._domain_options

    @domain_options.setter
    def domain_options(self, domain_options):
        """Sets the domain_options of this SnapshotBuilderSettings.


        :param domain_options: The domain_options of this SnapshotBuilderSettings.  # noqa: E501
        :type: list[SnapshotBuilderDomainOption]
        """
        if self.local_vars_configuration.client_side_validation and domain_options is None:  # noqa: E501
            raise ValueError("Invalid value for `domain_options`, must not be `None`")  # noqa: E501

        self._domain_options = domain_options

    @property
    def program_data_options(self):
        """Gets the program_data_options of this SnapshotBuilderSettings.  # noqa: E501


        :return: The program_data_options of this SnapshotBuilderSettings.  # noqa: E501
        :rtype: list[SnapshotBuilderProgramDataOption]
        """
        return self._program_data_options

    @program_data_options.setter
    def program_data_options(self, program_data_options):
        """Sets the program_data_options of this SnapshotBuilderSettings.


        :param program_data_options: The program_data_options of this SnapshotBuilderSettings.  # noqa: E501
        :type: list[SnapshotBuilderProgramDataOption]
        """
        if self.local_vars_configuration.client_side_validation and program_data_options is None:  # noqa: E501
            raise ValueError("Invalid value for `program_data_options`, must not be `None`")  # noqa: E501

        self._program_data_options = program_data_options

    @property
    def dataset_concept_sets(self):
        """Gets the dataset_concept_sets of this SnapshotBuilderSettings.  # noqa: E501


        :return: The dataset_concept_sets of this SnapshotBuilderSettings.  # noqa: E501
        :rtype: list[SnapshotBuilderDatasetConceptSet]
        """
        return self._dataset_concept_sets

    @dataset_concept_sets.setter
    def dataset_concept_sets(self, dataset_concept_sets):
        """Sets the dataset_concept_sets of this SnapshotBuilderSettings.


        :param dataset_concept_sets: The dataset_concept_sets of this SnapshotBuilderSettings.  # noqa: E501
        :type: list[SnapshotBuilderDatasetConceptSet]
        """
        if self.local_vars_configuration.client_side_validation and dataset_concept_sets is None:  # noqa: E501
            raise ValueError("Invalid value for `dataset_concept_sets`, must not be `None`")  # noqa: E501

        self._dataset_concept_sets = dataset_concept_sets

    @property
    def root_table(self):
        """Gets the root_table of this SnapshotBuilderSettings.  # noqa: E501


        :return: The root_table of this SnapshotBuilderSettings.  # noqa: E501
        :rtype: SnapshotBuilderRootTable
        """
        return self._root_table

    @root_table.setter
    def root_table(self, root_table):
        """Sets the root_table of this SnapshotBuilderSettings.


        :param root_table: The root_table of this SnapshotBuilderSettings.  # noqa: E501
        :type: SnapshotBuilderRootTable
        """
        if self.local_vars_configuration.client_side_validation and root_table is None:  # noqa: E501
            raise ValueError("Invalid value for `root_table`, must not be `None`")  # noqa: E501

        self._root_table = root_table

    @property
    def dictionary_table(self):
        """Gets the dictionary_table of this SnapshotBuilderSettings.  # noqa: E501


        :return: The dictionary_table of this SnapshotBuilderSettings.  # noqa: E501
        :rtype: SnapshotBuilderTable
        """
        return self._dictionary_table

    @dictionary_table.setter
    def dictionary_table(self, dictionary_table):
        """Sets the dictionary_table of this SnapshotBuilderSettings.


        :param dictionary_table: The dictionary_table of this SnapshotBuilderSettings.  # noqa: E501
        :type: SnapshotBuilderTable
        """

        self._dictionary_table = dictionary_table

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SnapshotBuilderSettings):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SnapshotBuilderSettings):
            return True

        return self.to_dict() != other.to_dict()
