# coding: utf-8

"""
    Data Repository API

    <details><summary>This document defines the REST API for the Terra Data Repository.</summary> <p> **Status: design in progress** There are a few top-level endpoints (besides some used by swagger):  * / - generated by swagger: swagger API page that provides this documentation and a live UI for submitting REST requests  * /status - provides the operational status of the service  * /configuration - provides the basic configuration and information about the service  * /api - is the authenticated and authorized Data Repository API  * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API  The API endpoints are organized by interface. Each interface is separately versioned. <p> **Notes on Naming** <p> All of the reference items are suffixed with \\\"Model\\\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. </details>   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from data_repo_client.configuration import Configuration


class WorkspacePolicyModel(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'workspace_id': 'str',
        'workspace_name': 'str',
        'workspace_namespace': 'str',
        'workspace_link': 'str',
        'workspace_policies': 'list[PolicyModel]'
    }

    attribute_map = {
        'workspace_id': 'workspaceId',
        'workspace_name': 'workspaceName',
        'workspace_namespace': 'workspaceNamespace',
        'workspace_link': 'workspaceLink',
        'workspace_policies': 'workspacePolicies'
    }

    def __init__(self, workspace_id=None, workspace_name=None, workspace_namespace=None, workspace_link=None, workspace_policies=None, local_vars_configuration=None):  # noqa: E501
        """WorkspacePolicyModel - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._workspace_id = None
        self._workspace_name = None
        self._workspace_namespace = None
        self._workspace_link = None
        self._workspace_policies = None
        self.discriminator = None

        if workspace_id is not None:
            self.workspace_id = workspace_id
        if workspace_name is not None:
            self.workspace_name = workspace_name
        if workspace_namespace is not None:
            self.workspace_namespace = workspace_namespace
        if workspace_link is not None:
            self.workspace_link = workspace_link
        if workspace_policies is not None:
            self.workspace_policies = workspace_policies

    @property
    def workspace_id(self):
        """Gets the workspace_id of this WorkspacePolicyModel.  # noqa: E501

        Unique identifier for a dataset, snapshot, etc.   # noqa: E501

        :return: The workspace_id of this WorkspacePolicyModel.  # noqa: E501
        :rtype: str
        """
        return self._workspace_id

    @workspace_id.setter
    def workspace_id(self, workspace_id):
        """Sets the workspace_id of this WorkspacePolicyModel.

        Unique identifier for a dataset, snapshot, etc.   # noqa: E501

        :param workspace_id: The workspace_id of this WorkspacePolicyModel.  # noqa: E501
        :type: str
        """

        self._workspace_id = workspace_id

    @property
    def workspace_name(self):
        """Gets the workspace_name of this WorkspacePolicyModel.  # noqa: E501


        :return: The workspace_name of this WorkspacePolicyModel.  # noqa: E501
        :rtype: str
        """
        return self._workspace_name

    @workspace_name.setter
    def workspace_name(self, workspace_name):
        """Sets the workspace_name of this WorkspacePolicyModel.


        :param workspace_name: The workspace_name of this WorkspacePolicyModel.  # noqa: E501
        :type: str
        """

        self._workspace_name = workspace_name

    @property
    def workspace_namespace(self):
        """Gets the workspace_namespace of this WorkspacePolicyModel.  # noqa: E501


        :return: The workspace_namespace of this WorkspacePolicyModel.  # noqa: E501
        :rtype: str
        """
        return self._workspace_namespace

    @workspace_namespace.setter
    def workspace_namespace(self, workspace_namespace):
        """Sets the workspace_namespace of this WorkspacePolicyModel.


        :param workspace_namespace: The workspace_namespace of this WorkspacePolicyModel.  # noqa: E501
        :type: str
        """

        self._workspace_namespace = workspace_namespace

    @property
    def workspace_link(self):
        """Gets the workspace_link of this WorkspacePolicyModel.  # noqa: E501


        :return: The workspace_link of this WorkspacePolicyModel.  # noqa: E501
        :rtype: str
        """
        return self._workspace_link

    @workspace_link.setter
    def workspace_link(self, workspace_link):
        """Sets the workspace_link of this WorkspacePolicyModel.


        :param workspace_link: The workspace_link of this WorkspacePolicyModel.  # noqa: E501
        :type: str
        """

        self._workspace_link = workspace_link

    @property
    def workspace_policies(self):
        """Gets the workspace_policies of this WorkspacePolicyModel.  # noqa: E501


        :return: The workspace_policies of this WorkspacePolicyModel.  # noqa: E501
        :rtype: list[PolicyModel]
        """
        return self._workspace_policies

    @workspace_policies.setter
    def workspace_policies(self, workspace_policies):
        """Sets the workspace_policies of this WorkspacePolicyModel.


        :param workspace_policies: The workspace_policies of this WorkspacePolicyModel.  # noqa: E501
        :type: list[PolicyModel]
        """

        self._workspace_policies = workspace_policies

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, WorkspacePolicyModel):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, WorkspacePolicyModel):
            return True

        return self.to_dict() != other.to_dict()
