# Generated by Django 3.2.12 on 2022-11-21 08:36

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("permissions", "0004_create_anonymous_user"),
        ("flow", "0007_alter_data_process_rc"),
    ]

    operations = [
        migrations.CreateModel(
            name="AnnotationField",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=128)),
                ("type", models.CharField(max_length=16)),
                ("sort_order", models.PositiveSmallIntegerField()),
                ("validator_regex", models.CharField(max_length=128, null=True)),
                ("vocabulary", models.JSONField(null=True)),
                ("label", models.CharField(max_length=128)),
                ("description", models.CharField(max_length=256)),
            ],
            options={
                "ordering": ["group__sort_order", "sort_order"],
            },
        ),
        migrations.CreateModel(
            name="AnnotationGroup",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=128)),
                ("label", models.CharField(max_length=128)),
                ("sort_order", models.PositiveSmallIntegerField()),
            ],
            options={
                "ordering": ["sort_order"],
            },
        ),
        migrations.CreateModel(
            name="AnnotationValue",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("_value", models.JSONField(default=dict)),
                (
                    "entity",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="annotations",
                        to="flow.entity",
                    ),
                ),
                (
                    "field",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="values",
                        to="flow.annotationfield",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="AnnotationPreset",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=128)),
                (
                    "fields",
                    models.ManyToManyField(
                        related_name="presets", to="flow.AnnotationField"
                    ),
                ),
                (
                    "permission_group",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="annotationpreset",
                        to="permissions.permissiongroup",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="annotationfield",
            name="group",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="fields",
                to="flow.annotationgroup",
            ),
        ),
        migrations.AddField(
            model_name="collection",
            name="annotation_fields",
            field=models.ManyToManyField(
                related_name="collection", to="flow.AnnotationField"
            ),
        ),
        migrations.AddConstraint(
            model_name="annotationfield",
            constraint=models.CheckConstraint(
                check=models.Q(("type__in", ["DATE", "DECIMAL", "INTEGER", "STRING"])),
                name="annotation_type",
            ),
        ),
        migrations.AddConstraint(
            model_name="annotationfield",
            constraint=models.UniqueConstraint(
                fields=("name", "group"), name="uniquetogether_name_group"
            ),
        ),
    ]
