# mypy-boto3-discovery

[![PyPI - mypy-boto3-discovery](https://img.shields.io/pypi/v/mypy-boto3-discovery.svg?color=blue)](https://pypi.org/project/mypy-boto3-discovery)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-discovery.svg?color=blue)](https://pypi.org/project/mypy-boto3-discovery)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.ApplicationDiscoveryService 1.14.0](https://boto3.amazonaws.com/v1/documentation/api/1.14.0/reference/services/discovery.html#ApplicationDiscoveryService) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.1.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

## How to install

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `ApplicationDiscoveryService` service.

```bash
python -m pip install boto3-stubs[discovery]
```

## How to use

### Client annotations

`ApplicationDiscoveryServiceClient` provides annotations for `boto3.client("discovery")`.

```python
import boto3

from mypy_boto3_discovery import ApplicationDiscoveryServiceClient

client: ApplicationDiscoveryServiceClient = boto3.client("discovery")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: ApplicationDiscoveryServiceClient = session.client("discovery")
```

### Paginators annotations

`mypy_boto3_discovery.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_discovery import ApplicationDiscoveryServiceClient
from mypy_boto3_discovery.paginator import (
    DescribeAgentsPaginator,
    DescribeContinuousExportsPaginator,
    DescribeExportConfigurationsPaginator,
    DescribeExportTasksPaginator,
    DescribeTagsPaginator,
    ListConfigurationsPaginator,
)

client: ApplicationDiscoveryServiceClient = boto3.client("discovery")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_agents_paginator: DescribeAgentsPaginator = client.get_paginator("describe_agents")
describe_continuous_exports_paginator: DescribeContinuousExportsPaginator = client.get_paginator("describe_continuous_exports")
describe_export_configurations_paginator: DescribeExportConfigurationsPaginator = client.get_paginator("describe_export_configurations")
describe_export_tasks_paginator: DescribeExportTasksPaginator = client.get_paginator("describe_export_tasks")
describe_tags_paginator: DescribeTagsPaginator = client.get_paginator("describe_tags")
list_configurations_paginator: ListConfigurationsPaginator = client.get_paginator("list_configurations")
```







### Typed dictionations

`mypy_boto3_discovery.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_discovery.type_defs import AgentConfigurationStatusTypeDef, ...

def get_structure() -> AgentConfigurationStatusTypeDef:
    return {
      ...
    }
```


## Dynamic type annotations

`mypy_boto3` command generates `boto3.client/resource` type annotations for
`mypy_boto3_discovery` and other installed services.

```bash
# Run this command after you add or remove service packages
python -m mypy_boto3
```

Generated type annotations provide overloads for `boto3.client` and `boto3.resource`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully if you have many services installed
- `VSCode` does not currently support function overloads, use explicit type annotations

```python
import boto3

# Type is discovered correctly by mypy and PyCharm
# VSCode still needs explicit type annotations
client = boto3.client("discovery")

session_client = boto3.Session().client("discovery")
```