# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.container_image_read import ContainerImageRead
from ...types.docker_service_token import DockerServiceToken
from ...types.paginated_container_image_read_list import PaginatedContainerImageReadList
from .raw_client import AsyncRawContainerImagesClient, RawContainerImagesClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ContainerImagesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawContainerImagesClient(client_wrapper=client_wrapper)

    @property
    def _client_wrapper(self) -> SyncClientWrapper:
        return self._raw_client._client_wrapper

    @property
    def with_raw_response(self) -> RawContainerImagesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawContainerImagesClient
        """
        return self._raw_client

    def list(
        self,
        *,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        ordering: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedContainerImageReadList:
        """
        Retrieve a list of container images for the organization.

        Parameters
        ----------
        limit : typing.Optional[int]
            Number of results to return per page.

        offset : typing.Optional[int]
            The initial index from which to return the results.

        ordering : typing.Optional[str]
            Which field to use when ordering the results.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedContainerImageReadList


        Examples
        --------
        from vellum import Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.container_images.list()
        """
        _response = self._raw_client.list(
            limit=limit, offset=offset, ordering=ordering, request_options=request_options
        )
        return _response.data

    def retrieve(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> ContainerImageRead:
        """
        Retrieve a Container Image by its ID or name.

        Parameters
        ----------
        id : str
            Either the Container Image's ID or its unique name

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ContainerImageRead


        Examples
        --------
        from vellum import Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.container_images.retrieve(
            id="id",
        )
        """
        _response = self._raw_client.retrieve(id, request_options=request_options)
        return _response.data

    def docker_service_token(self, *, request_options: typing.Optional[RequestOptions] = None) -> DockerServiceToken:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DockerServiceToken


        Examples
        --------
        from vellum import Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.container_images.docker_service_token()
        """
        _response = self._raw_client.docker_service_token(request_options=request_options)
        return _response.data

    def push_container_image(
        self,
        *,
        name: str,
        sha: str,
        tags: typing.Sequence[str],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ContainerImageRead:
        """
        Parameters
        ----------
        name : str

        sha : str

        tags : typing.Sequence[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ContainerImageRead


        Examples
        --------
        from vellum import Vellum

        client = Vellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )
        client.container_images.push_container_image(
            name="x",
            sha="x",
            tags=["tags", "tags"],
        )
        """
        _response = self._raw_client.push_container_image(
            name=name, sha=sha, tags=tags, request_options=request_options
        )
        return _response.data


class AsyncContainerImagesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawContainerImagesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawContainerImagesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawContainerImagesClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        ordering: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedContainerImageReadList:
        """
        Retrieve a list of container images for the organization.

        Parameters
        ----------
        limit : typing.Optional[int]
            Number of results to return per page.

        offset : typing.Optional[int]
            The initial index from which to return the results.

        ordering : typing.Optional[str]
            Which field to use when ordering the results.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedContainerImageReadList


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.container_images.list()


        asyncio.run(main())
        """
        _response = await self._raw_client.list(
            limit=limit, offset=offset, ordering=ordering, request_options=request_options
        )
        return _response.data

    async def retrieve(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> ContainerImageRead:
        """
        Retrieve a Container Image by its ID or name.

        Parameters
        ----------
        id : str
            Either the Container Image's ID or its unique name

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ContainerImageRead


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.container_images.retrieve(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve(id, request_options=request_options)
        return _response.data

    async def docker_service_token(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DockerServiceToken:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DockerServiceToken


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.container_images.docker_service_token()


        asyncio.run(main())
        """
        _response = await self._raw_client.docker_service_token(request_options=request_options)
        return _response.data

    async def push_container_image(
        self,
        *,
        name: str,
        sha: str,
        tags: typing.Sequence[str],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ContainerImageRead:
        """
        Parameters
        ----------
        name : str

        sha : str

        tags : typing.Sequence[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ContainerImageRead


        Examples
        --------
        import asyncio

        from vellum import AsyncVellum

        client = AsyncVellum(
            api_version="YOUR_API_VERSION",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.container_images.push_container_image(
                name="x",
                sha="x",
                tags=["tags", "tags"],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.push_container_image(
            name=name, sha=sha, tags=tags, request_options=request_options
        )
        return _response.data
