'use strict';
/*!
 * Copyright (c) Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */
(function(root, factory) {
  factory(root["Bokeh"], undefined);
})(this, function(Bokeh, version) {
  let define;
  return (function(modules, entry, aliases, externals) {
    const bokeh = typeof Bokeh !== "undefined" ? (version != null ? Bokeh[version] : Bokeh) : null;
    if (bokeh != null) {
      return bokeh.register_plugin(modules, entry, aliases);
    } else {
      throw new Error("Cannot find Bokeh" + (version != null ? " " + version : "") + ". You have to load it prior to loading plugins.");
    }
  })
({
"c27055c896": function _(e,o,b,s,t){s();const i=e("tslib").__importStar(e("2fbbcedd89"));b.bokehmol=i;(0,e("@bokehjs/base").register_models)(i)},
"2fbbcedd89": function _(e,r,a,t,o){t(),o("BaseFormatter",e("bdbba644e6").BaseFormatter),o("BaseHover",e("b3aabca0fa").BaseHover),o("RDKitFormatter",e("66b72b8836").RDKitFormatter),o("RDKitHover",e("db381e1cc8").RDKitHover),o("SmilesDrawerFormatter",e("be6f45e05e").SmilesDrawerFormatter),o("SmilesDrawerHover",e("6c967671db").SmilesDrawerHover)},
"bdbba644e6": function _(t,e,r,s,o){var i;s();const h=t("@bokehjs/models/tools/inspectors/customjs_hover"),n=t("01840ae548");class m extends h.CustomJSHover{constructor(t){super(t)}makeSVGElement(){const t=document.createElementNS("http://www.w3.org/2000/svg","svg");return t.setAttribute("xmlns","http://www.w3.org/2000/svg"),t.setAttribute("xmlns:xlink","http://www.w3.org/1999/xlink"),t.setAttributeNS(null,"width",""+this.width),t.setAttributeNS(null,"height",""+this.height),t}draw_grid(t){const e=[];return t.forEach((t=>{let r=this.draw_svg(t);e.push(r)})),(0,n.combineSVGs)(e,this.width,this.height,this.mols_per_row)}draw_svg(t){const e=this.makeSVGElement(),r=e.outerHTML;return e.remove(),r}format(t,e,r){return Array.isArray(t)?this.draw_grid(t):this.draw_svg(t)}}r.BaseFormatter=m,i=m,m.__name__="BaseFormatter",m.__module__="bokehmol.models.base_formatter",i.define((({Int:t})=>({width:[t,160],height:[t,120],mols_per_row:[t,5]})))},
"01840ae548": function _(e,t,a,l,i){l(),a.combineSVGs=function(e,t,a,l){let i=[],n=t,s=a;const h=new DOMParser;for(let g=0;g<e.length;g++){let r=e[g],o=t,m=a;if(t<0||a<0){let e=h.parseFromString(r,"image/svg+xml").firstChild;t<0&&(o=e.width.baseVal.value,o>n?n=o:o=n),a<0&&(m=e.height.baseVal.value),m>s?s=m:m=s}let f=o*(g%l),c=m*Math.floor(g/l),u=btoa(r);i.push(`<image id="molecule-${g}" transform="translate(${f},${c})" href='data:image/svg+xml;base64,${u}'></image>`)}const g=n*Math.min(l,e.length),r=s*Math.ceil(e.length/l);return`<svg width="${g}" height="${r}">${i.join("\n")}</svg>`}},
"b3aabca0fa": function _(e,i,o,I,t){var s;I();const A=e("@bokehjs/core/dom"),r=e("@bokehjs/core/util/templating"),l=e("@bokehjs/core/util/types"),h=e("@bokehjs/models/tools/inspectors/hover_tool"),_=e("@bokehjs/styles/icons.css");class n extends h.HoverToolView{_render_tooltips(e,i){const{tooltips:o,smiles_column:I}=this.model,t=i.index;let s=o;if(null===s&&(s=""),!(0,l.isString)(s)){const o=this._template_el??(this._template_el=this._create_template(s));s=this._render_template(o,s,e,i).outerHTML}const h="<div>@"+I+"{custom}</div>"+s,_=(0,r.replace_placeholders)({html:h},e,t,this.model.formatters,i);return(0,A.div)(_)}}o.BaseHoverView=n,n.__name__="BaseHoverView";class a extends h.HoverTool{get computed_icon(){return"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABYAAAAWCAMAAADzapwJAAAAt1BMVEUAAAAAAAArKyskJCQcHBwrKyscHBwmJiYjIyMhISEgICAfHx8dHR0kJCQiIiIhISEhISEgICAkJCQkJCQjIyMiIiIiIiIhISEkJCQjIyMiIiIiIiIjIyMjIyMkJCQjIyMiIiIkJCQhISEjIyMiIiIiIiIiIiIkJCQjIyMiIiIiIiIiIiIiIiIhISEjIyMjIyMiIiIiIiIjIyMiIiIiIiIhISEiIiIiIiIiIiIiIiIhISEjIyP///9o30WSAAAAPHRSTlMAAQYHCQwSFBYXGBkaKy0uLzAxMjM0NTY5UVJTV1hdYHJyc3V3eHmBk5SVlpeZmpucnaqtrrCytLa7wMBTv07WAAAAAWJLR0Q8p2phzwAAAKRJREFUGBmtwQkagUAAgNF/ZAtZo2yRIrusofvfi+ab0gG8xx85gS8FDjlabJuS/db4WQ1RRksy+p3ZRZpxbZA6t8gYJxRzTc7WQhKPCjnlSJDwXEIdRQ9xPRKeS+eAcurjeiTEo8JhgNTdU44EUm9D9SlIRDV2FkrYZjHhazrHOJLS7xReRSi+CtzqZJYjmiUoNRn7/GixbUr2WyPHCXwpcPifD0UBD3u/QqniAAAAAElFTkSuQmCC"}constructor(e){super(e),this.tool_icon=_.tool_icon_hover}}o.BaseHover=a,s=a,a.__name__="BaseHover",a.__module__="bokehmol.models.base_hover",s.prototype.default_view=n,s.define((({Str:e,Int:i})=>({smiles_column:[e,"SMILES"],width:[i,160],height:[i,120],mols_per_row:[i,3]}))),s.override({tooltips:[]})},
"66b72b8836": function _(t,i,e,s,o){var n;s();const r=t("bdbba644e6");class d extends r.BaseFormatter{constructor(t){super(t)}initialize(){super.initialize(),this.onRDKitReady(!0,!1,(()=>{initRDKitModule().then((t=>{this.RDKitModule=t,console.log("RDKit version: "+t.version())}))}))}onRDKitReady(t,i,e){this.hasLoadedRDKit(t,i)?e():setTimeout((()=>{this.onRDKitReady(t,i,e)}),100)}hasLoadedRDKit(t,i){return!(t&&"undefined"==typeof initRDKitModule||i&&void 0===this.RDKitModule)}setupRDKitOptions(){return this.onRDKitReady(!0,!0,(()=>{this.RDKitModule.prefer_coordgen(this.prefer_coordgen)})),this.json_mol_opts=JSON.stringify({removeHs:this.remove_hs,sanitize:this.sanitize,kekulize:this.kekulize}),this.json_draw_opts=JSON.stringify({width:this.width,height:this.height,...this.draw_options}),this.json_draw_opts}draw_svg(t){const i=this.json_draw_opts??this.setupRDKitOptions();var e;if(this.onRDKitReady(!0,!0,(()=>{e=this.RDKitModule.get_mol(t,this.json_mol_opts)})),void 0===e)console.log("Attempting to display structures before RDKit has been loaded.");else if(null!==e&&e.is_valid()){const t=e.get_svg_with_highlights(i);return e.delete(),t}return super.draw_svg(t)}}e.RDKitFormatter=d,n=d,d.__name__="RDKitFormatter",d.__module__="bokehmol.models.rdkit_formatter",n.define((({Bool:t,Dict:i,Unknown:e})=>({prefer_coordgen:[t,!0],remove_hs:[t,!0],sanitize:[t,!0],kekulize:[t,!0],draw_options:[i(e),{}]})))},
"db381e1cc8": function _(A,e,o,i,t){var r;i();const s=A("b3aabca0fa"),n=A("66b72b8836");class _ extends s.BaseHoverView{initialize(){super.initialize();const{formatters:A,smiles_column:e,width:o,height:i,mols_per_row:t,prefer_coordgen:r,remove_hs:s,sanitize:_,kekulize:a,draw_options:d}=this.model;A["@"+e]=new n.RDKitFormatter({width:o,height:i,mols_per_row:t,prefer_coordgen:r,remove_hs:s,sanitize:_,kekulize:a,draw_options:d})}}o.RDKitHoverView=_,_.__name__="RDKitHoverView";class a extends s.BaseHover{get computed_icon(){return"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQBAMAAADt3eJSAAAABGdBTUEAALGPC/xhBQAAACBjSFJNAAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAAAFVBMVEXc3NwUFP8UPP9kZP+MjP+0tP////9ZXZotAAAAAXRSTlMAQObYZgAAAAFiS0dEBmFmuH0AAAAHdElNRQfmAwsPGi+MyC9RAAAAQElEQVQI12NgQABGQUEBMENISUkRLKBsbGwEEhIyBgJFsICLC0iIUdnExcUZwnANQWfApKCK4doRBsKtQFgKAQC5Ww1JEHSEkAAAACV0RVh0ZGF0ZTpjcmVhdGUAMjAyMi0wMy0xMVQxNToyNjo0NyswMDowMDzr2J4AAAAldEVYdGRhdGU6bW9kaWZ5ADIwMjItMDMtMTFUMTU6MjY6NDcrMDA6MDBNtmAiAAAAAElFTkSuQmCC"}constructor(A){super(A),this.tool_name="RDKit Hover"}}o.RDKitHover=a,r=a,a.__name__="RDKitHover",a.__module__="bokehmol.models.rdkit_hover",r.prototype.default_view=_,r.define((({Bool:A,Dict:e,Unknown:o})=>({prefer_coordgen:[A,!0],remove_hs:[A,!0],sanitize:[A,!0],kekulize:[A,!0],draw_options:[e(o),{}]}))),r.register_alias("rdkit_hover",(()=>new r))},
"be6f45e05e": function _(e,r,t,i,a){var o;i();const s=e("bdbba644e6");class n extends s.BaseFormatter{constructor(e){super(e)}initialize(){super.initialize(),this.onSmiDrawerReady(!0,!1,(()=>{this.SmiDrawer=SmiDrawer}))}onSmiDrawerReady(e,r,t){this.hasLoadedSmiDrawer(e,r)?t():setTimeout((()=>{this.onSmiDrawerReady(e,r,t)}),100)}hasLoadedSmiDrawer(e,r){return!(e&&"undefined"==typeof SmiDrawer||r&&void 0===this.SmiDrawer)}makeSVGElement(){const e=super.makeSVGElement();return e.style.backgroundColor=this.background_colour,e}setupDrawer(){return this.onSmiDrawerReady(!0,!0,(()=>{this.drawer=new this.SmiDrawer(this.mol_options,this.reaction_options)})),this.drawer}draw_svg(e){const r=this.makeSVGElement();this.onSmiDrawerReady(!0,!0,(()=>{(this.drawer??this.setupDrawer()).draw(e,r,this.theme)}));const t=r.outerHTML;return r.remove(),t}}t.SmilesDrawerFormatter=n,o=n,n.__name__="SmilesDrawerFormatter",n.__module__="bokehmol.models.smilesdrawer_formatter",o.define((({Str:e,Dict:r,Unknown:t})=>({theme:[e,"light"],background_colour:[e,"transparent"],mol_options:[r(t),{}],reaction_options:[r(t),{}]})))},
"6c967671db": function _(e,o,r,i,t){var s;i();const a=e("b3aabca0fa"),n=e("be6f45e05e");class _ extends a.BaseHoverView{initialize(){super.initialize();const{formatters:e,smiles_column:o,width:r,height:i,mols_per_row:t,theme:s,background_colour:a,mol_options:_,reaction_options:l}=this.model;e["@"+o]=new n.SmilesDrawerFormatter({width:r,height:i,mols_per_row:t,theme:s,background_colour:a,mol_options:_,reaction_options:l})}}r.SmilesDrawerHoverView=_,_.__name__="SmilesDrawerHoverView";class l extends a.BaseHover{constructor(e){super(e),this.tool_name="SmilesDrawer Hover"}}r.SmilesDrawerHover=l,s=l,l.__name__="SmilesDrawerHover",l.__module__="bokehmol.models.smilesdrawer_hover",s.prototype.default_view=_,s.define((({Str:e,Dict:o,Unknown:r})=>({theme:[e,"light"],background_colour:[e,"transparent"],mol_options:[o(r),{}],reaction_options:[o(r),{}]}))),s.register_alias("smiles_hover",(()=>new s))},
}, "c27055c896", {"index":"c27055c896","models/index":"2fbbcedd89","models/base_formatter":"bdbba644e6","models/combinesvg":"01840ae548","models/base_hover":"b3aabca0fa","models/rdkit_formatter":"66b72b8836","models/rdkit_hover":"db381e1cc8","models/smilesdrawer_formatter":"be6f45e05e","models/smilesdrawer_hover":"6c967671db"}, {});});
