# IESopt: Integrated Energy System Optimization

[![PyPI - Version](https://img.shields.io/pypi/v/iesopt)](https://pypi.org/project/iesopt/)
[![Docs](https://img.shields.io/badge/docs-stable-blue.svg)](https://ait-energy.github.io/iesopt/)
[![License](https://img.shields.io/github/license/ait-energy/iesopt)](LICENSE)

[![Build Status](https://github.com/ait-energy/iesopt/actions/workflows/pytest.yml/badge.svg?branch=main)](https://github.com/ait-energy/iesopt/actions/workflows/pytest.yml?query=branch%3Amain)
[![codecov](https://codecov.io/gh/ait-energy/iesopt/graph/badge.svg?token=MC2IN9URZY)](https://codecov.io/gh/ait-energy/iesopt)
[![Ruff](https://img.shields.io/endpoint?url=https://raw.githubusercontent.com/astral-sh/ruff/main/assets/badge/v2.json)](https://github.com/astral-sh/ruff)

**IESopt** (_Integrated Energy System Optimization_) is a modeling and optimization framework for integrated energy
systems.

It is developed and maintained at the **Center for Energy** at
[AIT Austrian Institute of Technology GmbH](https://www.ait.ac.at/). The framework is designed to support the
optimization of energy systems that are characterized by a high degree of integration between different energy carriers
and sectors. It focuses on offering a modular and adaptable tool for modelers, that does not compromise on performance,
while still being user-friendly. This is enabled by reducing energy system assets to abstract building blocks, that are
supported by specialized implementation, and can be combined into complex systems without the need of a detailed
understanding of mathematical modeling or proficiency in any coding-language.

> If you are looking for the framework's core model, written in Julia, head over to the [IESopt.jl repository](https://github.com/ait-energy/IESopt.jl).

## Getting started

Head over to the [documentation](https://ait-energy.github.io/iesopt/) to get started with **IESopt**.

## Contributing

PRs accepted. Checkout the _developer documentation section_ in the [documentation](https://ait-energy.github.io/iesopt/).

## License

[MIT © AIT Austrian Institute of Technology GmbH.](LICENSE)
