# Projects

## Overview

This maintains a list of projects where IESopt was applied as part of the modeling
approach. Entries are in alphabetical order. If you want to contribute a new project, please follow the
instructions in the [section on contributing](#contributing) below.

## List of references

(references-projects-cells4energy)=
### cells4.energy

| **Factsheet** |   |
|-------------|---|
| title       | Regional energy cells as multi-energy real laboratories for a rapid system transition |
| homepage    | [ait.ac.at](https://www.ait.ac.at/themen/hybrid-power-plants/projekte/cells4energy) |
| funding     | [ffg.at](https://projekte.ffg.at/projekt/4849884) |
| AIT contact | B. Iglar |

**Description**  
The cells4.energy project establishes living labs in diverse Austrian regions to develop, test, and scale a decentralized, digital, and cross-sectoral renewable energy system based on replicable energy cells, supporting the national energy transition through systemic, technological, and societal innovation.

---

(references-projects-cleanheatselector)=
### CleanHeatSelector

| **Factsheet** |   |
|-------------|---|
| title       | Development of a decision framework for the selection of priority areas for the implementation of sustainable heating technologies |
| homepage    | [energieinstitut-linz.at](https://energieinstitut-linz.at/en/project/entwicklung-eines-entscheidungsrahmens-fuer-vorranggebiete-zur-implementierung-nachhaltiger-heizwaermetechnologien/) or [boku.ac.at](https://forschung.boku.ac.at/en/projects/15576) |
| funding     | [ffg.at](https://projekte.ffg.at/projekt/4805453) |
| AIT contact | B. Mayr |

**Description**  
The CleanHeatSelector project aims to develop a decision-making framework for identifying priority areas for sustainable heating technologies by integrating technical, environmental, social, economic, and regulatory criteria into energy planning.

---

(references-projects-deriske)=
### DeRisk-E

| **Factsheet** |   |
|-------------|---|
| title       | Derisking the Austrian Electricity Sector Transformation towards Decarbonisation |
| homepage    | - |
| funding     | [ffg.at](https://projekte.ffg.at/projekt/5124291) |
| AIT contact | D. Suna |

**Description**  
DeRisk-E aims to support Austrian policymakers in derisking the future decarbonized electricity system by combining climate and power system modeling with uncertainty analysis to assess the joint impacts of climate change and geopolitical disruptions on energy resilience.

---

(references-projects-deriskdh)=
### DeRiskDH

| **Factsheet** |   |
|-------------|---|
| title       | Risk mitigation in decarbonization of urban heating networks through grid temperature reductions and flexibility use |
| homepage    | [ait.ac.at](https://www.ait.ac.at/themen/integratedenergysystems/projekte/deriskdh) |
| funding     | [ffg.at](https://www.ffg.at/vorzeigeregionenergie) |
| AIT contact | R. Schmidt |

**Description**  
Risk minimization for decarbonizing heating networks via network temperature reductions and flexibility utilization.

---

(references-projects-enable-dhc)=
### ENABLE-DHC

| **Factsheet** |   |
|-------------|---|
| title       | Enabling strategies and investment plans for efficient, multi-energy and digitalized DHC |
| homepage    | [ait.ac.at](https://www.ait.ac.at/themen/flexibilitaet-geschaeftsmodelle/projekte/dekarbonisierungsstrategien-fuer-die-fernwaerme) |
| funding     | [ec.euopa.eu](https://webgate.ec.europa.eu/life/publicWebsite/project/LIFE23-CET-ENABLE-DHC-101167576/enabling-strategies-and-investment-plans-for-efficient-multi-energy-and-digitalized-dhc) |
| AIT contact | R. Schmidt |

**Description**  
ENABLE DHC aims to foster the switch of district heating and cooling (DHC) networks towards efficient DHC as defined in the Energy Efficiency Directive, by developing 9 case studies of investment plans in 7 European countries.

---

(references-projects-fair-grid)=
### Fair-Grid

| **Factsheet** |   |
|-------------|---|
| title       | Options for Fair Grid Charges to Enhance the Energy Transition in Austria |
| homepage    | [wifo.ac.at](https://www.wifo.ac.at/project/271068/) |
| funding     | [ffg.at](https://projekte.ffg.at/projekt/5124286) |
| AIT contact | C. Corinaldesi |

**Description**  
The Fair-Grid project investigates equitable financing mechanisms for electricity grid expansion and maintenance in a renewable energy transition, ensuring economic efficiency and protecting low-income stakeholders.

---

(references-projects-fair-heat)=
### Fair-Heat

| **Factsheet** |   |
|-------------|---|
| title       | A Comprehensive Analysis of Options for a Fair Heat Transition in Austria |
| homepage    | [wifo.ac.at](https://fair-heat.wifo.ac.at/) |
| funding     | [ffg.at](https://projekte.ffg.at/projekt/5124286) |
| AIT contact | G. Resch |

**Description**  
The Fair-Heat project investigates how to achieve a socially equitable and technically feasible decarbonisation of Austria’s residential building sector by 2040 through model-based analysis of building upgrades, energy system integration, and policy mechanisms, with particular attention to investment needs, electricity interactions, and impacts on vulnerable households.

---

(references-projects-goes)=
### GOES

| **Factsheet** |   |
|-------------|---|
| title       | Geothermal based Optimized Energy Systems |
| homepage    | [goes-project.info](https://www.goes-project.info/) |
| funding     | [ffg.at](https://projekte.ffg.at/projekt/4448096) |
| AIT contact | N. Marx |

**Description**  
The project GOES aims to develop a Platform-Based Design (PBD) framework to enable rapid and transferable innovations and implementations of geothermal coupled energy systems.

---

(references-projects-h2real)=
### H2REAL

| **Factsheet** |   |
|-------------|---|
| title       | Hydrogen Region East Austria goes Live |
| homepage    | [ait.ac.at](https://www.ait.ac.at/themen/flexibilitaet-geschaeftsmodelle/projekte/h2real) |
| funding     | [klimafonds.gv.at](https://www.klimafonds.gv.at/projekt/h2real/), [Vorzeigeregion Energie @ ffg.at](https://www.ffg.at/vorzeigeregionenergie) |
| AIT contact | S. Reuter |

**Description**  
The project H2REAL aims to establish a Hydrogen Valley in Eastern Austria by integrating key regional stakeholders across the entire green hydrogen value chain to enable efficient demonstration and scalable deployment of hydrogen technologies.

---

(references-projects-heathighway)=
### Heat Highway

| **Factsheet** |   |
|-------------|---|
| title       | Heat Highway |
| homepage    | [ait.ac.at](https://www.ait.ac.at/themen/integratedenergysystems/projekte/heat-highway) |
| funding     | [ffg.at](https://projekte.ffg.at/projekt/3851881) |
| AIT contact | R. Schmidt |

**Description**  
The HeatHighway project investigates supra-regional heat transmission networks, focusing on the use of multiple waste heat sources.

---

(references-projects-heatminedh)=
### HeatMineDH

| **Factsheet** |   |
|-------------|---|
| title       | Low-Grade Renewable and Waste Heat Mapping and Investment Planning for Efficient District Heating |
| homepage    | [ait.ac.at](https://www.ait.ac.at/themen/integratedenergysystems/projekte/heatminedh) |
| funding     | [cinea.ec.europa.eu](https://cinea.ec.europa.eu/programmes/life_en) |
| AIT contact | R. Schmidt |

**Description**  
HeatMineDH aims to develop business cases and investment plans for the incorporation of low-grade heat sources into high temperature district heating networks.

---

(references-projects-heatrock)=
### HEATROCK

| **Factsheet** |   |
|-------------|---|
| title       | Cavern Thermal Energy Storage in Crystalline Rocks |
| homepage    | [ait.ac.at](https://www.ait.ac.at/themen/waermenetze-und-kaeltenetze-fuer-stadt-und-industrie/projekte/entwicklung-von-kavernenwaermespeicher-in-oesterreich) |
| funding     | [ffg.at](https://projekte.ffg.at/projekt/5126054) |
| AIT contact | A. Dahash |

**Description**  
The HEATROCK project aims to advance cavern thermal energy storage technology for urban district heating from TRL 2 to TRL 4, offering a cost-effective, space-efficient, and socially acceptable solution for seasonal heat storage to support Austria's transition to climate-neutral energy.

---

(references-projects-hy2heat)=
### HY2HEAT

| **Factsheet** |   |
|-------------|---|
| title       | Using electrolysis waste heat in district heating networks |
| homepage    | [hytechonomy.com](https://energieinstitut-linz.at/en/project/using-electrolysis-waste-heat-in-district-heating-networks/) |
| funding     | [iea-dhc.org](https://www.iea-dhc.org/the-research/annexes/annex-xiv/annex-xiv-project-06) |
| AIT contact | N. Marx |

**Description**  
The aim of HY2HEAT is to analyse the techno-economic synergies of electrolysis waste heat integration in district heating systems (including the assessment of the role and expected volumes), to evaluate the best technical solutions for capturing and upgrading the electrolyser waste heat for utilisation in district heating networks, and to derive a practical guide for district heating operators for the pursuit of the potential and its technical integration.

---

(references-projects-hytechonomy)=
### HyTechonomy

| **Factsheet** |   |
|-------------|---|
| title       | Hydrogen Technologies for Sustainable Economies |
| homepage    | [hytechonomy.com](https://www.hytechonomy.com/) |
| funding     | [ffg.at](https://projekte.ffg.at/projekt/3915332) |
| AIT contact | S. Reuter |

**Description**  
The overall scientific vision of the COMET-Project HyTechonomy is to provide the technological and strategic know-how basis for the substitution of the fossil energy carriers by renewable hydrogen.

---

(references-projects-interstores)=
### INTERSTORES

| **Factsheet** |   |
|-------------|---|
| title       | International Innovation Network for the Development of Cost- and Environmentally Efficient Seasonal Thermal Energy Storages |
| homepage    | [interstores.eu](https://interstores.eu/) |
| funding     | European Union, UK Research and Innovation, Federal Department EAER (Swiss Confederation) |
| AIT contact | A. Dahash |

**Description**  
INTERSTORES aims to demonstrate and validate two scalable seasonal thermal energy storage technologies to enhance the reliability, cost-effectiveness, and market readiness of renewable-based energy systems across Europe through full-scale implementation and interdisciplinary collaboration.

---

(references-projects-knowing)=
### KNOWING

| **Factsheet** |   |
|-------------|---|
| title       | KNOWING |
| homepage    | [knowing-climate.eu](https://knowing-climate.eu) |
| funding     | [commission.europa.eu](https://commission.europa.eu/funding-tenders/find-funding/eu-funding-programmes/horizon-europe_en) |
| AIT contact | K. Tovaas |

**Description**  
Modelling of electricity and district heating systems for a full decarbonisation path in 2050 for four demonstration regions: Tallinn, Granollers, Naples and South Westphalia.

---

(references-projects-marktprämien2.0)=
### Marktprämien 2.0

| **Factsheet** |   |
|-------------|---|
| title       | Further Development of Market Premium Support Including the Role of PPAs |
| homepage    | [ait.ac.at](https://www.ait.ac.at/themen/flexibilitaet-geschaeftsmodelle/projekte/marktpraemien-20) |
| funding     | [ffg.at](https://projekte.ffg.at/projekt/4805434) |
| AIT contact | C. Monsberger |

**Description**  
The aim of the short study "Marktprämien 2.0" is to promptly develop proposals for a substantive reform and further development of the market premium system recently established in Austria to promote the expansion of renewable energies in the domestic electricity market.

---

(references-projects-renew)=
### ReNEW

| **Factsheet** |   |
|-------------|---|
| title       | Renewable Energy and Hydrogen System Simulation |
| homepage    | [hycenta.at](https://www.hycenta.at/en/comet-centre) or [tugraz.at](https://online.tugraz.at/tug_online/fdb_detail.ansicht?cvfanr=F55282) |
| funding     | part of [HyCentA / COMET K1 @ ffg.at](https://projekte.ffg.at/projekt/4363503) |
| AIT contact | D. Suna |

**Description**  
The project ReNEW develops an integrated simulation toolchain to enable resilient, cross-sector renewable energy and hydrogen systems, optimizing energy autonomy, infrastructure, and PtX plant strategies based on local needs and techno-economic metrics.

---

(references-projects-tekave)=
### TeKaVe

| **Factsheet** |   |
|-------------|---|
| title       | Technologieneutrale Kapazitätsmechanismen für eine Versorgungssichere Energiezukunft |
| homepage    | [en.ergie.at](https://en.ergie.at/projekte/tekave/) |
| funding     | [ffg.at](https://projekte.ffg.at/projekt/4805444) |
| AIT contact | S. Strömer |

**Description**  
The TeKaVe project investigates whether Austria’s current energy-only market can ensure a secure and decarbonized electricity supply by evaluating capacity mechanisms through regulatory and economic analyses using an innovative modeling approach, combining an agent-based approach with mathematical optimization and decomposition techniques.

---

(references-projects-transpairent-energy)=
### transpAIrent.energy

| **Factsheet** |   |
|-------------|---|
| title       | Transparent AI Forecasts for Green Energy in Austria |
| homepage    | [ait.ac.at](https://www.ait.ac.at/en/research-topics/flexibility-business-models/projects/transpairentenergy) |
| funding     | [ffg.at](https://projekte.ffg.at/projekt/5121370) |
| AIT contact | K. Maggauer, S. Strömer |

**Description**  
The project transpAIrent.energy aims to develop and publicly share transparent, AI-generated probabilistic forecasts for key energy system variables in Austria, using them to optimize the sustainable and economic operation of flexible renewable energy systems.

---

## Contributing

To contribute a new reference, either

- fork the [iesopt](https://github.com/ait-energy/iesopt) repository, and directly add to the above list, or
- open an issue with the reference details.

See the template below for the structure of a reference.

### Template

```markdown
(references-projects-project-slug-title)=
### Project Slug Title

| **Factsheet** |   |
|---------------|---|
| title         | Full Project Title |
| homepage      | [something.com](https://www.something.com/) |
| funding       | [ffg.at](https://projekte.ffg.at/projekt/XXXXXXXXX) |
| AIT contact   | F. Lastname |

**Description**  
Some copy-pasted, or other sort of short description / abstract goes here. A simple prompt like _"Summarize the
following project description in one to two sentences:"_ can help a lot using a LLM of your choice.

---
```

Consider the following:

- If possible link to an `ait.ac.at` subpage for `homepage`.
- Project slug might be `HyTechonomy`, with the full title being `Hydrogen Technologies for Sustainable Economies`, then the link target (the thing above the slug title `(references-projects-project-slug-title)=`) would then be `(references-projects-hytechonomy)=`.
- Replace the `funding` information accordingly.
