# Generated by Django 2.0.8 on 2018-09-11 08:31

# Django
from django.conf import settings
from django.db import migrations, models

# Alliance Auth AFAT
import afat.models


class Migration(migrations.Migration):
    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("afat", "0002_manualfat"),
    ]

    operations = [
        migrations.CreateModel(
            name="AFatDelLog",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("deltype", models.BooleanField(default=0)),
                ("string", models.CharField(max_length=100)),
                (
                    "remover",
                    models.ForeignKey(
                        on_delete=models.SET(afat.models.get_sentinel_user),
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.AlterModelOptions(
            name="afatlink",
            options={
                "permissions": (
                    (
                        "manage_afat",
                        "Can manage the Another Fleet Activity Tracking module",
                    ),
                    ("stats_corp_own", "Can see own corp stats"),
                    ("stats_corp_other", "Can see stats of other corps."),
                    (
                        "stats_char_other",
                        "Can see stats of characters not associated with current user.",
                    ),
                )
            },
        ),
        migrations.RemoveField(
            model_name="afat",
            name="station",
        ),
        migrations.RemoveField(
            model_name="afat",
            name="user",
        ),
        migrations.AlterField(
            model_name="afat",
            name="shiptype",
            field=models.CharField(max_length=100, null=True),
        ),
        migrations.AlterField(
            model_name="afat",
            name="system",
            field=models.CharField(max_length=100, null=True),
        ),
        migrations.AlterField(
            model_name="afatlink",
            name="fleet",
            field=models.CharField(max_length=254, null=True),
        ),
    ]
