# Generated by Django 3.2.4 on 2021-06-17 10:37

# Django
import django.db.models.deletion
import django.utils.timezone
from django.conf import settings
from django.db import migrations, models

# Alliance Auth AFAT
import afat.models


class Migration(migrations.Migration):
    dependencies = [
        ("eveonline", "0014_auto_20210105_1413"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("afat", "0019_add_several_indices"),
    ]

    operations = [
        migrations.AlterField(
            model_name="afat",
            name="afatlink",
            field=models.ForeignKey(
                help_text="The FAT link the character registered at",
                on_delete=django.db.models.deletion.CASCADE,
                related_name="afats",
                to="afat.afatlink",
            ),
        ),
        migrations.AlterField(
            model_name="afat",
            name="character",
            field=models.ForeignKey(
                help_text="Character who registered this FAT",
                on_delete=django.db.models.deletion.CASCADE,
                related_name="afats",
                to="eveonline.evecharacter",
            ),
        ),
        migrations.AlterField(
            model_name="afatlink",
            name="afattime",
            field=models.DateTimeField(
                db_index=True,
                default=django.utils.timezone.now,
                help_text="When was this FAT link created",
            ),
        ),
        migrations.AlterField(
            model_name="afatlink",
            name="character",
            field=models.ForeignKey(
                default=None,
                help_text="Character this FAT link has been created with",
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="+",
                to="eveonline.evecharacter",
            ),
        ),
        migrations.AlterField(
            model_name="afatlink",
            name="creator",
            field=models.ForeignKey(
                help_text="Who created the FAT link?",
                on_delete=models.SET(afat.models.get_sentinel_user),
                related_name="+",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AlterField(
            model_name="afatlink",
            name="fleet",
            field=models.CharField(
                help_text="The FAT link fleet name", max_length=254, null=True
            ),
        ),
        migrations.AlterField(
            model_name="afatlink",
            name="hash",
            field=models.CharField(
                db_index=True,
                help_text="The FAT link hash",
                max_length=254,
                unique=True,
            ),
        ),
        migrations.AlterField(
            model_name="afatlink",
            name="is_esilink",
            field=models.BooleanField(
                default=False,
                help_text="Whether this FAT link was created via ESI or not",
            ),
        ),
        migrations.AlterField(
            model_name="afatlink",
            name="is_registered_on_esi",
            field=models.BooleanField(
                default=False,
                help_text="Whether this is an ESI fat link is registered on ESI or not",
            ),
        ),
        migrations.AlterField(
            model_name="afatlink",
            name="link_type",
            field=models.ForeignKey(
                help_text="The FAT link fleet type, if it's set",
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="+",
                to="afat.afatlinktype",
            ),
        ),
        migrations.AlterField(
            model_name="afatlinktype",
            name="is_enabled",
            field=models.BooleanField(
                db_index=True,
                default=True,
                help_text="Whether this fleet type is active or not",
            ),
        ),
    ]
