# Generated by Django 4.0.10 on 2023-09-22 11:04

# Django
import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models

# Alliance Auth AFAT
import afat.models


class Migration(migrations.Migration):
    dependencies = [
        ("eveonline", "0017_alliance_and_corp_names_are_not_unique"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("afat", "0022_afatlink_esi_error_count"),
    ]

    operations = [
        migrations.RenameModel(
            old_name="AFat",
            new_name="Fat",
        ),
        migrations.RenameField(
            model_name="fat",
            old_name="afatlink",
            new_name="fatlink",
        ),
        migrations.AlterField(
            model_name="fat",
            name="fatlink",
            field=models.ForeignKey(
                help_text="The FAT link the character registered at",
                on_delete=django.db.models.deletion.CASCADE,
                related_name="afat_fats",
                to="afat.afatlink",
            ),
        ),
        migrations.AlterField(
            model_name="fat",
            name="character",
            field=models.ForeignKey(
                help_text="Character who registered this FAT",
                on_delete=django.db.models.deletion.CASCADE,
                related_name="afat_fats",
                to="eveonline.evecharacter",
            ),
        ),
        migrations.RenameModel(
            old_name="AFatLinkType",
            new_name="FleetType",
        ),
        migrations.AlterModelOptions(
            name="fleettype",
            options={
                "default_permissions": (),
                "verbose_name": "Fleet type",
                "verbose_name_plural": "Fleet types",
            },
        ),
        migrations.AlterField(
            model_name="fleettype",
            name="name",
            field=models.CharField(
                help_text="Descriptive name of the fleet type", max_length=254
            ),
        ),
        migrations.RenameModel(
            old_name="AFatLog",
            new_name="Log",
        ),
        migrations.AlterField(
            model_name="log",
            name="user",
            field=models.ForeignKey(
                blank=True,
                default=None,
                null=True,
                on_delete=models.SET(afat.models.get_sentinel_user),
                related_name="afat_log",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AlterModelOptions(
            name="log",
            options={
                "default_permissions": (),
                "verbose_name": "Log",
                "verbose_name_plural": "Logs",
            },
        ),
        migrations.AlterField(
            model_name="log",
            name="log_event",
            field=models.CharField(
                choices=[
                    ("CR_FAT_LINK", "FAT link created"),
                    ("CH_FAT_LINK", "FAT link changed"),
                    ("RM_FAT_LINK", "FAT link removed"),
                    ("RO_FAT_LINK", "FAT link re-opened"),
                    ("RM_FAT", "FAT removed"),
                    ("CR_FAT_MAN", "Manual FAT added"),
                ],
                default="CR_FAT_LINK",
                max_length=11,
            ),
        ),
        migrations.RenameModel(
            old_name="AaAfat",
            new_name="General",
        ),
        migrations.AlterModelOptions(
            name="general",
            options={
                "default_permissions": (),
                "managed": False,
                "permissions": (
                    ("basic_access", "Can access the AFAT module"),
                    ("manage_afat", "Can manage the AFAT module"),
                    ("add_fatlink", "Can create FAT links"),
                    ("stats_corporation_own", "Can see own corporation statistics"),
                    (
                        "stats_corporation_other",
                        "Can see statistics of other corporations",
                    ),
                    ("log_view", "Can view the modules log"),
                ),
                "verbose_name": "AFAT",
            },
        ),
        migrations.RenameModel(
            old_name="ClickAFatDuration",
            new_name="Duration",
        ),
        migrations.AlterModelOptions(
            name="duration",
            options={
                "default_permissions": (),
                "verbose_name": "FAT link duration",
                "verbose_name_plural": "FAT link durations",
            },
        ),
        migrations.AlterField(
            model_name="duration",
            name="fleet",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="duration",
                to="afat.afatlink",
            ),
        ),
        migrations.DeleteModel(
            name="ManualAFat",
        ),
        migrations.RenameModel(
            old_name="AFatLink",
            new_name="FatLink",
        ),
        migrations.AlterUniqueTogether(
            name="fat",
            unique_together={("character", "fatlink")},
        ),
        migrations.AlterModelOptions(
            name="fatlink",
            options={
                "default_permissions": (),
                "ordering": ("-created",),
                "verbose_name": "FAT link",
                "verbose_name_plural": "FAT links",
            },
        ),
        migrations.RenameField(
            model_name="fatlink",
            old_name="afattime",
            new_name="created",
        ),
    ]
