from __future__ import annotations
from dataclasses import asdict, dataclass
from pandas.core.frame import DataFrame
from pandas.core.series import Series
from scipy.stats import kurtosis, skew, spearmanr
from typing import Any, Dict, List, Optional, Tuple, types
from typing_extensions import Self
from dataclasses import dataclass
import builtins
import numpy
import pandas
import re
import sklearn

@dataclass
class EdaScoreBreakdown:
    def weighted_total(self: Self) -> float: ...

@dataclass
class EdaReport:
    def to_dict(self: Self) -> Dict[str, Any]: ...
    def to_markdown(self: Self) -> str: ...

class EDA:
    def __init__(self: Self) -> None: ...
    def _is_public(self: Self, name: str) -> bool: ...
    def _dir_safe(self: Self, mod: Optional[types.ModuleType]) -> List[str]: ...
    def _union_attrs(self: Self) -> List[str]: ...
    def _is_categorical(self: Self, s: Series) -> bool: ...
    def _is_numeric(self: Self, s: Series) -> bool: ...
    def _safe_skew(self: Self, x: np.ndarray) -> Optional[float]: ...
    def _safe_kurtosis(self: Self, x: np.ndarray) -> Optional[float]: ...
    def _spearman_abs(self: Self, x: np.ndarray, y: np.ndarray) -> Optional[float]: ...
    def _pct(self: Self, x: float) -> float: ...
    def _iqr_outlier_share(self: Self, arr: np.ndarray) -> float: ...
    def _corr_proportion_strong(self: Self, corr: DataFrame, thr: float) -> float: ...
    def _canonical_time_lags(self: Self, freq: Optional[str]) -> List[int]: ...
    def _autocorr_at_lags(
        self: Self, series: "pd.Series", lags: List[int]
    ) -> Dict[int, float]: ...
    def _seasonality_strength(self: Self, ac_map: Dict[int, float]) -> float: ...
    def _correlation_ratio_num_cat(
        self: Self, y: "pd.Series", x_cat: "pd.Series"
    ) -> Optional[float]: ...
    def _leakage_hints_per_target(
        self: Self, df_X: DataFrame, y: Series
    ) -> Tuple[float, List[str]]: ...

random = np.random
linalg = np.linalg
fft = np.fft

__name__ = ...

# Modules used internally, to allow implicit dependencies to be seen:
import typing
import pandas
import pandas.core
import pandas.core.series
import dataclasses
import pandas.core.frame
import numpy
import sklearn
import builtins
import scipy
import scipy.stats
import re
