const e=new class{constructor(){this.modal=null,this.currentFile=null,this.initialized=!1,this.contentCache=new Map}initialize(){this.initialized||(this.createModal(),this.setupEventHandlers(),this.initialized=!0,console.log("File viewer initialized"))}createModal(){if(document.body.insertAdjacentHTML("beforeend",'\n            <div class="file-viewer-modal" id="file-viewer-modal">\n                <div class="file-viewer-content">\n                    <div class="file-viewer-header">\n                        <h2>📄 File Viewer</h2>\n                        <button class="file-viewer-close" id="file-viewer-close">×</button>\n                    </div>\n                    <div class="file-viewer-path" id="file-viewer-path">\n                        Loading...\n                    </div>\n                    <div class="file-viewer-body">\n                        <pre class="file-viewer-code" id="file-viewer-code">\n                            <code id="file-viewer-code-content">Loading file content...</code>\n                        </pre>\n                    </div>\n                    <div class="file-viewer-footer">\n                        <div class="file-viewer-info">\n                            <span id="file-viewer-type">Type: --</span>\n                            <span id="file-viewer-lines">Lines: --</span>\n                            <span id="file-viewer-size">Size: --</span>\n                        </div>\n                        <button class="file-viewer-copy" id="file-viewer-copy">📋 Copy</button>\n                    </div>\n                </div>\n            </div>\n        '),this.modal=document.getElementById("file-viewer-modal"),!document.getElementById("file-viewer-styles")){const e="\n                <style id=\"file-viewer-styles\">\n                    .file-viewer-modal {\n                        display: none;\n                        position: fixed;\n                        top: 0;\n                        left: 0;\n                        width: 100%;\n                        height: 100%;\n                        background: rgba(0, 0, 0, 0.7);\n                        z-index: 10000;\n                        animation: fadeIn 0.2s;\n                    }\n\n                    .file-viewer-modal.show {\n                        display: flex;\n                        align-items: center;\n                        justify-content: center;\n                    }\n\n                    .file-viewer-content {\n                        background: #1e1e1e;\n                        border-radius: 8px;\n                        width: 90%;\n                        max-width: 1200px;\n                        height: 80%;\n                        display: flex;\n                        flex-direction: column;\n                        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.5);\n                    }\n\n                    .file-viewer-header {\n                        display: flex;\n                        justify-content: space-between;\n                        align-items: center;\n                        padding: 15px 20px;\n                        background: #2d2d30;\n                        border-radius: 8px 8px 0 0;\n                        border-bottom: 1px solid #3e3e42;\n                    }\n\n                    .file-viewer-header h2 {\n                        margin: 0;\n                        color: #cccccc;\n                        font-size: 18px;\n                    }\n\n                    .file-viewer-close {\n                        background: none;\n                        border: none;\n                        color: #999;\n                        font-size: 24px;\n                        cursor: pointer;\n                        padding: 0;\n                        width: 30px;\n                        height: 30px;\n                        display: flex;\n                        align-items: center;\n                        justify-content: center;\n                    }\n\n                    .file-viewer-close:hover {\n                        color: #fff;\n                    }\n\n                    .file-viewer-path {\n                        padding: 10px 20px;\n                        background: #252526;\n                        color: #8b8b8b;\n                        font-family: 'Consolas', 'Monaco', monospace;\n                        font-size: 12px;\n                        border-bottom: 1px solid #3e3e42;\n                        word-break: break-all;\n                    }\n\n                    .file-viewer-body {\n                        flex: 1;\n                        overflow: auto;\n                        padding: 20px;\n                        background: #1e1e1e;\n                    }\n\n                    .file-viewer-code {\n                        margin: 0;\n                        padding: 0;\n                        background: transparent;\n                        overflow: visible;\n                    }\n\n                    .file-viewer-code code {\n                        font-family: 'Consolas', 'Monaco', 'Courier New', monospace;\n                        font-size: 13px;\n                        line-height: 1.5;\n                        color: #d4d4d4;\n                        white-space: pre;\n                        display: block;\n                    }\n\n                    .file-viewer-footer {\n                        padding: 15px 20px;\n                        background: #2d2d30;\n                        border-top: 1px solid #3e3e42;\n                        display: flex;\n                        justify-content: space-between;\n                        align-items: center;\n                        border-radius: 0 0 8px 8px;\n                    }\n\n                    .file-viewer-info {\n                        display: flex;\n                        gap: 20px;\n                        color: #8b8b8b;\n                        font-size: 12px;\n                    }\n\n                    .file-viewer-copy {\n                        background: #0e639c;\n                        color: white;\n                        border: none;\n                        padding: 6px 12px;\n                        border-radius: 4px;\n                        cursor: pointer;\n                        font-size: 12px;\n                    }\n\n                    .file-viewer-copy:hover {\n                        background: #1177bb;\n                    }\n\n                    .file-viewer-copy.copied {\n                        background: #4ec9b0;\n                    }\n\n                    .file-viewer-error {\n                        color: #f48771;\n                        padding: 20px;\n                        text-align: center;\n                    }\n\n                    @keyframes fadeIn {\n                        from { opacity: 0; }\n                        to { opacity: 1; }\n                    }\n                </style>\n            ";document.head.insertAdjacentHTML("beforeend",e)}}setupEventHandlers(){document.getElementById("file-viewer-close").addEventListener("click",()=>{this.hide()}),this.modal.addEventListener("click",e=>{e.target===this.modal&&this.hide()}),document.addEventListener("keydown",e=>{"Escape"===e.key&&this.modal.classList.contains("show")&&this.hide()}),document.getElementById("file-viewer-copy").addEventListener("click",()=>{this.copyContent()})}async show(e){console.log("[FileViewer] show() called with path:",e),console.log("[FileViewer] initialized:",this.initialized),this.initialized||(console.log("[FileViewer] Not initialized, initializing now..."),this.initialize()),this.currentFile=e,this.modal.classList.add("show"),document.getElementById("file-viewer-path").textContent=e,console.log("[FileViewer] Modal shown, loading file content..."),await this.loadFileContent(e)}hide(){this.modal.classList.remove("show"),this.currentFile=null}async loadFileContent(e){const n=document.getElementById("file-viewer-code-content");if(console.log("[FileViewer] loadFileContent called with path:",e),this.contentCache.has(e))return console.log("[FileViewer] Using cached content for:",e),void this.displayContent(this.contentCache.get(e));n.textContent="Loading file content...";try{if(!window.socket||!window.socket.connected)throw console.error("[FileViewer] No Socket.IO connection available"),new Error("No socket connection available. Please ensure the dashboard is connected to the monitoring server.");{console.log("[FileViewer] Using Socket.IO to load file:",e);const n=new Promise((n,i)=>{const t=setTimeout(()=>{console.error("[FileViewer] Socket.IO request timed out for:",e),i(new Error("Socket.IO request timed out"))},1e4);window.socket.once("file_content_response",e=>{clearTimeout(t),console.log("[FileViewer] Received file_content_response:",e),n(e)}),console.log("[FileViewer] Emitting read_file event with data:",{file_path:e,working_dir:window.workingDirectory||"/",max_size:5242880}),window.socket.emit("read_file",{file_path:e,working_dir:window.workingDirectory||"/",max_size:5242880})}),i=await n;if(!i.success||void 0===i.content)throw console.error("[FileViewer] Server returned error:",i.error),new Error(i.error||"Failed to load file content");console.log("[FileViewer] Successfully loaded file content, caching..."),this.contentCache.set(e,i.content),this.displayContent(i.content),this.updateFileInfo(i)}}catch(i){console.error("[FileViewer] Error loading file:",i),console.error("[FileViewer] Error stack:",i.stack),this.displayError(e,i.message)}}displayContent(e){const n=document.getElementById("file-viewer-code-content");n.textContent=e||"(Empty file)";const i=e?e.split("\n").length:0;document.getElementById("file-viewer-lines").textContent=`Lines: ${i}`;const t=e?new Blob([e]).size:0;document.getElementById("file-viewer-size").textContent=`Size: ${this.formatFileSize(t)}`;const o=this.detectFileType(this.currentFile);if(document.getElementById("file-viewer-type").textContent=`Type: ${o}`,window.Prism){const e=this.detectLanguage(this.currentFile);n.className=`language-${e}`,Prism.highlightElement(n)}}displayError(e,n){const i=`\n            <div class="file-viewer-error">\n                ⚠️ File content loading is not yet implemented\n                \n                File path: ${e}\n                \n                The file viewing functionality requires:\n                1. A server-side /api/file endpoint\n                2. Proper file reading permissions\n                3. Security validation for file access\n                \n                Error: ${n}\n                \n                This feature will be available once the backend API is implemented.\n            </div>\n        `;document.getElementById("file-viewer-code-content").innerHTML=i,document.getElementById("file-viewer-lines").textContent="Lines: --",document.getElementById("file-viewer-size").textContent="Size: --",document.getElementById("file-viewer-type").textContent="Type: --"}updateFileInfo(e){void 0!==e.lines&&(document.getElementById("file-viewer-lines").textContent=`Lines: ${e.lines}`),void 0!==e.size&&(document.getElementById("file-viewer-size").textContent=`Size: ${this.formatFileSize(e.size)}`),e.type&&(document.getElementById("file-viewer-type").textContent=`Type: ${e.type}`)}formatFileSize(e){if(0===e)return"0 Bytes";const n=Math.floor(Math.log(e)/Math.log(1024));return Math.round(e/Math.pow(1024,n)*100)/100+" "+["Bytes","KB","MB","GB"][n]}detectFileType(e){if(!e)return"Unknown";const n=e.split(".").pop()?.toLowerCase();return{py:"Python",js:"JavaScript",ts:"TypeScript",jsx:"React JSX",tsx:"React TSX",html:"HTML",css:"CSS",json:"JSON",xml:"XML",yaml:"YAML",yml:"YAML",md:"Markdown",txt:"Text",sh:"Shell Script",bash:"Bash Script",sql:"SQL",go:"Go",rs:"Rust",java:"Java",cpp:"C++",c:"C",cs:"C#",rb:"Ruby",php:"PHP"}[n]||"Text"}detectLanguage(e){if(!e)return"plaintext";const n=e.split(".").pop()?.toLowerCase();return{py:"python",js:"javascript",ts:"typescript",jsx:"jsx",tsx:"tsx",html:"html",css:"css",json:"json",xml:"xml",yaml:"yaml",yml:"yaml",md:"markdown",sh:"bash",bash:"bash",sql:"sql",go:"go",rs:"rust",java:"java",cpp:"cpp",c:"c",cs:"csharp",rb:"ruby",php:"php"}[n]||"plaintext"}async copyContent(){const e=document.getElementById("file-viewer-code-content"),n=document.getElementById("file-viewer-copy"),i=e.textContent;try{await navigator.clipboard.writeText(i);const e=n.textContent;n.textContent="✅ Copied!",n.classList.add("copied"),setTimeout(()=>{n.textContent=e,n.classList.remove("copied")},2e3)}catch(t){console.error("Failed to copy:",t),alert("Failed to copy content to clipboard")}}};window.showFileViewerModal||(window.showFileViewerModal=n=>{console.log("[FileViewer] showFileViewerModal called with path:",n),e.show(n)}),window.fileViewerInstance=e,"undefined"!=typeof window&&(window.FileViewer=e,"loading"===document.readyState?document.addEventListener("DOMContentLoaded",()=>{e.initialize()}):e.initialize());
//# sourceMappingURL=file-viewer.js.map
