# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'PortfolioSelectedProjectArgs',
    'PortfolioSelectedProjectArgsDict',
    'ProjectSettingArgs',
    'ProjectSettingArgsDict',
    'QualitygateConditionArgs',
    'QualitygateConditionArgsDict',
]

MYPY = False

if not MYPY:
    class PortfolioSelectedProjectArgsDict(TypedDict):
        project_key: pulumi.Input[builtins.str]
        """
        The project key of the project to add to the portfolio
        """
        selected_branches: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A set of branches for the project to add to the portfolio
        """
elif False:
    PortfolioSelectedProjectArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PortfolioSelectedProjectArgs:
    def __init__(__self__, *,
                 project_key: pulumi.Input[builtins.str],
                 selected_branches: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.str] project_key: The project key of the project to add to the portfolio
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] selected_branches: A set of branches for the project to add to the portfolio
        """
        pulumi.set(__self__, "project_key", project_key)
        if selected_branches is not None:
            pulumi.set(__self__, "selected_branches", selected_branches)

    @property
    @pulumi.getter(name="projectKey")
    def project_key(self) -> pulumi.Input[builtins.str]:
        """
        The project key of the project to add to the portfolio
        """
        return pulumi.get(self, "project_key")

    @project_key.setter
    def project_key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "project_key", value)

    @property
    @pulumi.getter(name="selectedBranches")
    def selected_branches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A set of branches for the project to add to the portfolio
        """
        return pulumi.get(self, "selected_branches")

    @selected_branches.setter
    def selected_branches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "selected_branches", value)


if not MYPY:
    class ProjectSettingArgsDict(TypedDict):
        key: pulumi.Input[builtins.str]
        """
        Setting key
        """
        field_values: NotRequired[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]]]
        """
        Setting field values for the supplied key
        """
        value: NotRequired[pulumi.Input[builtins.str]]
        """
        Setting a value for the supplied key
        """
        values: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Setting multi values for the supplied key
        """
elif False:
    ProjectSettingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProjectSettingArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[builtins.str],
                 field_values: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]]] = None,
                 value: Optional[pulumi.Input[builtins.str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.str] key: Setting key
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]] field_values: Setting field values for the supplied key
        :param pulumi.Input[builtins.str] value: Setting a value for the supplied key
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] values: Setting multi values for the supplied key
        """
        pulumi.set(__self__, "key", key)
        if field_values is not None:
            pulumi.set(__self__, "field_values", field_values)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[builtins.str]:
        """
        Setting key
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="fieldValues")
    def field_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]]]:
        """
        Setting field values for the supplied key
        """
        return pulumi.get(self, "field_values")

    @field_values.setter
    def field_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]]]):
        pulumi.set(self, "field_values", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Setting a value for the supplied key
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Setting multi values for the supplied key
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "values", value)


if not MYPY:
    class QualitygateConditionArgsDict(TypedDict):
        metric: pulumi.Input[builtins.str]
        """
        Condition metric.
        """
        op: pulumi.Input[builtins.str]
        """
        Condition operator. Possible values are: LT and GT
        """
        threshold: pulumi.Input[builtins.str]
        """
        Condition error threshold (For ratings: A=1, B=2, C=3, D=4)
        """
        id: NotRequired[pulumi.Input[builtins.str]]
        """
        The ID of this resource.
        """
elif False:
    QualitygateConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class QualitygateConditionArgs:
    def __init__(__self__, *,
                 metric: pulumi.Input[builtins.str],
                 op: pulumi.Input[builtins.str],
                 threshold: pulumi.Input[builtins.str],
                 id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] metric: Condition metric.
        :param pulumi.Input[builtins.str] op: Condition operator. Possible values are: LT and GT
        :param pulumi.Input[builtins.str] threshold: Condition error threshold (For ratings: A=1, B=2, C=3, D=4)
        :param pulumi.Input[builtins.str] id: The ID of this resource.
        """
        pulumi.set(__self__, "metric", metric)
        pulumi.set(__self__, "op", op)
        pulumi.set(__self__, "threshold", threshold)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def metric(self) -> pulumi.Input[builtins.str]:
        """
        Condition metric.
        """
        return pulumi.get(self, "metric")

    @metric.setter
    def metric(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "metric", value)

    @property
    @pulumi.getter
    def op(self) -> pulumi.Input[builtins.str]:
        """
        Condition operator. Possible values are: LT and GT
        """
        return pulumi.get(self, "op")

    @op.setter
    def op(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "op", value)

    @property
    @pulumi.getter
    def threshold(self) -> pulumi.Input[builtins.str]:
        """
        Condition error threshold (For ratings: A=1, B=2, C=3, D=4)
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "threshold", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "id", value)


