# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AlmGithubArgs', 'AlmGithub']

@pulumi.input_type
class AlmGithubArgs:
    def __init__(__self__, *,
                 app_id: pulumi.Input[builtins.str],
                 client_id: pulumi.Input[builtins.str],
                 client_secret: pulumi.Input[builtins.str],
                 key: pulumi.Input[builtins.str],
                 private_key: pulumi.Input[builtins.str],
                 url: pulumi.Input[builtins.str],
                 webhook_secret: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a AlmGithub resource.
        :param pulumi.Input[builtins.str] app_id: GitHub App ID. Maximum length: 80
        :param pulumi.Input[builtins.str] client_id: GitHub App Client ID. Maximum length: 80
        :param pulumi.Input[builtins.str] client_secret: GitHub App Client Secret. Maximum length: 160
        :param pulumi.Input[builtins.str] key: Unique key of the GitHUb instance setting. Maximum length: 200
        :param pulumi.Input[builtins.str] private_key: GitHub App private key. Maximum length: 2500
        :param pulumi.Input[builtins.str] url: GitHub API URL. Maximum length: 2000
        :param pulumi.Input[builtins.str] webhook_secret: GitHub App Webhook Secret. Maximum length: 160
        """
        pulumi.set(__self__, "app_id", app_id)
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_secret", client_secret)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "private_key", private_key)
        pulumi.set(__self__, "url", url)
        if webhook_secret is not None:
            pulumi.set(__self__, "webhook_secret", webhook_secret)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Input[builtins.str]:
        """
        GitHub App ID. Maximum length: 80
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[builtins.str]:
        """
        GitHub App Client ID. Maximum length: 80
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Input[builtins.str]:
        """
        GitHub App Client Secret. Maximum length: 160
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[builtins.str]:
        """
        Unique key of the GitHUb instance setting. Maximum length: 200
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Input[builtins.str]:
        """
        GitHub App private key. Maximum length: 2500
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "private_key", value)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[builtins.str]:
        """
        GitHub API URL. Maximum length: 2000
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="webhookSecret")
    def webhook_secret(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        GitHub App Webhook Secret. Maximum length: 160
        """
        return pulumi.get(self, "webhook_secret")

    @webhook_secret.setter
    def webhook_secret(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "webhook_secret", value)


@pulumi.input_type
class _AlmGithubState:
    def __init__(__self__, *,
                 app_id: Optional[pulumi.Input[builtins.str]] = None,
                 client_id: Optional[pulumi.Input[builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[builtins.str]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 private_key: Optional[pulumi.Input[builtins.str]] = None,
                 url: Optional[pulumi.Input[builtins.str]] = None,
                 webhook_secret: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AlmGithub resources.
        :param pulumi.Input[builtins.str] app_id: GitHub App ID. Maximum length: 80
        :param pulumi.Input[builtins.str] client_id: GitHub App Client ID. Maximum length: 80
        :param pulumi.Input[builtins.str] client_secret: GitHub App Client Secret. Maximum length: 160
        :param pulumi.Input[builtins.str] key: Unique key of the GitHUb instance setting. Maximum length: 200
        :param pulumi.Input[builtins.str] private_key: GitHub App private key. Maximum length: 2500
        :param pulumi.Input[builtins.str] url: GitHub API URL. Maximum length: 2000
        :param pulumi.Input[builtins.str] webhook_secret: GitHub App Webhook Secret. Maximum length: 160
        """
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if webhook_secret is not None:
            pulumi.set(__self__, "webhook_secret", webhook_secret)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        GitHub App ID. Maximum length: 80
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        GitHub App Client ID. Maximum length: 80
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        GitHub App Client Secret. Maximum length: 160
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique key of the GitHUb instance setting. Maximum length: 200
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        GitHub App private key. Maximum length: 2500
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_key", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        GitHub API URL. Maximum length: 2000
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="webhookSecret")
    def webhook_secret(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        GitHub App Webhook Secret. Maximum length: 160
        """
        return pulumi.get(self, "webhook_secret")

    @webhook_secret.setter
    def webhook_secret(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "webhook_secret", value)


class AlmGithub(pulumi.CustomResource):

    pulumi_type = "sonarqube:index/almGithub:AlmGithub"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_id: Optional[pulumi.Input[builtins.str]] = None,
                 client_id: Optional[pulumi.Input[builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[builtins.str]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 private_key: Optional[pulumi.Input[builtins.str]] = None,
                 url: Optional[pulumi.Input[builtins.str]] = None,
                 webhook_secret: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides a Sonarqube GitHub Alm/Devops Platform Integration resource. This can be used to create and manage a Alm/Devops
        Platform Integration for GitHub.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        github_alm = sonarqube.AlmGithub("github-alm",
            app_id="12345",
            client_id="56789",
            client_secret="secret",
            key="myalm",
            private_key="myprivate_key",
            url="https://api.github.com",
            webhook_secret="mysecret")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] app_id: GitHub App ID. Maximum length: 80
        :param pulumi.Input[builtins.str] client_id: GitHub App Client ID. Maximum length: 80
        :param pulumi.Input[builtins.str] client_secret: GitHub App Client Secret. Maximum length: 160
        :param pulumi.Input[builtins.str] key: Unique key of the GitHUb instance setting. Maximum length: 200
        :param pulumi.Input[builtins.str] private_key: GitHub App private key. Maximum length: 2500
        :param pulumi.Input[builtins.str] url: GitHub API URL. Maximum length: 2000
        :param pulumi.Input[builtins.str] webhook_secret: GitHub App Webhook Secret. Maximum length: 160
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AlmGithubArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Sonarqube GitHub Alm/Devops Platform Integration resource. This can be used to create and manage a Alm/Devops
        Platform Integration for GitHub.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        github_alm = sonarqube.AlmGithub("github-alm",
            app_id="12345",
            client_id="56789",
            client_secret="secret",
            key="myalm",
            private_key="myprivate_key",
            url="https://api.github.com",
            webhook_secret="mysecret")
        ```

        :param str resource_name: The name of the resource.
        :param AlmGithubArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AlmGithubArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_id: Optional[pulumi.Input[builtins.str]] = None,
                 client_id: Optional[pulumi.Input[builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[builtins.str]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 private_key: Optional[pulumi.Input[builtins.str]] = None,
                 url: Optional[pulumi.Input[builtins.str]] = None,
                 webhook_secret: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AlmGithubArgs.__new__(AlmGithubArgs)

            if app_id is None and not opts.urn:
                raise TypeError("Missing required property 'app_id'")
            __props__.__dict__["app_id"] = app_id
            if client_id is None and not opts.urn:
                raise TypeError("Missing required property 'client_id'")
            __props__.__dict__["client_id"] = client_id
            if client_secret is None and not opts.urn:
                raise TypeError("Missing required property 'client_secret'")
            __props__.__dict__["client_secret"] = client_secret
            if key is None and not opts.urn:
                raise TypeError("Missing required property 'key'")
            __props__.__dict__["key"] = key
            if private_key is None and not opts.urn:
                raise TypeError("Missing required property 'private_key'")
            __props__.__dict__["private_key"] = private_key
            if url is None and not opts.urn:
                raise TypeError("Missing required property 'url'")
            __props__.__dict__["url"] = url
            __props__.__dict__["webhook_secret"] = webhook_secret
        super(AlmGithub, __self__).__init__(
            'sonarqube:index/almGithub:AlmGithub',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_id: Optional[pulumi.Input[builtins.str]] = None,
            client_id: Optional[pulumi.Input[builtins.str]] = None,
            client_secret: Optional[pulumi.Input[builtins.str]] = None,
            key: Optional[pulumi.Input[builtins.str]] = None,
            private_key: Optional[pulumi.Input[builtins.str]] = None,
            url: Optional[pulumi.Input[builtins.str]] = None,
            webhook_secret: Optional[pulumi.Input[builtins.str]] = None) -> 'AlmGithub':
        """
        Get an existing AlmGithub resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] app_id: GitHub App ID. Maximum length: 80
        :param pulumi.Input[builtins.str] client_id: GitHub App Client ID. Maximum length: 80
        :param pulumi.Input[builtins.str] client_secret: GitHub App Client Secret. Maximum length: 160
        :param pulumi.Input[builtins.str] key: Unique key of the GitHUb instance setting. Maximum length: 200
        :param pulumi.Input[builtins.str] private_key: GitHub App private key. Maximum length: 2500
        :param pulumi.Input[builtins.str] url: GitHub API URL. Maximum length: 2000
        :param pulumi.Input[builtins.str] webhook_secret: GitHub App Webhook Secret. Maximum length: 160
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AlmGithubState.__new__(_AlmGithubState)

        __props__.__dict__["app_id"] = app_id
        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["client_secret"] = client_secret
        __props__.__dict__["key"] = key
        __props__.__dict__["private_key"] = private_key
        __props__.__dict__["url"] = url
        __props__.__dict__["webhook_secret"] = webhook_secret
        return AlmGithub(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Output[builtins.str]:
        """
        GitHub App ID. Maximum length: 80
        """
        return pulumi.get(self, "app_id")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[builtins.str]:
        """
        GitHub App Client ID. Maximum length: 80
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Output[builtins.str]:
        """
        GitHub App Client Secret. Maximum length: 160
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[builtins.str]:
        """
        Unique key of the GitHUb instance setting. Maximum length: 200
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Output[builtins.str]:
        """
        GitHub App private key. Maximum length: 2500
        """
        return pulumi.get(self, "private_key")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[builtins.str]:
        """
        GitHub API URL. Maximum length: 2000
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="webhookSecret")
    def webhook_secret(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        GitHub App Webhook Secret. Maximum length: 160
        """
        return pulumi.get(self, "webhook_secret")

