# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetPortfolioResult',
    'AwaitableGetPortfolioResult',
    'get_portfolio',
    'get_portfolio_output',
]

@pulumi.output_type
class GetPortfolioResult:
    """
    A collection of values returned by getPortfolio.
    """
    def __init__(__self__, branch=None, description=None, id=None, key=None, name=None, qualifier=None, regexp=None, selection_mode=None, tags=None, visibility=None):
        if branch and not isinstance(branch, str):
            raise TypeError("Expected argument 'branch' to be a str")
        pulumi.set(__self__, "branch", branch)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key and not isinstance(key, str):
            raise TypeError("Expected argument 'key' to be a str")
        pulumi.set(__self__, "key", key)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if qualifier and not isinstance(qualifier, str):
            raise TypeError("Expected argument 'qualifier' to be a str")
        pulumi.set(__self__, "qualifier", qualifier)
        if regexp and not isinstance(regexp, str):
            raise TypeError("Expected argument 'regexp' to be a str")
        pulumi.set(__self__, "regexp", regexp)
        if selection_mode and not isinstance(selection_mode, str):
            raise TypeError("Expected argument 'selection_mode' to be a str")
        pulumi.set(__self__, "selection_mode", selection_mode)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if visibility and not isinstance(visibility, str):
            raise TypeError("Expected argument 'visibility' to be a str")
        pulumi.set(__self__, "visibility", visibility)

    @property
    @pulumi.getter
    def branch(self) -> builtins.str:
        """
        Which branch is analyzed
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description of the portfolio
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The key of the portfolio
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the portfolio
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def qualifier(self) -> builtins.str:
        """
        `VW` (portfolios always have this qualifier)
        """
        return pulumi.get(self, "qualifier")

    @property
    @pulumi.getter
    def regexp(self) -> builtins.str:
        """
        The regular expression used to populate the portfolio. Only active when `selection_mode` is `REGEXP`
        """
        return pulumi.get(self, "regexp")

    @property
    @pulumi.getter(name="selectionMode")
    def selection_mode(self) -> builtins.str:
        """
        How the Portfolio is populated. Possible values are `NONE`, `MANUAL`, `TAGS`, `REGEXP` or `REST`. [See docs](https://docs.sonarqube.org/9.8/project-administration/managing-portfolios/#populating-portfolios) for how Portfolio population works
        """
        return pulumi.get(self, "selection_mode")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[builtins.str]:
        """
        The list of tags used to populate the Portfolio. Only active when `selection_mode` is `TAGS`
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def visibility(self) -> builtins.str:
        """
        Portfolio visibility
        """
        return pulumi.get(self, "visibility")


class AwaitableGetPortfolioResult(GetPortfolioResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPortfolioResult(
            branch=self.branch,
            description=self.description,
            id=self.id,
            key=self.key,
            name=self.name,
            qualifier=self.qualifier,
            regexp=self.regexp,
            selection_mode=self.selection_mode,
            tags=self.tags,
            visibility=self.visibility)


def get_portfolio(key: Optional[builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPortfolioResult:
    """
    Use this data source to get a Sonarqube portfolio resource

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sonarqube as sonarqube

    portfolio = sonarqube.get_portfolio(key="portfolio-key")
    ```


    :param builtins.str key: The key of the portfolio
    """
    __args__ = dict()
    __args__['key'] = key
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sonarqube:index/getPortfolio:getPortfolio', __args__, opts=opts, typ=GetPortfolioResult).value

    return AwaitableGetPortfolioResult(
        branch=pulumi.get(__ret__, 'branch'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        key=pulumi.get(__ret__, 'key'),
        name=pulumi.get(__ret__, 'name'),
        qualifier=pulumi.get(__ret__, 'qualifier'),
        regexp=pulumi.get(__ret__, 'regexp'),
        selection_mode=pulumi.get(__ret__, 'selection_mode'),
        tags=pulumi.get(__ret__, 'tags'),
        visibility=pulumi.get(__ret__, 'visibility'))
def get_portfolio_output(key: Optional[pulumi.Input[builtins.str]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPortfolioResult]:
    """
    Use this data source to get a Sonarqube portfolio resource

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sonarqube as sonarqube

    portfolio = sonarqube.get_portfolio(key="portfolio-key")
    ```


    :param builtins.str key: The key of the portfolio
    """
    __args__ = dict()
    __args__['key'] = key
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sonarqube:index/getPortfolio:getPortfolio', __args__, opts=opts, typ=GetPortfolioResult)
    return __ret__.apply(lambda __response__: GetPortfolioResult(
        branch=pulumi.get(__response__, 'branch'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        key=pulumi.get(__response__, 'key'),
        name=pulumi.get(__response__, 'name'),
        qualifier=pulumi.get(__response__, 'qualifier'),
        regexp=pulumi.get(__response__, 'regexp'),
        selection_mode=pulumi.get(__response__, 'selection_mode'),
        tags=pulumi.get(__response__, 'tags'),
        visibility=pulumi.get(__response__, 'visibility')))
