# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['GitlabBindingArgs', 'GitlabBinding']

@pulumi.input_type
class GitlabBindingArgs:
    def __init__(__self__, *,
                 alm_setting: pulumi.Input[builtins.str],
                 project: pulumi.Input[builtins.str],
                 repository: pulumi.Input[builtins.str],
                 monorepo: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a GitlabBinding resource.
        :param pulumi.Input[builtins.str] alm_setting: GitLab ALM setting key
        :param pulumi.Input[builtins.str] project: SonarQube project key. Changing this will force a new resource to be created
        :param pulumi.Input[builtins.str] repository: The GitLab project ID
        :param pulumi.Input[builtins.str] monorepo: Is this project part of a monorepo. Default value: false
        """
        pulumi.set(__self__, "alm_setting", alm_setting)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "repository", repository)
        if monorepo is not None:
            pulumi.set(__self__, "monorepo", monorepo)

    @property
    @pulumi.getter(name="almSetting")
    def alm_setting(self) -> pulumi.Input[builtins.str]:
        """
        GitLab ALM setting key
        """
        return pulumi.get(self, "alm_setting")

    @alm_setting.setter
    def alm_setting(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "alm_setting", value)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[builtins.str]:
        """
        SonarQube project key. Changing this will force a new resource to be created
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def repository(self) -> pulumi.Input[builtins.str]:
        """
        The GitLab project ID
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "repository", value)

    @property
    @pulumi.getter
    def monorepo(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Is this project part of a monorepo. Default value: false
        """
        return pulumi.get(self, "monorepo")

    @monorepo.setter
    def monorepo(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "monorepo", value)


@pulumi.input_type
class _GitlabBindingState:
    def __init__(__self__, *,
                 alm_setting: Optional[pulumi.Input[builtins.str]] = None,
                 monorepo: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 repository: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering GitlabBinding resources.
        :param pulumi.Input[builtins.str] alm_setting: GitLab ALM setting key
        :param pulumi.Input[builtins.str] monorepo: Is this project part of a monorepo. Default value: false
        :param pulumi.Input[builtins.str] project: SonarQube project key. Changing this will force a new resource to be created
        :param pulumi.Input[builtins.str] repository: The GitLab project ID
        """
        if alm_setting is not None:
            pulumi.set(__self__, "alm_setting", alm_setting)
        if monorepo is not None:
            pulumi.set(__self__, "monorepo", monorepo)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)

    @property
    @pulumi.getter(name="almSetting")
    def alm_setting(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        GitLab ALM setting key
        """
        return pulumi.get(self, "alm_setting")

    @alm_setting.setter
    def alm_setting(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "alm_setting", value)

    @property
    @pulumi.getter
    def monorepo(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Is this project part of a monorepo. Default value: false
        """
        return pulumi.get(self, "monorepo")

    @monorepo.setter
    def monorepo(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "monorepo", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        SonarQube project key. Changing this will force a new resource to be created
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def repository(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The GitLab project ID
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "repository", value)


class GitlabBinding(pulumi.CustomResource):

    pulumi_type = "sonarqube:index/gitlabBinding:GitlabBinding"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alm_setting: Optional[pulumi.Input[builtins.str]] = None,
                 monorepo: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 repository: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides a Sonarqube GitLab binding resource. This can be used to create and manage the binding between a
        GitLab repository and a SonarQube project

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        gitlab_alm = sonarqube.AlmGitlab("gitlab-alm",
            key="myalm",
            personal_access_token="my_personal_access_token",
            url="https://gitlab.com/api/v4")
        main = sonarqube.Project("main",
            project="my_project",
            visibility="public")
        gitlab_binding = sonarqube.GitlabBinding("gitlab-binding",
            alm_setting=gitlab_alm.key,
            project="my_project",
            repository="123")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] alm_setting: GitLab ALM setting key
        :param pulumi.Input[builtins.str] monorepo: Is this project part of a monorepo. Default value: false
        :param pulumi.Input[builtins.str] project: SonarQube project key. Changing this will force a new resource to be created
        :param pulumi.Input[builtins.str] repository: The GitLab project ID
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GitlabBindingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Sonarqube GitLab binding resource. This can be used to create and manage the binding between a
        GitLab repository and a SonarQube project

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        gitlab_alm = sonarqube.AlmGitlab("gitlab-alm",
            key="myalm",
            personal_access_token="my_personal_access_token",
            url="https://gitlab.com/api/v4")
        main = sonarqube.Project("main",
            project="my_project",
            visibility="public")
        gitlab_binding = sonarqube.GitlabBinding("gitlab-binding",
            alm_setting=gitlab_alm.key,
            project="my_project",
            repository="123")
        ```

        :param str resource_name: The name of the resource.
        :param GitlabBindingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GitlabBindingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alm_setting: Optional[pulumi.Input[builtins.str]] = None,
                 monorepo: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 repository: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GitlabBindingArgs.__new__(GitlabBindingArgs)

            if alm_setting is None and not opts.urn:
                raise TypeError("Missing required property 'alm_setting'")
            __props__.__dict__["alm_setting"] = alm_setting
            __props__.__dict__["monorepo"] = monorepo
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            if repository is None and not opts.urn:
                raise TypeError("Missing required property 'repository'")
            __props__.__dict__["repository"] = repository
        super(GitlabBinding, __self__).__init__(
            'sonarqube:index/gitlabBinding:GitlabBinding',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alm_setting: Optional[pulumi.Input[builtins.str]] = None,
            monorepo: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            repository: Optional[pulumi.Input[builtins.str]] = None) -> 'GitlabBinding':
        """
        Get an existing GitlabBinding resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] alm_setting: GitLab ALM setting key
        :param pulumi.Input[builtins.str] monorepo: Is this project part of a monorepo. Default value: false
        :param pulumi.Input[builtins.str] project: SonarQube project key. Changing this will force a new resource to be created
        :param pulumi.Input[builtins.str] repository: The GitLab project ID
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GitlabBindingState.__new__(_GitlabBindingState)

        __props__.__dict__["alm_setting"] = alm_setting
        __props__.__dict__["monorepo"] = monorepo
        __props__.__dict__["project"] = project
        __props__.__dict__["repository"] = repository
        return GitlabBinding(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="almSetting")
    def alm_setting(self) -> pulumi.Output[builtins.str]:
        """
        GitLab ALM setting key
        """
        return pulumi.get(self, "alm_setting")

    @property
    @pulumi.getter
    def monorepo(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Is this project part of a monorepo. Default value: false
        """
        return pulumi.get(self, "monorepo")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        SonarQube project key. Changing this will force a new resource to be created
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def repository(self) -> pulumi.Output[builtins.str]:
        """
        The GitLab project ID
        """
        return pulumi.get(self, "repository")

