# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['NewCodePeriodsArgs', 'NewCodePeriods']

@pulumi.input_type
class NewCodePeriodsArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[builtins.str],
                 branch: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 value: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a NewCodePeriods resource.
        :param pulumi.Input[builtins.str] type: The kind of new code period to use. Supported values are SPECIFIC*ANALYSIS, PREVIOUS*VERSION, NUMBER*OF*DAYS, or REFERENCE_BRANCH.
        :param pulumi.Input[builtins.str] branch: The name of a branch of a project for which the new code period will be configured. Changing this will force a new resource to be created. Setting this also requires setting the 'project' argument.
        :param pulumi.Input[builtins.str] project: The key of a project for which the new code period will be configured. Changing this will force a new resource to be created.
        :param pulumi.Input[builtins.str] value: The desired value of the new code period. Varies based on the 'type'. For SPECIFIC*ANALYIS, the value must be the UUID of a previous analysis. For NUMBER*OF*DAYS it must be a numeric string. For REFERENCE*BRANCH it should be the name of branch on the project. For PREVIOUS_VERSION it must **not** be set.
        """
        pulumi.set(__self__, "type", type)
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        The kind of new code period to use. Supported values are SPECIFIC*ANALYSIS, PREVIOUS*VERSION, NUMBER*OF*DAYS, or REFERENCE_BRANCH.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def branch(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of a branch of a project for which the new code period will be configured. Changing this will force a new resource to be created. Setting this also requires setting the 'project' argument.
        """
        return pulumi.get(self, "branch")

    @branch.setter
    def branch(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "branch", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The key of a project for which the new code period will be configured. Changing this will force a new resource to be created.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The desired value of the new code period. Varies based on the 'type'. For SPECIFIC*ANALYIS, the value must be the UUID of a previous analysis. For NUMBER*OF*DAYS it must be a numeric string. For REFERENCE*BRANCH it should be the name of branch on the project. For PREVIOUS_VERSION it must **not** be set.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class _NewCodePeriodsState:
    def __init__(__self__, *,
                 branch: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 value: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering NewCodePeriods resources.
        :param pulumi.Input[builtins.str] branch: The name of a branch of a project for which the new code period will be configured. Changing this will force a new resource to be created. Setting this also requires setting the 'project' argument.
        :param pulumi.Input[builtins.str] project: The key of a project for which the new code period will be configured. Changing this will force a new resource to be created.
        :param pulumi.Input[builtins.str] type: The kind of new code period to use. Supported values are SPECIFIC*ANALYSIS, PREVIOUS*VERSION, NUMBER*OF*DAYS, or REFERENCE_BRANCH.
        :param pulumi.Input[builtins.str] value: The desired value of the new code period. Varies based on the 'type'. For SPECIFIC*ANALYIS, the value must be the UUID of a previous analysis. For NUMBER*OF*DAYS it must be a numeric string. For REFERENCE*BRANCH it should be the name of branch on the project. For PREVIOUS_VERSION it must **not** be set.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def branch(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of a branch of a project for which the new code period will be configured. Changing this will force a new resource to be created. Setting this also requires setting the 'project' argument.
        """
        return pulumi.get(self, "branch")

    @branch.setter
    def branch(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "branch", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The key of a project for which the new code period will be configured. Changing this will force a new resource to be created.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The kind of new code period to use. Supported values are SPECIFIC*ANALYSIS, PREVIOUS*VERSION, NUMBER*OF*DAYS, or REFERENCE_BRANCH.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The desired value of the new code period. Varies based on the 'type'. For SPECIFIC*ANALYIS, the value must be the UUID of a previous analysis. For NUMBER*OF*DAYS it must be a numeric string. For REFERENCE*BRANCH it should be the name of branch on the project. For PREVIOUS_VERSION it must **not** be set.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "value", value)


class NewCodePeriods(pulumi.CustomResource):

    pulumi_type = "sonarqube:index/newCodePeriods:NewCodePeriods"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 branch: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 value: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides a Sonarqube New Code Periods resource. This can be used to manage Sonarqube New Code Periods.

        ## Example Usage

        ### Example: Set the global new code period to a number of days
        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        code_period = sonarqube.NewCodePeriods("codePeriod",
            type="NUMBER_OF_DAYS",
            value="7")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] branch: The name of a branch of a project for which the new code period will be configured. Changing this will force a new resource to be created. Setting this also requires setting the 'project' argument.
        :param pulumi.Input[builtins.str] project: The key of a project for which the new code period will be configured. Changing this will force a new resource to be created.
        :param pulumi.Input[builtins.str] type: The kind of new code period to use. Supported values are SPECIFIC*ANALYSIS, PREVIOUS*VERSION, NUMBER*OF*DAYS, or REFERENCE_BRANCH.
        :param pulumi.Input[builtins.str] value: The desired value of the new code period. Varies based on the 'type'. For SPECIFIC*ANALYIS, the value must be the UUID of a previous analysis. For NUMBER*OF*DAYS it must be a numeric string. For REFERENCE*BRANCH it should be the name of branch on the project. For PREVIOUS_VERSION it must **not** be set.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NewCodePeriodsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Sonarqube New Code Periods resource. This can be used to manage Sonarqube New Code Periods.

        ## Example Usage

        ### Example: Set the global new code period to a number of days
        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        code_period = sonarqube.NewCodePeriods("codePeriod",
            type="NUMBER_OF_DAYS",
            value="7")
        ```

        :param str resource_name: The name of the resource.
        :param NewCodePeriodsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NewCodePeriodsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 branch: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 value: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NewCodePeriodsArgs.__new__(NewCodePeriodsArgs)

            __props__.__dict__["branch"] = branch
            __props__.__dict__["project"] = project
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["value"] = value
        super(NewCodePeriods, __self__).__init__(
            'sonarqube:index/newCodePeriods:NewCodePeriods',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            branch: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None,
            value: Optional[pulumi.Input[builtins.str]] = None) -> 'NewCodePeriods':
        """
        Get an existing NewCodePeriods resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] branch: The name of a branch of a project for which the new code period will be configured. Changing this will force a new resource to be created. Setting this also requires setting the 'project' argument.
        :param pulumi.Input[builtins.str] project: The key of a project for which the new code period will be configured. Changing this will force a new resource to be created.
        :param pulumi.Input[builtins.str] type: The kind of new code period to use. Supported values are SPECIFIC*ANALYSIS, PREVIOUS*VERSION, NUMBER*OF*DAYS, or REFERENCE_BRANCH.
        :param pulumi.Input[builtins.str] value: The desired value of the new code period. Varies based on the 'type'. For SPECIFIC*ANALYIS, the value must be the UUID of a previous analysis. For NUMBER*OF*DAYS it must be a numeric string. For REFERENCE*BRANCH it should be the name of branch on the project. For PREVIOUS_VERSION it must **not** be set.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NewCodePeriodsState.__new__(_NewCodePeriodsState)

        __props__.__dict__["branch"] = branch
        __props__.__dict__["project"] = project
        __props__.__dict__["type"] = type
        __props__.__dict__["value"] = value
        return NewCodePeriods(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def branch(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of a branch of a project for which the new code period will be configured. Changing this will force a new resource to be created. Setting this also requires setting the 'project' argument.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The key of a project for which the new code period will be configured. Changing this will force a new resource to be created.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        The kind of new code period to use. Supported values are SPECIFIC*ANALYSIS, PREVIOUS*VERSION, NUMBER*OF*DAYS, or REFERENCE_BRANCH.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The desired value of the new code period. Varies based on the 'type'. For SPECIFIC*ANALYIS, the value must be the UUID of a previous analysis. For NUMBER*OF*DAYS it must be a numeric string. For REFERENCE*BRANCH it should be the name of branch on the project. For PREVIOUS_VERSION it must **not** be set.
        """
        return pulumi.get(self, "value")

