# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['PermissionTemplateArgs', 'PermissionTemplate']

@pulumi.input_type
class PermissionTemplateArgs:
    def __init__(__self__, *,
                 default: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_key_pattern: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a PermissionTemplate resource.
        :param pulumi.Input[builtins.bool] default: Set the template as the default. This can only be set for one template.
        :param pulumi.Input[builtins.str] description: Description of the Template.
        :param pulumi.Input[builtins.str] name: The name of the Permission template to create. Do not use names with `/`. If needed, use `replace(var.permission_template_name, "/", "_")`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] project_key_pattern: The project key pattern. Must be a valid Java regular expression.
        """
        if default is not None:
            pulumi.set(__self__, "default", default)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_key_pattern is not None:
            pulumi.set(__self__, "project_key_pattern", project_key_pattern)

    @property
    @pulumi.getter
    def default(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Set the template as the default. This can only be set for one template.
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "default", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the Template.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Permission template to create. Do not use names with `/`. If needed, use `replace(var.permission_template_name, "/", "_")`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectKeyPattern")
    def project_key_pattern(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The project key pattern. Must be a valid Java regular expression.
        """
        return pulumi.get(self, "project_key_pattern")

    @project_key_pattern.setter
    def project_key_pattern(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_key_pattern", value)


@pulumi.input_type
class _PermissionTemplateState:
    def __init__(__self__, *,
                 default: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_key_pattern: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering PermissionTemplate resources.
        :param pulumi.Input[builtins.bool] default: Set the template as the default. This can only be set for one template.
        :param pulumi.Input[builtins.str] description: Description of the Template.
        :param pulumi.Input[builtins.str] name: The name of the Permission template to create. Do not use names with `/`. If needed, use `replace(var.permission_template_name, "/", "_")`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] project_key_pattern: The project key pattern. Must be a valid Java regular expression.
        """
        if default is not None:
            pulumi.set(__self__, "default", default)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_key_pattern is not None:
            pulumi.set(__self__, "project_key_pattern", project_key_pattern)

    @property
    @pulumi.getter
    def default(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Set the template as the default. This can only be set for one template.
        """
        return pulumi.get(self, "default")

    @default.setter
    def default(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "default", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the Template.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Permission template to create. Do not use names with `/`. If needed, use `replace(var.permission_template_name, "/", "_")`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectKeyPattern")
    def project_key_pattern(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The project key pattern. Must be a valid Java regular expression.
        """
        return pulumi.get(self, "project_key_pattern")

    @project_key_pattern.setter
    def project_key_pattern(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_key_pattern", value)


class PermissionTemplate(pulumi.CustomResource):

    pulumi_type = "sonarqube:index/permissionTemplate:PermissionTemplate"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_key_pattern: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides a Sonarqube Permission template resource. This can be used to create and manage Sonarqube Permission
        templates.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        template = sonarqube.PermissionTemplate("template",
            description="These are internal projects",
            project_key_pattern="internal.*")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] default: Set the template as the default. This can only be set for one template.
        :param pulumi.Input[builtins.str] description: Description of the Template.
        :param pulumi.Input[builtins.str] name: The name of the Permission template to create. Do not use names with `/`. If needed, use `replace(var.permission_template_name, "/", "_")`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] project_key_pattern: The project key pattern. Must be a valid Java regular expression.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[PermissionTemplateArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Sonarqube Permission template resource. This can be used to create and manage Sonarqube Permission
        templates.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        template = sonarqube.PermissionTemplate("template",
            description="These are internal projects",
            project_key_pattern="internal.*")
        ```

        :param str resource_name: The name of the resource.
        :param PermissionTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PermissionTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_key_pattern: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PermissionTemplateArgs.__new__(PermissionTemplateArgs)

            __props__.__dict__["default"] = default
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["project_key_pattern"] = project_key_pattern
        super(PermissionTemplate, __self__).__init__(
            'sonarqube:index/permissionTemplate:PermissionTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            default: Optional[pulumi.Input[builtins.bool]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project_key_pattern: Optional[pulumi.Input[builtins.str]] = None) -> 'PermissionTemplate':
        """
        Get an existing PermissionTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] default: Set the template as the default. This can only be set for one template.
        :param pulumi.Input[builtins.str] description: Description of the Template.
        :param pulumi.Input[builtins.str] name: The name of the Permission template to create. Do not use names with `/`. If needed, use `replace(var.permission_template_name, "/", "_")`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] project_key_pattern: The project key pattern. Must be a valid Java regular expression.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PermissionTemplateState.__new__(_PermissionTemplateState)

        __props__.__dict__["default"] = default
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["project_key_pattern"] = project_key_pattern
        return PermissionTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def default(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Set the template as the default. This can only be set for one template.
        """
        return pulumi.get(self, "default")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description of the Template.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Permission template to create. Do not use names with `/`. If needed, use `replace(var.permission_template_name, "/", "_")`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectKeyPattern")
    def project_key_pattern(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The project key pattern. Must be a valid Java regular expression.
        """
        return pulumi.get(self, "project_key_pattern")

