# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['PermissionsArgs', 'Permissions']

@pulumi.input_type
class PermissionsArgs:
    def __init__(__self__, *,
                 permissions: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 group_name: Optional[pulumi.Input[builtins.str]] = None,
                 login_name: Optional[pulumi.Input[builtins.str]] = None,
                 project_key: Optional[pulumi.Input[builtins.str]] = None,
                 template_id: Optional[pulumi.Input[builtins.str]] = None,
                 template_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Permissions resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] permissions: A list of permissions that should be applied. Changing this forces a new resource to be created. Possible values are: `admin`, `codeviewer`, `issueadmin`, `securityhotspotadmin`, `scan`, `user`.
        :param pulumi.Input[builtins.str] group_name: The name of the Group that should get the specified permissions. Changing this forces a new resource to be created. Cannot be used with `login_name`
        :param pulumi.Input[builtins.str] login_name: The name of the user that should get the specified permissions. Changing this forces a new resource to be created. Cannot be used with `group_name`.
        :param pulumi.Input[builtins.str] project_key: Specify if you want to apply project level permissions. Changing this forces a new resource to be created. Cannot be used with `template_id & template_name`
        :param pulumi.Input[builtins.str] template_id: Specify if you want to apply the permissions to a permission template. Changing this forces a new resource to be created. Cannot be used with `project_key & template_name`
        :param pulumi.Input[builtins.str] template_name: Specify if you want to apply the permissions to a permission template. Changing this forces a new resource to be created. Cannot be used with `project_key & template_id`
        """
        pulumi.set(__self__, "permissions", permissions)
        if group_name is not None:
            pulumi.set(__self__, "group_name", group_name)
        if login_name is not None:
            pulumi.set(__self__, "login_name", login_name)
        if project_key is not None:
            pulumi.set(__self__, "project_key", project_key)
        if template_id is not None:
            pulumi.set(__self__, "template_id", template_id)
        if template_name is not None:
            pulumi.set(__self__, "template_name", template_name)

    @property
    @pulumi.getter
    def permissions(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        A list of permissions that should be applied. Changing this forces a new resource to be created. Possible values are: `admin`, `codeviewer`, `issueadmin`, `securityhotspotadmin`, `scan`, `user`.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "permissions", value)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Group that should get the specified permissions. Changing this forces a new resource to be created. Cannot be used with `login_name`
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "group_name", value)

    @property
    @pulumi.getter(name="loginName")
    def login_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the user that should get the specified permissions. Changing this forces a new resource to be created. Cannot be used with `group_name`.
        """
        return pulumi.get(self, "login_name")

    @login_name.setter
    def login_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "login_name", value)

    @property
    @pulumi.getter(name="projectKey")
    def project_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specify if you want to apply project level permissions. Changing this forces a new resource to be created. Cannot be used with `template_id & template_name`
        """
        return pulumi.get(self, "project_key")

    @project_key.setter
    def project_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_key", value)

    @property
    @pulumi.getter(name="templateId")
    def template_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specify if you want to apply the permissions to a permission template. Changing this forces a new resource to be created. Cannot be used with `project_key & template_name`
        """
        return pulumi.get(self, "template_id")

    @template_id.setter
    def template_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "template_id", value)

    @property
    @pulumi.getter(name="templateName")
    def template_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specify if you want to apply the permissions to a permission template. Changing this forces a new resource to be created. Cannot be used with `project_key & template_id`
        """
        return pulumi.get(self, "template_name")

    @template_name.setter
    def template_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "template_name", value)


@pulumi.input_type
class _PermissionsState:
    def __init__(__self__, *,
                 group_name: Optional[pulumi.Input[builtins.str]] = None,
                 login_name: Optional[pulumi.Input[builtins.str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 project_key: Optional[pulumi.Input[builtins.str]] = None,
                 template_id: Optional[pulumi.Input[builtins.str]] = None,
                 template_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Permissions resources.
        :param pulumi.Input[builtins.str] group_name: The name of the Group that should get the specified permissions. Changing this forces a new resource to be created. Cannot be used with `login_name`
        :param pulumi.Input[builtins.str] login_name: The name of the user that should get the specified permissions. Changing this forces a new resource to be created. Cannot be used with `group_name`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] permissions: A list of permissions that should be applied. Changing this forces a new resource to be created. Possible values are: `admin`, `codeviewer`, `issueadmin`, `securityhotspotadmin`, `scan`, `user`.
        :param pulumi.Input[builtins.str] project_key: Specify if you want to apply project level permissions. Changing this forces a new resource to be created. Cannot be used with `template_id & template_name`
        :param pulumi.Input[builtins.str] template_id: Specify if you want to apply the permissions to a permission template. Changing this forces a new resource to be created. Cannot be used with `project_key & template_name`
        :param pulumi.Input[builtins.str] template_name: Specify if you want to apply the permissions to a permission template. Changing this forces a new resource to be created. Cannot be used with `project_key & template_id`
        """
        if group_name is not None:
            pulumi.set(__self__, "group_name", group_name)
        if login_name is not None:
            pulumi.set(__self__, "login_name", login_name)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if project_key is not None:
            pulumi.set(__self__, "project_key", project_key)
        if template_id is not None:
            pulumi.set(__self__, "template_id", template_id)
        if template_name is not None:
            pulumi.set(__self__, "template_name", template_name)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Group that should get the specified permissions. Changing this forces a new resource to be created. Cannot be used with `login_name`
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "group_name", value)

    @property
    @pulumi.getter(name="loginName")
    def login_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the user that should get the specified permissions. Changing this forces a new resource to be created. Cannot be used with `group_name`.
        """
        return pulumi.get(self, "login_name")

    @login_name.setter
    def login_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "login_name", value)

    @property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of permissions that should be applied. Changing this forces a new resource to be created. Possible values are: `admin`, `codeviewer`, `issueadmin`, `securityhotspotadmin`, `scan`, `user`.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "permissions", value)

    @property
    @pulumi.getter(name="projectKey")
    def project_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specify if you want to apply project level permissions. Changing this forces a new resource to be created. Cannot be used with `template_id & template_name`
        """
        return pulumi.get(self, "project_key")

    @project_key.setter
    def project_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_key", value)

    @property
    @pulumi.getter(name="templateId")
    def template_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specify if you want to apply the permissions to a permission template. Changing this forces a new resource to be created. Cannot be used with `project_key & template_name`
        """
        return pulumi.get(self, "template_id")

    @template_id.setter
    def template_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "template_id", value)

    @property
    @pulumi.getter(name="templateName")
    def template_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specify if you want to apply the permissions to a permission template. Changing this forces a new resource to be created. Cannot be used with `project_key & template_id`
        """
        return pulumi.get(self, "template_name")

    @template_name.setter
    def template_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "template_name", value)


class Permissions(pulumi.CustomResource):

    pulumi_type = "sonarqube:index/permissions:Permissions"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_name: Optional[pulumi.Input[builtins.str]] = None,
                 login_name: Optional[pulumi.Input[builtins.str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 project_key: Optional[pulumi.Input[builtins.str]] = None,
                 template_id: Optional[pulumi.Input[builtins.str]] = None,
                 template_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides a Sonarqube Permissions resource. This can be used to manage global and project permissions.

        ## Example Usage

        ### Example: Set global admin permissions for a group called "my-admins"
        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        my_global_admins = sonarqube.Permissions("myGlobalAdmins",
            group_name="my-admins",
            permissions=["admin"])
        ```

        ### Example: Set project admin permissions for a group called "my-project-admins"
        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        my_project_admins = sonarqube.Permissions("myProjectAdmins",
            group_name="my-project-admins",
            permissions=["admin"],
            project_key="my-project")
        ```

        ### Example: Set project admin permissions for a group called "my-project-admins on a permission template"
        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        internal_admins = sonarqube.Permissions("internalAdmins",
            group_name="my-internal-admins",
            template_id=sonarqube_permission_template["template"]["id"],
            permissions=["admin"])
        ```

        ### Example: Set codeviewer & user permissions on project level for a user called "johndoe"
        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        john_project_read = sonarqube.Permissions("johnProjectRead",
            login_name="johndoe",
            permissions=[
                "codeviewer",
                "user",
            ],
            project_key="my-project")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] group_name: The name of the Group that should get the specified permissions. Changing this forces a new resource to be created. Cannot be used with `login_name`
        :param pulumi.Input[builtins.str] login_name: The name of the user that should get the specified permissions. Changing this forces a new resource to be created. Cannot be used with `group_name`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] permissions: A list of permissions that should be applied. Changing this forces a new resource to be created. Possible values are: `admin`, `codeviewer`, `issueadmin`, `securityhotspotadmin`, `scan`, `user`.
        :param pulumi.Input[builtins.str] project_key: Specify if you want to apply project level permissions. Changing this forces a new resource to be created. Cannot be used with `template_id & template_name`
        :param pulumi.Input[builtins.str] template_id: Specify if you want to apply the permissions to a permission template. Changing this forces a new resource to be created. Cannot be used with `project_key & template_name`
        :param pulumi.Input[builtins.str] template_name: Specify if you want to apply the permissions to a permission template. Changing this forces a new resource to be created. Cannot be used with `project_key & template_id`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PermissionsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Sonarqube Permissions resource. This can be used to manage global and project permissions.

        ## Example Usage

        ### Example: Set global admin permissions for a group called "my-admins"
        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        my_global_admins = sonarqube.Permissions("myGlobalAdmins",
            group_name="my-admins",
            permissions=["admin"])
        ```

        ### Example: Set project admin permissions for a group called "my-project-admins"
        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        my_project_admins = sonarqube.Permissions("myProjectAdmins",
            group_name="my-project-admins",
            permissions=["admin"],
            project_key="my-project")
        ```

        ### Example: Set project admin permissions for a group called "my-project-admins on a permission template"
        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        internal_admins = sonarqube.Permissions("internalAdmins",
            group_name="my-internal-admins",
            template_id=sonarqube_permission_template["template"]["id"],
            permissions=["admin"])
        ```

        ### Example: Set codeviewer & user permissions on project level for a user called "johndoe"
        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        john_project_read = sonarqube.Permissions("johnProjectRead",
            login_name="johndoe",
            permissions=[
                "codeviewer",
                "user",
            ],
            project_key="my-project")
        ```

        :param str resource_name: The name of the resource.
        :param PermissionsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PermissionsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_name: Optional[pulumi.Input[builtins.str]] = None,
                 login_name: Optional[pulumi.Input[builtins.str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 project_key: Optional[pulumi.Input[builtins.str]] = None,
                 template_id: Optional[pulumi.Input[builtins.str]] = None,
                 template_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PermissionsArgs.__new__(PermissionsArgs)

            __props__.__dict__["group_name"] = group_name
            __props__.__dict__["login_name"] = login_name
            if permissions is None and not opts.urn:
                raise TypeError("Missing required property 'permissions'")
            __props__.__dict__["permissions"] = permissions
            __props__.__dict__["project_key"] = project_key
            __props__.__dict__["template_id"] = template_id
            __props__.__dict__["template_name"] = template_name
        super(Permissions, __self__).__init__(
            'sonarqube:index/permissions:Permissions',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            group_name: Optional[pulumi.Input[builtins.str]] = None,
            login_name: Optional[pulumi.Input[builtins.str]] = None,
            permissions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            project_key: Optional[pulumi.Input[builtins.str]] = None,
            template_id: Optional[pulumi.Input[builtins.str]] = None,
            template_name: Optional[pulumi.Input[builtins.str]] = None) -> 'Permissions':
        """
        Get an existing Permissions resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] group_name: The name of the Group that should get the specified permissions. Changing this forces a new resource to be created. Cannot be used with `login_name`
        :param pulumi.Input[builtins.str] login_name: The name of the user that should get the specified permissions. Changing this forces a new resource to be created. Cannot be used with `group_name`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] permissions: A list of permissions that should be applied. Changing this forces a new resource to be created. Possible values are: `admin`, `codeviewer`, `issueadmin`, `securityhotspotadmin`, `scan`, `user`.
        :param pulumi.Input[builtins.str] project_key: Specify if you want to apply project level permissions. Changing this forces a new resource to be created. Cannot be used with `template_id & template_name`
        :param pulumi.Input[builtins.str] template_id: Specify if you want to apply the permissions to a permission template. Changing this forces a new resource to be created. Cannot be used with `project_key & template_name`
        :param pulumi.Input[builtins.str] template_name: Specify if you want to apply the permissions to a permission template. Changing this forces a new resource to be created. Cannot be used with `project_key & template_id`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PermissionsState.__new__(_PermissionsState)

        __props__.__dict__["group_name"] = group_name
        __props__.__dict__["login_name"] = login_name
        __props__.__dict__["permissions"] = permissions
        __props__.__dict__["project_key"] = project_key
        __props__.__dict__["template_id"] = template_id
        __props__.__dict__["template_name"] = template_name
        return Permissions(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the Group that should get the specified permissions. Changing this forces a new resource to be created. Cannot be used with `login_name`
        """
        return pulumi.get(self, "group_name")

    @property
    @pulumi.getter(name="loginName")
    def login_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the user that should get the specified permissions. Changing this forces a new resource to be created. Cannot be used with `group_name`.
        """
        return pulumi.get(self, "login_name")

    @property
    @pulumi.getter
    def permissions(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A list of permissions that should be applied. Changing this forces a new resource to be created. Possible values are: `admin`, `codeviewer`, `issueadmin`, `securityhotspotadmin`, `scan`, `user`.
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter(name="projectKey")
    def project_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specify if you want to apply project level permissions. Changing this forces a new resource to be created. Cannot be used with `template_id & template_name`
        """
        return pulumi.get(self, "project_key")

    @property
    @pulumi.getter(name="templateId")
    def template_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specify if you want to apply the permissions to a permission template. Changing this forces a new resource to be created. Cannot be used with `project_key & template_name`
        """
        return pulumi.get(self, "template_id")

    @property
    @pulumi.getter(name="templateName")
    def template_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specify if you want to apply the permissions to a permission template. Changing this forces a new resource to be created. Cannot be used with `project_key & template_id`
        """
        return pulumi.get(self, "template_name")

