# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PortfolioArgs', 'Portfolio']

@pulumi.input_type
class PortfolioArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[builtins.str],
                 key: pulumi.Input[builtins.str],
                 branch: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 regexp: Optional[pulumi.Input[builtins.str]] = None,
                 selected_projects: Optional[pulumi.Input[Sequence[pulumi.Input['PortfolioSelectedProjectArgs']]]] = None,
                 selection_mode: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 visibility: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Portfolio resource.
        :param pulumi.Input[builtins.str] description: A description of the Portfolio to create
        :param pulumi.Input[builtins.str] key: The key of the Portfolio to create
        :param pulumi.Input[builtins.str] branch: Which branch to analyze. If nothing, or '' is specified, the main branch is used.
        :param pulumi.Input[builtins.str] name: The name of the Portfolio to create
        :param pulumi.Input[builtins.str] regexp: A regular expression that is used to match Projects with a matching name OR key. If they match, they are added to the Portfolio
        :param pulumi.Input[Sequence[pulumi.Input['PortfolioSelectedProjectArgs']]] selected_projects: A set of projects to add to the portfolio.
        :param pulumi.Input[builtins.str] selection_mode: How to populate the Portfolio to create. Possible values are `NONE`, `MANUAL`, `TAGS`, `REGEXP` or `REST`. [See docs](https://docs.sonarqube.org/9.8/project-administration/managing-portfolios/#populating-portfolios) for how Portfolio population works
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: List of Project tags to populate the Portfolio from. Only active when `selection_mode` is `TAGS`
        :param pulumi.Input[builtins.str] visibility: Whether the created portfolio should be visible to everyone, or only specific user/groups. If no visibility is specified, the default portfolio visibility will be `public`.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "key", key)
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if regexp is not None:
            pulumi.set(__self__, "regexp", regexp)
        if selected_projects is not None:
            pulumi.set(__self__, "selected_projects", selected_projects)
        if selection_mode is not None:
            pulumi.set(__self__, "selection_mode", selection_mode)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if visibility is not None:
            pulumi.set(__self__, "visibility", visibility)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[builtins.str]:
        """
        A description of the Portfolio to create
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[builtins.str]:
        """
        The key of the Portfolio to create
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def branch(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Which branch to analyze. If nothing, or '' is specified, the main branch is used.
        """
        return pulumi.get(self, "branch")

    @branch.setter
    def branch(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "branch", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Portfolio to create
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def regexp(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A regular expression that is used to match Projects with a matching name OR key. If they match, they are added to the Portfolio
        """
        return pulumi.get(self, "regexp")

    @regexp.setter
    def regexp(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "regexp", value)

    @property
    @pulumi.getter(name="selectedProjects")
    def selected_projects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PortfolioSelectedProjectArgs']]]]:
        """
        A set of projects to add to the portfolio.
        """
        return pulumi.get(self, "selected_projects")

    @selected_projects.setter
    def selected_projects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PortfolioSelectedProjectArgs']]]]):
        pulumi.set(self, "selected_projects", value)

    @property
    @pulumi.getter(name="selectionMode")
    def selection_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        How to populate the Portfolio to create. Possible values are `NONE`, `MANUAL`, `TAGS`, `REGEXP` or `REST`. [See docs](https://docs.sonarqube.org/9.8/project-administration/managing-portfolios/#populating-portfolios) for how Portfolio population works
        """
        return pulumi.get(self, "selection_mode")

    @selection_mode.setter
    def selection_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "selection_mode", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of Project tags to populate the Portfolio from. Only active when `selection_mode` is `TAGS`
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def visibility(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Whether the created portfolio should be visible to everyone, or only specific user/groups. If no visibility is specified, the default portfolio visibility will be `public`.
        """
        return pulumi.get(self, "visibility")

    @visibility.setter
    def visibility(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "visibility", value)


@pulumi.input_type
class _PortfolioState:
    def __init__(__self__, *,
                 branch: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 qualifier: Optional[pulumi.Input[builtins.str]] = None,
                 regexp: Optional[pulumi.Input[builtins.str]] = None,
                 selected_projects: Optional[pulumi.Input[Sequence[pulumi.Input['PortfolioSelectedProjectArgs']]]] = None,
                 selection_mode: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 visibility: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Portfolio resources.
        :param pulumi.Input[builtins.str] branch: Which branch to analyze. If nothing, or '' is specified, the main branch is used.
        :param pulumi.Input[builtins.str] description: A description of the Portfolio to create
        :param pulumi.Input[builtins.str] key: The key of the Portfolio to create
        :param pulumi.Input[builtins.str] name: The name of the Portfolio to create
        :param pulumi.Input[builtins.str] regexp: A regular expression that is used to match Projects with a matching name OR key. If they match, they are added to the Portfolio
        :param pulumi.Input[Sequence[pulumi.Input['PortfolioSelectedProjectArgs']]] selected_projects: A set of projects to add to the portfolio.
        :param pulumi.Input[builtins.str] selection_mode: How to populate the Portfolio to create. Possible values are `NONE`, `MANUAL`, `TAGS`, `REGEXP` or `REST`. [See docs](https://docs.sonarqube.org/9.8/project-administration/managing-portfolios/#populating-portfolios) for how Portfolio population works
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: List of Project tags to populate the Portfolio from. Only active when `selection_mode` is `TAGS`
        :param pulumi.Input[builtins.str] visibility: Whether the created portfolio should be visible to everyone, or only specific user/groups. If no visibility is specified, the default portfolio visibility will be `public`.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if qualifier is not None:
            pulumi.set(__self__, "qualifier", qualifier)
        if regexp is not None:
            pulumi.set(__self__, "regexp", regexp)
        if selected_projects is not None:
            pulumi.set(__self__, "selected_projects", selected_projects)
        if selection_mode is not None:
            pulumi.set(__self__, "selection_mode", selection_mode)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if visibility is not None:
            pulumi.set(__self__, "visibility", visibility)

    @property
    @pulumi.getter
    def branch(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Which branch to analyze. If nothing, or '' is specified, the main branch is used.
        """
        return pulumi.get(self, "branch")

    @branch.setter
    def branch(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "branch", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description of the Portfolio to create
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The key of the Portfolio to create
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Portfolio to create
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def qualifier(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "qualifier")

    @qualifier.setter
    def qualifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "qualifier", value)

    @property
    @pulumi.getter
    def regexp(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A regular expression that is used to match Projects with a matching name OR key. If they match, they are added to the Portfolio
        """
        return pulumi.get(self, "regexp")

    @regexp.setter
    def regexp(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "regexp", value)

    @property
    @pulumi.getter(name="selectedProjects")
    def selected_projects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PortfolioSelectedProjectArgs']]]]:
        """
        A set of projects to add to the portfolio.
        """
        return pulumi.get(self, "selected_projects")

    @selected_projects.setter
    def selected_projects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PortfolioSelectedProjectArgs']]]]):
        pulumi.set(self, "selected_projects", value)

    @property
    @pulumi.getter(name="selectionMode")
    def selection_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        How to populate the Portfolio to create. Possible values are `NONE`, `MANUAL`, `TAGS`, `REGEXP` or `REST`. [See docs](https://docs.sonarqube.org/9.8/project-administration/managing-portfolios/#populating-portfolios) for how Portfolio population works
        """
        return pulumi.get(self, "selection_mode")

    @selection_mode.setter
    def selection_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "selection_mode", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of Project tags to populate the Portfolio from. Only active when `selection_mode` is `TAGS`
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def visibility(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Whether the created portfolio should be visible to everyone, or only specific user/groups. If no visibility is specified, the default portfolio visibility will be `public`.
        """
        return pulumi.get(self, "visibility")

    @visibility.setter
    def visibility(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "visibility", value)


class Portfolio(pulumi.CustomResource):

    pulumi_type = "sonarqube:index/portfolio:Portfolio"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 branch: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 regexp: Optional[pulumi.Input[builtins.str]] = None,
                 selected_projects: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PortfolioSelectedProjectArgs', 'PortfolioSelectedProjectArgsDict']]]]] = None,
                 selection_mode: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 visibility: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides a Sonarqube Portfolio resource. This can be used to create and manage Sonarqube Portfolio. Note that the SonarQube API for Portfolios is called ``views``

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        main = sonarqube.Portfolio("main",
            description="portfolio-description",
            key="portfolio-key")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] branch: Which branch to analyze. If nothing, or '' is specified, the main branch is used.
        :param pulumi.Input[builtins.str] description: A description of the Portfolio to create
        :param pulumi.Input[builtins.str] key: The key of the Portfolio to create
        :param pulumi.Input[builtins.str] name: The name of the Portfolio to create
        :param pulumi.Input[builtins.str] regexp: A regular expression that is used to match Projects with a matching name OR key. If they match, they are added to the Portfolio
        :param pulumi.Input[Sequence[pulumi.Input[Union['PortfolioSelectedProjectArgs', 'PortfolioSelectedProjectArgsDict']]]] selected_projects: A set of projects to add to the portfolio.
        :param pulumi.Input[builtins.str] selection_mode: How to populate the Portfolio to create. Possible values are `NONE`, `MANUAL`, `TAGS`, `REGEXP` or `REST`. [See docs](https://docs.sonarqube.org/9.8/project-administration/managing-portfolios/#populating-portfolios) for how Portfolio population works
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: List of Project tags to populate the Portfolio from. Only active when `selection_mode` is `TAGS`
        :param pulumi.Input[builtins.str] visibility: Whether the created portfolio should be visible to everyone, or only specific user/groups. If no visibility is specified, the default portfolio visibility will be `public`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PortfolioArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Sonarqube Portfolio resource. This can be used to create and manage Sonarqube Portfolio. Note that the SonarQube API for Portfolios is called ``views``

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        main = sonarqube.Portfolio("main",
            description="portfolio-description",
            key="portfolio-key")
        ```

        :param str resource_name: The name of the resource.
        :param PortfolioArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PortfolioArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 branch: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 regexp: Optional[pulumi.Input[builtins.str]] = None,
                 selected_projects: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PortfolioSelectedProjectArgs', 'PortfolioSelectedProjectArgsDict']]]]] = None,
                 selection_mode: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 visibility: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PortfolioArgs.__new__(PortfolioArgs)

            __props__.__dict__["branch"] = branch
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if key is None and not opts.urn:
                raise TypeError("Missing required property 'key'")
            __props__.__dict__["key"] = key
            __props__.__dict__["name"] = name
            __props__.__dict__["regexp"] = regexp
            __props__.__dict__["selected_projects"] = selected_projects
            __props__.__dict__["selection_mode"] = selection_mode
            __props__.__dict__["tags"] = tags
            __props__.__dict__["visibility"] = visibility
            __props__.__dict__["qualifier"] = None
        super(Portfolio, __self__).__init__(
            'sonarqube:index/portfolio:Portfolio',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            branch: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            key: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            qualifier: Optional[pulumi.Input[builtins.str]] = None,
            regexp: Optional[pulumi.Input[builtins.str]] = None,
            selected_projects: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PortfolioSelectedProjectArgs', 'PortfolioSelectedProjectArgsDict']]]]] = None,
            selection_mode: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            visibility: Optional[pulumi.Input[builtins.str]] = None) -> 'Portfolio':
        """
        Get an existing Portfolio resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] branch: Which branch to analyze. If nothing, or '' is specified, the main branch is used.
        :param pulumi.Input[builtins.str] description: A description of the Portfolio to create
        :param pulumi.Input[builtins.str] key: The key of the Portfolio to create
        :param pulumi.Input[builtins.str] name: The name of the Portfolio to create
        :param pulumi.Input[builtins.str] regexp: A regular expression that is used to match Projects with a matching name OR key. If they match, they are added to the Portfolio
        :param pulumi.Input[Sequence[pulumi.Input[Union['PortfolioSelectedProjectArgs', 'PortfolioSelectedProjectArgsDict']]]] selected_projects: A set of projects to add to the portfolio.
        :param pulumi.Input[builtins.str] selection_mode: How to populate the Portfolio to create. Possible values are `NONE`, `MANUAL`, `TAGS`, `REGEXP` or `REST`. [See docs](https://docs.sonarqube.org/9.8/project-administration/managing-portfolios/#populating-portfolios) for how Portfolio population works
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: List of Project tags to populate the Portfolio from. Only active when `selection_mode` is `TAGS`
        :param pulumi.Input[builtins.str] visibility: Whether the created portfolio should be visible to everyone, or only specific user/groups. If no visibility is specified, the default portfolio visibility will be `public`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PortfolioState.__new__(_PortfolioState)

        __props__.__dict__["branch"] = branch
        __props__.__dict__["description"] = description
        __props__.__dict__["key"] = key
        __props__.__dict__["name"] = name
        __props__.__dict__["qualifier"] = qualifier
        __props__.__dict__["regexp"] = regexp
        __props__.__dict__["selected_projects"] = selected_projects
        __props__.__dict__["selection_mode"] = selection_mode
        __props__.__dict__["tags"] = tags
        __props__.__dict__["visibility"] = visibility
        return Portfolio(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def branch(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Which branch to analyze. If nothing, or '' is specified, the main branch is used.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        A description of the Portfolio to create
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[builtins.str]:
        """
        The key of the Portfolio to create
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Portfolio to create
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def qualifier(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "qualifier")

    @property
    @pulumi.getter
    def regexp(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A regular expression that is used to match Projects with a matching name OR key. If they match, they are added to the Portfolio
        """
        return pulumi.get(self, "regexp")

    @property
    @pulumi.getter(name="selectedProjects")
    def selected_projects(self) -> pulumi.Output[Optional[Sequence['outputs.PortfolioSelectedProject']]]:
        """
        A set of projects to add to the portfolio.
        """
        return pulumi.get(self, "selected_projects")

    @property
    @pulumi.getter(name="selectionMode")
    def selection_mode(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        How to populate the Portfolio to create. Possible values are `NONE`, `MANUAL`, `TAGS`, `REGEXP` or `REST`. [See docs](https://docs.sonarqube.org/9.8/project-administration/managing-portfolios/#populating-portfolios) for how Portfolio population works
        """
        return pulumi.get(self, "selection_mode")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of Project tags to populate the Portfolio from. Only active when `selection_mode` is `TAGS`
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def visibility(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Whether the created portfolio should be visible to everyone, or only specific user/groups. If no visibility is specified, the default portfolio visibility will be `public`.
        """
        return pulumi.get(self, "visibility")

