# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProjectArgs', 'Project']

@pulumi.input_type
class ProjectArgs:
    def __init__(__self__, *,
                 project: pulumi.Input[builtins.str],
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 settings: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSettingArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 visibility: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Project resource.
        :param pulumi.Input[builtins.str] project: Key of the project. Maximum length 400. All letters, digits, dash, underscore, period or colon.
        :param pulumi.Input[builtins.str] name: The name of the Project to create
        :param pulumi.Input[Sequence[pulumi.Input['ProjectSettingArgs']]] settings: A list of settings associated to the project
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A list of tags to put on the project.
        :param pulumi.Input[builtins.str] visibility: Whether the created project should be visible to everyone, or only specific user/groups. If no visibility is specified, the default project visibility of the organization will be used. Valid values are `public` and `private`.
        """
        pulumi.set(__self__, "project", project)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if visibility is not None:
            pulumi.set(__self__, "visibility", visibility)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[builtins.str]:
        """
        Key of the project. Maximum length 400. All letters, digits, dash, underscore, period or colon.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Project to create
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSettingArgs']]]]:
        """
        A list of settings associated to the project
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSettingArgs']]]]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of tags to put on the project.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def visibility(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Whether the created project should be visible to everyone, or only specific user/groups. If no visibility is specified, the default project visibility of the organization will be used. Valid values are `public` and `private`.
        """
        return pulumi.get(self, "visibility")

    @visibility.setter
    def visibility(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "visibility", value)


@pulumi.input_type
class _ProjectState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 settings: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSettingArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 visibility: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Project resources.
        :param pulumi.Input[builtins.str] name: The name of the Project to create
        :param pulumi.Input[builtins.str] project: Key of the project. Maximum length 400. All letters, digits, dash, underscore, period or colon.
        :param pulumi.Input[Sequence[pulumi.Input['ProjectSettingArgs']]] settings: A list of settings associated to the project
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A list of tags to put on the project.
        :param pulumi.Input[builtins.str] visibility: Whether the created project should be visible to everyone, or only specific user/groups. If no visibility is specified, the default project visibility of the organization will be used. Valid values are `public` and `private`.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if visibility is not None:
            pulumi.set(__self__, "visibility", visibility)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Project to create
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Key of the project. Maximum length 400. All letters, digits, dash, underscore, period or colon.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSettingArgs']]]]:
        """
        A list of settings associated to the project
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSettingArgs']]]]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of tags to put on the project.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def visibility(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Whether the created project should be visible to everyone, or only specific user/groups. If no visibility is specified, the default project visibility of the organization will be used. Valid values are `public` and `private`.
        """
        return pulumi.get(self, "visibility")

    @visibility.setter
    def visibility(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "visibility", value)


class Project(pulumi.CustomResource):

    pulumi_type = "sonarqube:index/project:Project"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectSettingArgs', 'ProjectSettingArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 visibility: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides a Sonarqube Project resource. This can be used to create and manage Sonarqube Project.

        ## Example Usage

        ### Example: create a project
        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        main = sonarqube.Project("main",
            project="my_project",
            visibility="public")
        ```

        ### Example: a project with associated settings
        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        main = sonarqube.Project("main",
            project="my_project",
            settings=[{
                "key": "sonar.demo",
                "value": "sonarqube@example.org",
            }],
            visibility="public")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] name: The name of the Project to create
        :param pulumi.Input[builtins.str] project: Key of the project. Maximum length 400. All letters, digits, dash, underscore, period or colon.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProjectSettingArgs', 'ProjectSettingArgsDict']]]] settings: A list of settings associated to the project
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A list of tags to put on the project.
        :param pulumi.Input[builtins.str] visibility: Whether the created project should be visible to everyone, or only specific user/groups. If no visibility is specified, the default project visibility of the organization will be used. Valid values are `public` and `private`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProjectArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Sonarqube Project resource. This can be used to create and manage Sonarqube Project.

        ## Example Usage

        ### Example: create a project
        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        main = sonarqube.Project("main",
            project="my_project",
            visibility="public")
        ```

        ### Example: a project with associated settings
        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        main = sonarqube.Project("main",
            project="my_project",
            settings=[{
                "key": "sonar.demo",
                "value": "sonarqube@example.org",
            }],
            visibility="public")
        ```

        :param str resource_name: The name of the resource.
        :param ProjectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectSettingArgs', 'ProjectSettingArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 visibility: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectArgs.__new__(ProjectArgs)

            __props__.__dict__["name"] = name
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            __props__.__dict__["settings"] = settings
            __props__.__dict__["tags"] = tags
            __props__.__dict__["visibility"] = visibility
        super(Project, __self__).__init__(
            'sonarqube:index/project:Project',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectSettingArgs', 'ProjectSettingArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            visibility: Optional[pulumi.Input[builtins.str]] = None) -> 'Project':
        """
        Get an existing Project resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] name: The name of the Project to create
        :param pulumi.Input[builtins.str] project: Key of the project. Maximum length 400. All letters, digits, dash, underscore, period or colon.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProjectSettingArgs', 'ProjectSettingArgsDict']]]] settings: A list of settings associated to the project
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A list of tags to put on the project.
        :param pulumi.Input[builtins.str] visibility: Whether the created project should be visible to everyone, or only specific user/groups. If no visibility is specified, the default project visibility of the organization will be used. Valid values are `public` and `private`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectState.__new__(_ProjectState)

        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["settings"] = settings
        __props__.__dict__["tags"] = tags
        __props__.__dict__["visibility"] = visibility
        return Project(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Project to create
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        Key of the project. Maximum length 400. All letters, digits, dash, underscore, period or colon.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def settings(self) -> pulumi.Output[Optional[Sequence['outputs.ProjectSetting']]]:
        """
        A list of settings associated to the project
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of tags to put on the project.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def visibility(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Whether the created project should be visible to everyone, or only specific user/groups. If no visibility is specified, the default project visibility of the organization will be used. Valid values are `public` and `private`.
        """
        return pulumi.get(self, "visibility")

