# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 host: pulumi.Input[builtins.str],
                 anonymize_user_on_delete: Optional[pulumi.Input[builtins.bool]] = None,
                 http_proxy: Optional[pulumi.Input[builtins.str]] = None,
                 installed_edition: Optional[pulumi.Input[builtins.str]] = None,
                 installed_version: Optional[pulumi.Input[builtins.str]] = None,
                 pass_: Optional[pulumi.Input[builtins.str]] = None,
                 tls_insecure_skip_verify: Optional[pulumi.Input[builtins.bool]] = None,
                 token: Optional[pulumi.Input[builtins.str]] = None,
                 user: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[builtins.bool] anonymize_user_on_delete: Allows anonymizing users on destroy. Requires Sonarqube version >= 9.7.
        :param pulumi.Input[builtins.bool] tls_insecure_skip_verify: Allows ignoring insecure certificates when set to true. Defaults to false. Disabling TLS verification is dangerous and
               should only be done for local testing.
        """
        pulumi.set(__self__, "host", host)
        if anonymize_user_on_delete is not None:
            pulumi.set(__self__, "anonymize_user_on_delete", anonymize_user_on_delete)
        if http_proxy is not None:
            pulumi.set(__self__, "http_proxy", http_proxy)
        if installed_edition is not None:
            pulumi.set(__self__, "installed_edition", installed_edition)
        if installed_version is not None:
            pulumi.set(__self__, "installed_version", installed_version)
        if pass_ is not None:
            pulumi.set(__self__, "pass_", pass_)
        if tls_insecure_skip_verify is not None:
            pulumi.set(__self__, "tls_insecure_skip_verify", tls_insecure_skip_verify)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def host(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter(name="anonymizeUserOnDelete")
    def anonymize_user_on_delete(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Allows anonymizing users on destroy. Requires Sonarqube version >= 9.7.
        """
        return pulumi.get(self, "anonymize_user_on_delete")

    @anonymize_user_on_delete.setter
    def anonymize_user_on_delete(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "anonymize_user_on_delete", value)

    @property
    @pulumi.getter(name="httpProxy")
    def http_proxy(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "http_proxy")

    @http_proxy.setter
    def http_proxy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "http_proxy", value)

    @property
    @pulumi.getter(name="installedEdition")
    def installed_edition(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "installed_edition")

    @installed_edition.setter
    def installed_edition(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "installed_edition", value)

    @property
    @pulumi.getter(name="installedVersion")
    def installed_version(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "installed_version")

    @installed_version.setter
    def installed_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "installed_version", value)

    @property
    @pulumi.getter(name="pass")
    def pass_(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "pass_")

    @pass_.setter
    def pass_(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pass_", value)

    @property
    @pulumi.getter(name="tlsInsecureSkipVerify")
    def tls_insecure_skip_verify(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Allows ignoring insecure certificates when set to true. Defaults to false. Disabling TLS verification is dangerous and
        should only be done for local testing.
        """
        return pulumi.get(self, "tls_insecure_skip_verify")

    @tls_insecure_skip_verify.setter
    def tls_insecure_skip_verify(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "tls_insecure_skip_verify", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user", value)


class Provider(pulumi.ProviderResource):

    pulumi_type = "pulumi:providers:sonarqube"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 anonymize_user_on_delete: Optional[pulumi.Input[builtins.bool]] = None,
                 host: Optional[pulumi.Input[builtins.str]] = None,
                 http_proxy: Optional[pulumi.Input[builtins.str]] = None,
                 installed_edition: Optional[pulumi.Input[builtins.str]] = None,
                 installed_version: Optional[pulumi.Input[builtins.str]] = None,
                 pass_: Optional[pulumi.Input[builtins.str]] = None,
                 tls_insecure_skip_verify: Optional[pulumi.Input[builtins.bool]] = None,
                 token: Optional[pulumi.Input[builtins.str]] = None,
                 user: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        The provider type for the sonarqube package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] anonymize_user_on_delete: Allows anonymizing users on destroy. Requires Sonarqube version >= 9.7.
        :param pulumi.Input[builtins.bool] tls_insecure_skip_verify: Allows ignoring insecure certificates when set to true. Defaults to false. Disabling TLS verification is dangerous and
               should only be done for local testing.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProviderArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the sonarqube package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 anonymize_user_on_delete: Optional[pulumi.Input[builtins.bool]] = None,
                 host: Optional[pulumi.Input[builtins.str]] = None,
                 http_proxy: Optional[pulumi.Input[builtins.str]] = None,
                 installed_edition: Optional[pulumi.Input[builtins.str]] = None,
                 installed_version: Optional[pulumi.Input[builtins.str]] = None,
                 pass_: Optional[pulumi.Input[builtins.str]] = None,
                 tls_insecure_skip_verify: Optional[pulumi.Input[builtins.bool]] = None,
                 token: Optional[pulumi.Input[builtins.str]] = None,
                 user: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            __props__.__dict__["anonymize_user_on_delete"] = pulumi.Output.from_input(anonymize_user_on_delete).apply(pulumi.runtime.to_json) if anonymize_user_on_delete is not None else None
            if host is None and not opts.urn:
                raise TypeError("Missing required property 'host'")
            __props__.__dict__["host"] = host
            __props__.__dict__["http_proxy"] = http_proxy
            __props__.__dict__["installed_edition"] = installed_edition
            __props__.__dict__["installed_version"] = installed_version
            __props__.__dict__["pass_"] = None if pass_ is None else pulumi.Output.secret(pass_)
            __props__.__dict__["tls_insecure_skip_verify"] = pulumi.Output.from_input(tls_insecure_skip_verify).apply(pulumi.runtime.to_json) if tls_insecure_skip_verify is not None else None
            __props__.__dict__["token"] = None if token is None else pulumi.Output.secret(token)
            __props__.__dict__["user"] = user
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["pass", "token"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Provider, __self__).__init__(
            'sonarqube',
            resource_name,
            __props__,
            opts)

    @property
    @pulumi.getter
    def host(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="httpProxy")
    def http_proxy(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "http_proxy")

    @property
    @pulumi.getter(name="installedEdition")
    def installed_edition(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "installed_edition")

    @property
    @pulumi.getter(name="installedVersion")
    def installed_version(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "installed_version")

    @property
    @pulumi.getter(name="pass")
    def pass_(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "pass_")

    @property
    @pulumi.getter
    def token(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def user(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "user")

