# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['QualitygateArgs', 'Qualitygate']

@pulumi.input_type
class QualitygateArgs:
    def __init__(__self__, *,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['QualitygateConditionArgs']]]] = None,
                 copy_from: Optional[pulumi.Input[builtins.str]] = None,
                 is_default: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Qualitygate resource.
        :param pulumi.Input[Sequence[pulumi.Input['QualitygateConditionArgs']]] conditions: A list of conditions that the gate uses.
        :param pulumi.Input[builtins.str] copy_from: Name of an existing Quality Gate to copy from.
        :param pulumi.Input[builtins.bool] is_default: When set to true this Quality Gate is set as default.
        :param pulumi.Input[builtins.str] name: The name of the Quality Gate to create. Maximum length 100.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if copy_from is not None:
            pulumi.set(__self__, "copy_from", copy_from)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['QualitygateConditionArgs']]]]:
        """
        A list of conditions that the gate uses.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['QualitygateConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter(name="copyFrom")
    def copy_from(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of an existing Quality Gate to copy from.
        """
        return pulumi.get(self, "copy_from")

    @copy_from.setter
    def copy_from(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "copy_from", value)

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When set to true this Quality Gate is set as default.
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_default", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Quality Gate to create. Maximum length 100.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _QualitygateState:
    def __init__(__self__, *,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['QualitygateConditionArgs']]]] = None,
                 copy_from: Optional[pulumi.Input[builtins.str]] = None,
                 is_default: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Qualitygate resources.
        :param pulumi.Input[Sequence[pulumi.Input['QualitygateConditionArgs']]] conditions: A list of conditions that the gate uses.
        :param pulumi.Input[builtins.str] copy_from: Name of an existing Quality Gate to copy from.
        :param pulumi.Input[builtins.bool] is_default: When set to true this Quality Gate is set as default.
        :param pulumi.Input[builtins.str] name: The name of the Quality Gate to create. Maximum length 100.
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if copy_from is not None:
            pulumi.set(__self__, "copy_from", copy_from)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['QualitygateConditionArgs']]]]:
        """
        A list of conditions that the gate uses.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['QualitygateConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter(name="copyFrom")
    def copy_from(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of an existing Quality Gate to copy from.
        """
        return pulumi.get(self, "copy_from")

    @copy_from.setter
    def copy_from(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "copy_from", value)

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When set to true this Quality Gate is set as default.
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_default", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Quality Gate to create. Maximum length 100.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


class Qualitygate(pulumi.CustomResource):

    pulumi_type = "sonarqube:index/qualitygate:Qualitygate"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['QualitygateConditionArgs', 'QualitygateConditionArgsDict']]]]] = None,
                 copy_from: Optional[pulumi.Input[builtins.str]] = None,
                 is_default: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides a Sonarqube Quality Gate resource. This can be used to create and manage Sonarqube Quality Gates and their Conditions.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        main = sonarqube.Qualitygate("main",
            conditions=[
                {
                    "metric": "new_coverage",
                    "op": "LT",
                    "threshold": "50",
                },
                {
                    "metric": "vulnerabilities",
                    "op": "GT",
                    "threshold": "10",
                },
            ],
            is_default=True)
        ```

        **Disclaimer: Operator Requirement for Grade Rating Conditions**

        When working with grade rating conditions, (A-D), it is important to note that the "GT" (greater than) operator must be used for the `op` field. This is due to SonarQube's API design. More information can be found in this issue.

        For example, if you are using a grade rating metric such as `new_reliability_rating`, where A represents the highest rating and subsequent letters represent lower ratings, you need to supply the `op` field with "GT" via the provider. Using "LT" will return an error from SonarQube's API:

        ```python
        import pulumi
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['QualitygateConditionArgs', 'QualitygateConditionArgsDict']]]] conditions: A list of conditions that the gate uses.
        :param pulumi.Input[builtins.str] copy_from: Name of an existing Quality Gate to copy from.
        :param pulumi.Input[builtins.bool] is_default: When set to true this Quality Gate is set as default.
        :param pulumi.Input[builtins.str] name: The name of the Quality Gate to create. Maximum length 100.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[QualitygateArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Sonarqube Quality Gate resource. This can be used to create and manage Sonarqube Quality Gates and their Conditions.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        main = sonarqube.Qualitygate("main",
            conditions=[
                {
                    "metric": "new_coverage",
                    "op": "LT",
                    "threshold": "50",
                },
                {
                    "metric": "vulnerabilities",
                    "op": "GT",
                    "threshold": "10",
                },
            ],
            is_default=True)
        ```

        **Disclaimer: Operator Requirement for Grade Rating Conditions**

        When working with grade rating conditions, (A-D), it is important to note that the "GT" (greater than) operator must be used for the `op` field. This is due to SonarQube's API design. More information can be found in this issue.

        For example, if you are using a grade rating metric such as `new_reliability_rating`, where A represents the highest rating and subsequent letters represent lower ratings, you need to supply the `op` field with "GT" via the provider. Using "LT" will return an error from SonarQube's API:

        ```python
        import pulumi
        ```

        :param str resource_name: The name of the resource.
        :param QualitygateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(QualitygateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['QualitygateConditionArgs', 'QualitygateConditionArgsDict']]]]] = None,
                 copy_from: Optional[pulumi.Input[builtins.str]] = None,
                 is_default: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = QualitygateArgs.__new__(QualitygateArgs)

            __props__.__dict__["conditions"] = conditions
            __props__.__dict__["copy_from"] = copy_from
            __props__.__dict__["is_default"] = is_default
            __props__.__dict__["name"] = name
        super(Qualitygate, __self__).__init__(
            'sonarqube:index/qualitygate:Qualitygate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['QualitygateConditionArgs', 'QualitygateConditionArgsDict']]]]] = None,
            copy_from: Optional[pulumi.Input[builtins.str]] = None,
            is_default: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None) -> 'Qualitygate':
        """
        Get an existing Qualitygate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['QualitygateConditionArgs', 'QualitygateConditionArgsDict']]]] conditions: A list of conditions that the gate uses.
        :param pulumi.Input[builtins.str] copy_from: Name of an existing Quality Gate to copy from.
        :param pulumi.Input[builtins.bool] is_default: When set to true this Quality Gate is set as default.
        :param pulumi.Input[builtins.str] name: The name of the Quality Gate to create. Maximum length 100.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _QualitygateState.__new__(_QualitygateState)

        __props__.__dict__["conditions"] = conditions
        __props__.__dict__["copy_from"] = copy_from
        __props__.__dict__["is_default"] = is_default
        __props__.__dict__["name"] = name
        return Qualitygate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def conditions(self) -> pulumi.Output[Optional[Sequence['outputs.QualitygateCondition']]]:
        """
        A list of conditions that the gate uses.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="copyFrom")
    def copy_from(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Name of an existing Quality Gate to copy from.
        """
        return pulumi.get(self, "copy_from")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        When set to true this Quality Gate is set as default.
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Quality Gate to create. Maximum length 100.
        """
        return pulumi.get(self, "name")

