# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['QualitygateProjectAssociationArgs', 'QualitygateProjectAssociation']

@pulumi.input_type
class QualitygateProjectAssociationArgs:
    def __init__(__self__, *,
                 projectkey: pulumi.Input[builtins.str],
                 gateid: Optional[pulumi.Input[builtins.str]] = None,
                 gatename: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a QualitygateProjectAssociation resource.
        :param pulumi.Input[builtins.str] projectkey: Key of the project. Maximum length 400. All letters, digits, dash, underscore, period or colon.
        :param pulumi.Input[builtins.str] gatename: The name of the Quality Gate
        """
        pulumi.set(__self__, "projectkey", projectkey)
        if gateid is not None:
            pulumi.set(__self__, "gateid", gateid)
        if gatename is not None:
            pulumi.set(__self__, "gatename", gatename)

    @property
    @pulumi.getter
    def projectkey(self) -> pulumi.Input[builtins.str]:
        """
        Key of the project. Maximum length 400. All letters, digits, dash, underscore, period or colon.
        """
        return pulumi.get(self, "projectkey")

    @projectkey.setter
    def projectkey(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "projectkey", value)

    @property
    @pulumi.getter
    def gateid(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "gateid")

    @gateid.setter
    def gateid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "gateid", value)

    @property
    @pulumi.getter
    def gatename(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Quality Gate
        """
        return pulumi.get(self, "gatename")

    @gatename.setter
    def gatename(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "gatename", value)


@pulumi.input_type
class _QualitygateProjectAssociationState:
    def __init__(__self__, *,
                 gateid: Optional[pulumi.Input[builtins.str]] = None,
                 gatename: Optional[pulumi.Input[builtins.str]] = None,
                 projectkey: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering QualitygateProjectAssociation resources.
        :param pulumi.Input[builtins.str] gatename: The name of the Quality Gate
        :param pulumi.Input[builtins.str] projectkey: Key of the project. Maximum length 400. All letters, digits, dash, underscore, period or colon.
        """
        if gateid is not None:
            pulumi.set(__self__, "gateid", gateid)
        if gatename is not None:
            pulumi.set(__self__, "gatename", gatename)
        if projectkey is not None:
            pulumi.set(__self__, "projectkey", projectkey)

    @property
    @pulumi.getter
    def gateid(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "gateid")

    @gateid.setter
    def gateid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "gateid", value)

    @property
    @pulumi.getter
    def gatename(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Quality Gate
        """
        return pulumi.get(self, "gatename")

    @gatename.setter
    def gatename(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "gatename", value)

    @property
    @pulumi.getter
    def projectkey(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Key of the project. Maximum length 400. All letters, digits, dash, underscore, period or colon.
        """
        return pulumi.get(self, "projectkey")

    @projectkey.setter
    def projectkey(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "projectkey", value)


class QualitygateProjectAssociation(pulumi.CustomResource):

    pulumi_type = "sonarqube:index/qualitygateProjectAssociation:QualitygateProjectAssociation"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 gateid: Optional[pulumi.Input[builtins.str]] = None,
                 gatename: Optional[pulumi.Input[builtins.str]] = None,
                 projectkey: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides a Sonarqube Quality Gate Project association resource. This can be used to associate a Quality Gate to a Project

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        ## Example: create a quality gate project association
        main_qualitygate = sonarqube.Qualitygate("mainQualitygate", conditions=[{
            "metric": "new_coverage",
            "op": "LT",
            "threshold": "30",
        }])
        main_project = sonarqube.Project("mainProject",
            project="my_project",
            visibility="public")
        main_qualitygate_project_association = sonarqube.QualitygateProjectAssociation("mainQualitygateProjectAssociation",
            gatename=main_qualitygate.id,
            projectkey=main_project.project)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] gatename: The name of the Quality Gate
        :param pulumi.Input[builtins.str] projectkey: Key of the project. Maximum length 400. All letters, digits, dash, underscore, period or colon.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: QualitygateProjectAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Sonarqube Quality Gate Project association resource. This can be used to associate a Quality Gate to a Project

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        ## Example: create a quality gate project association
        main_qualitygate = sonarqube.Qualitygate("mainQualitygate", conditions=[{
            "metric": "new_coverage",
            "op": "LT",
            "threshold": "30",
        }])
        main_project = sonarqube.Project("mainProject",
            project="my_project",
            visibility="public")
        main_qualitygate_project_association = sonarqube.QualitygateProjectAssociation("mainQualitygateProjectAssociation",
            gatename=main_qualitygate.id,
            projectkey=main_project.project)
        ```

        :param str resource_name: The name of the resource.
        :param QualitygateProjectAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(QualitygateProjectAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 gateid: Optional[pulumi.Input[builtins.str]] = None,
                 gatename: Optional[pulumi.Input[builtins.str]] = None,
                 projectkey: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = QualitygateProjectAssociationArgs.__new__(QualitygateProjectAssociationArgs)

            __props__.__dict__["gateid"] = gateid
            __props__.__dict__["gatename"] = gatename
            if projectkey is None and not opts.urn:
                raise TypeError("Missing required property 'projectkey'")
            __props__.__dict__["projectkey"] = projectkey
        super(QualitygateProjectAssociation, __self__).__init__(
            'sonarqube:index/qualitygateProjectAssociation:QualitygateProjectAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            gateid: Optional[pulumi.Input[builtins.str]] = None,
            gatename: Optional[pulumi.Input[builtins.str]] = None,
            projectkey: Optional[pulumi.Input[builtins.str]] = None) -> 'QualitygateProjectAssociation':
        """
        Get an existing QualitygateProjectAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] gatename: The name of the Quality Gate
        :param pulumi.Input[builtins.str] projectkey: Key of the project. Maximum length 400. All letters, digits, dash, underscore, period or colon.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _QualitygateProjectAssociationState.__new__(_QualitygateProjectAssociationState)

        __props__.__dict__["gateid"] = gateid
        __props__.__dict__["gatename"] = gatename
        __props__.__dict__["projectkey"] = projectkey
        return QualitygateProjectAssociation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def gateid(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "gateid")

    @property
    @pulumi.getter
    def gatename(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the Quality Gate
        """
        return pulumi.get(self, "gatename")

    @property
    @pulumi.getter
    def projectkey(self) -> pulumi.Output[builtins.str]:
        """
        Key of the project. Maximum length 400. All letters, digits, dash, underscore, period or colon.
        """
        return pulumi.get(self, "projectkey")

