# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['QualitygateUsergroupAssociationArgs', 'QualitygateUsergroupAssociation']

@pulumi.input_type
class QualitygateUsergroupAssociationArgs:
    def __init__(__self__, *,
                 gatename: pulumi.Input[builtins.str],
                 group_name: Optional[pulumi.Input[builtins.str]] = None,
                 login_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a QualitygateUsergroupAssociation resource.
        :param pulumi.Input[builtins.str] gatename: The name of the Quality Gate
        :param pulumi.Input[builtins.str] group_name: The name of the Group to associate. Either `group_name` or `login_name` should be provided.
        :param pulumi.Input[builtins.str] login_name: The name of the User to associate. Either `group_name` or `login_name` should be provided.
        """
        pulumi.set(__self__, "gatename", gatename)
        if group_name is not None:
            pulumi.set(__self__, "group_name", group_name)
        if login_name is not None:
            pulumi.set(__self__, "login_name", login_name)

    @property
    @pulumi.getter
    def gatename(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Quality Gate
        """
        return pulumi.get(self, "gatename")

    @gatename.setter
    def gatename(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "gatename", value)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Group to associate. Either `group_name` or `login_name` should be provided.
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "group_name", value)

    @property
    @pulumi.getter(name="loginName")
    def login_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the User to associate. Either `group_name` or `login_name` should be provided.
        """
        return pulumi.get(self, "login_name")

    @login_name.setter
    def login_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "login_name", value)


@pulumi.input_type
class _QualitygateUsergroupAssociationState:
    def __init__(__self__, *,
                 gatename: Optional[pulumi.Input[builtins.str]] = None,
                 group_name: Optional[pulumi.Input[builtins.str]] = None,
                 login_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering QualitygateUsergroupAssociation resources.
        :param pulumi.Input[builtins.str] gatename: The name of the Quality Gate
        :param pulumi.Input[builtins.str] group_name: The name of the Group to associate. Either `group_name` or `login_name` should be provided.
        :param pulumi.Input[builtins.str] login_name: The name of the User to associate. Either `group_name` or `login_name` should be provided.
        """
        if gatename is not None:
            pulumi.set(__self__, "gatename", gatename)
        if group_name is not None:
            pulumi.set(__self__, "group_name", group_name)
        if login_name is not None:
            pulumi.set(__self__, "login_name", login_name)

    @property
    @pulumi.getter
    def gatename(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Quality Gate
        """
        return pulumi.get(self, "gatename")

    @gatename.setter
    def gatename(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "gatename", value)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Group to associate. Either `group_name` or `login_name` should be provided.
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "group_name", value)

    @property
    @pulumi.getter(name="loginName")
    def login_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the User to associate. Either `group_name` or `login_name` should be provided.
        """
        return pulumi.get(self, "login_name")

    @login_name.setter
    def login_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "login_name", value)


class QualitygateUsergroupAssociation(pulumi.CustomResource):

    pulumi_type = "sonarqube:index/qualitygateUsergroupAssociation:QualitygateUsergroupAssociation"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 gatename: Optional[pulumi.Input[builtins.str]] = None,
                 group_name: Optional[pulumi.Input[builtins.str]] = None,
                 login_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides a Sonarqube Quality Gate Usergroup association resource. This can be used to associate a Quality Gate to an User or to a Group.
        The feature is available on SonarQube 9.2 or newer.

        ## Example Usage

        ### Example: create a quality gate user association
        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        main_qualitygate = sonarqube.Qualitygate("mainQualitygate", conditions=[{
            "metric": "new_coverage",
            "op": "LT",
            "threshold": "30",
        }])
        qa_user = sonarqube.User("qaUser",
            login_name="qa-user",
            password="secret-sauce37!")
        main_qualitygate_usergroup_association = sonarqube.QualitygateUsergroupAssociation("mainQualitygateUsergroupAssociation",
            gatename=main_qualitygate.id,
            login_name=qa_user.id)
        ```

        ### Example: create a quality gate group association
        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        main_qualitygate = sonarqube.Qualitygate("mainQualitygate", conditions=[{
            "metric": "new_coverage",
            "op": "LT",
            "threshold": "30",
        }])
        qa_team = sonarqube.Group("qaTeam", description="Quality Assurence Team")
        main_qualitygate_usergroup_association = sonarqube.QualitygateUsergroupAssociation("mainQualitygateUsergroupAssociation",
            gatename=main_qualitygate.id,
            group_name=qa_team.name)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] gatename: The name of the Quality Gate
        :param pulumi.Input[builtins.str] group_name: The name of the Group to associate. Either `group_name` or `login_name` should be provided.
        :param pulumi.Input[builtins.str] login_name: The name of the User to associate. Either `group_name` or `login_name` should be provided.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: QualitygateUsergroupAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Sonarqube Quality Gate Usergroup association resource. This can be used to associate a Quality Gate to an User or to a Group.
        The feature is available on SonarQube 9.2 or newer.

        ## Example Usage

        ### Example: create a quality gate user association
        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        main_qualitygate = sonarqube.Qualitygate("mainQualitygate", conditions=[{
            "metric": "new_coverage",
            "op": "LT",
            "threshold": "30",
        }])
        qa_user = sonarqube.User("qaUser",
            login_name="qa-user",
            password="secret-sauce37!")
        main_qualitygate_usergroup_association = sonarqube.QualitygateUsergroupAssociation("mainQualitygateUsergroupAssociation",
            gatename=main_qualitygate.id,
            login_name=qa_user.id)
        ```

        ### Example: create a quality gate group association
        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        main_qualitygate = sonarqube.Qualitygate("mainQualitygate", conditions=[{
            "metric": "new_coverage",
            "op": "LT",
            "threshold": "30",
        }])
        qa_team = sonarqube.Group("qaTeam", description="Quality Assurence Team")
        main_qualitygate_usergroup_association = sonarqube.QualitygateUsergroupAssociation("mainQualitygateUsergroupAssociation",
            gatename=main_qualitygate.id,
            group_name=qa_team.name)
        ```

        :param str resource_name: The name of the resource.
        :param QualitygateUsergroupAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(QualitygateUsergroupAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 gatename: Optional[pulumi.Input[builtins.str]] = None,
                 group_name: Optional[pulumi.Input[builtins.str]] = None,
                 login_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = QualitygateUsergroupAssociationArgs.__new__(QualitygateUsergroupAssociationArgs)

            if gatename is None and not opts.urn:
                raise TypeError("Missing required property 'gatename'")
            __props__.__dict__["gatename"] = gatename
            __props__.__dict__["group_name"] = group_name
            __props__.__dict__["login_name"] = login_name
        super(QualitygateUsergroupAssociation, __self__).__init__(
            'sonarqube:index/qualitygateUsergroupAssociation:QualitygateUsergroupAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            gatename: Optional[pulumi.Input[builtins.str]] = None,
            group_name: Optional[pulumi.Input[builtins.str]] = None,
            login_name: Optional[pulumi.Input[builtins.str]] = None) -> 'QualitygateUsergroupAssociation':
        """
        Get an existing QualitygateUsergroupAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] gatename: The name of the Quality Gate
        :param pulumi.Input[builtins.str] group_name: The name of the Group to associate. Either `group_name` or `login_name` should be provided.
        :param pulumi.Input[builtins.str] login_name: The name of the User to associate. Either `group_name` or `login_name` should be provided.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _QualitygateUsergroupAssociationState.__new__(_QualitygateUsergroupAssociationState)

        __props__.__dict__["gatename"] = gatename
        __props__.__dict__["group_name"] = group_name
        __props__.__dict__["login_name"] = login_name
        return QualitygateUsergroupAssociation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def gatename(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Quality Gate
        """
        return pulumi.get(self, "gatename")

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the Group to associate. Either `group_name` or `login_name` should be provided.
        """
        return pulumi.get(self, "group_name")

    @property
    @pulumi.getter(name="loginName")
    def login_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the User to associate. Either `group_name` or `login_name` should be provided.
        """
        return pulumi.get(self, "login_name")

