# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['QualityprofileArgs', 'Qualityprofile']

@pulumi.input_type
class QualityprofileArgs:
    def __init__(__self__, *,
                 language: pulumi.Input[builtins.str],
                 is_default: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Qualityprofile resource.
        :param pulumi.Input[builtins.str] language: Quality profile language. Must be one of "cs", "css", "flex", "go", "java", "js", "jsp", "kotlin", "php", "py", "ruby", "scala", "ts", "vbnet", "web", "xml"
        :param pulumi.Input[builtins.bool] is_default: When set to true this will make the added Quality Profile default
        :param pulumi.Input[builtins.str] name: The name of the Quality Profile to create. Maximum length 100
        :param pulumi.Input[builtins.str] parent: When a parent is provided the quality profile will inherit it's rules
        """
        pulumi.set(__self__, "language", language)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)

    @property
    @pulumi.getter
    def language(self) -> pulumi.Input[builtins.str]:
        """
        Quality profile language. Must be one of "cs", "css", "flex", "go", "java", "js", "jsp", "kotlin", "php", "py", "ruby", "scala", "ts", "vbnet", "web", "xml"
        """
        return pulumi.get(self, "language")

    @language.setter
    def language(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "language", value)

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When set to true this will make the added Quality Profile default
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_default", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Quality Profile to create. Maximum length 100
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        When a parent is provided the quality profile will inherit it's rules
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parent", value)


@pulumi.input_type
class _QualityprofileState:
    def __init__(__self__, *,
                 is_default: Optional[pulumi.Input[builtins.bool]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 language: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Qualityprofile resources.
        :param pulumi.Input[builtins.bool] is_default: When set to true this will make the added Quality Profile default
        :param pulumi.Input[builtins.str] key: ID of the Sonarqube Quality Profile
        :param pulumi.Input[builtins.str] language: Quality profile language. Must be one of "cs", "css", "flex", "go", "java", "js", "jsp", "kotlin", "php", "py", "ruby", "scala", "ts", "vbnet", "web", "xml"
        :param pulumi.Input[builtins.str] name: The name of the Quality Profile to create. Maximum length 100
        :param pulumi.Input[builtins.str] parent: When a parent is provided the quality profile will inherit it's rules
        """
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if language is not None:
            pulumi.set(__self__, "language", language)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When set to true this will make the added Quality Profile default
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_default", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the Sonarqube Quality Profile
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def language(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Quality profile language. Must be one of "cs", "css", "flex", "go", "java", "js", "jsp", "kotlin", "php", "py", "ruby", "scala", "ts", "vbnet", "web", "xml"
        """
        return pulumi.get(self, "language")

    @language.setter
    def language(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "language", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Quality Profile to create. Maximum length 100
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        When a parent is provided the quality profile will inherit it's rules
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parent", value)


class Qualityprofile(pulumi.CustomResource):

    pulumi_type = "sonarqube:index/qualityprofile:Qualityprofile"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 is_default: Optional[pulumi.Input[builtins.bool]] = None,
                 language: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides a Sonarqube Quality Profile resource. This can be used to create and manage Sonarqube Quality Profiles.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        main = sonarqube.Qualityprofile("main",
            is_default=False,
            language="js",
            parent="sonar way")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] is_default: When set to true this will make the added Quality Profile default
        :param pulumi.Input[builtins.str] language: Quality profile language. Must be one of "cs", "css", "flex", "go", "java", "js", "jsp", "kotlin", "php", "py", "ruby", "scala", "ts", "vbnet", "web", "xml"
        :param pulumi.Input[builtins.str] name: The name of the Quality Profile to create. Maximum length 100
        :param pulumi.Input[builtins.str] parent: When a parent is provided the quality profile will inherit it's rules
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: QualityprofileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Sonarqube Quality Profile resource. This can be used to create and manage Sonarqube Quality Profiles.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        main = sonarqube.Qualityprofile("main",
            is_default=False,
            language="js",
            parent="sonar way")
        ```

        :param str resource_name: The name of the resource.
        :param QualityprofileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(QualityprofileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 is_default: Optional[pulumi.Input[builtins.bool]] = None,
                 language: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = QualityprofileArgs.__new__(QualityprofileArgs)

            __props__.__dict__["is_default"] = is_default
            if language is None and not opts.urn:
                raise TypeError("Missing required property 'language'")
            __props__.__dict__["language"] = language
            __props__.__dict__["name"] = name
            __props__.__dict__["parent"] = parent
            __props__.__dict__["key"] = None
        super(Qualityprofile, __self__).__init__(
            'sonarqube:index/qualityprofile:Qualityprofile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            is_default: Optional[pulumi.Input[builtins.bool]] = None,
            key: Optional[pulumi.Input[builtins.str]] = None,
            language: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            parent: Optional[pulumi.Input[builtins.str]] = None) -> 'Qualityprofile':
        """
        Get an existing Qualityprofile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] is_default: When set to true this will make the added Quality Profile default
        :param pulumi.Input[builtins.str] key: ID of the Sonarqube Quality Profile
        :param pulumi.Input[builtins.str] language: Quality profile language. Must be one of "cs", "css", "flex", "go", "java", "js", "jsp", "kotlin", "php", "py", "ruby", "scala", "ts", "vbnet", "web", "xml"
        :param pulumi.Input[builtins.str] name: The name of the Quality Profile to create. Maximum length 100
        :param pulumi.Input[builtins.str] parent: When a parent is provided the quality profile will inherit it's rules
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _QualityprofileState.__new__(_QualityprofileState)

        __props__.__dict__["is_default"] = is_default
        __props__.__dict__["key"] = key
        __props__.__dict__["language"] = language
        __props__.__dict__["name"] = name
        __props__.__dict__["parent"] = parent
        return Qualityprofile(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        When set to true this will make the added Quality Profile default
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[builtins.str]:
        """
        ID of the Sonarqube Quality Profile
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def language(self) -> pulumi.Output[builtins.str]:
        """
        Quality profile language. Must be one of "cs", "css", "flex", "go", "java", "js", "jsp", "kotlin", "php", "py", "ruby", "scala", "ts", "vbnet", "web", "xml"
        """
        return pulumi.get(self, "language")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Quality Profile to create. Maximum length 100
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parent(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        When a parent is provided the quality profile will inherit it's rules
        """
        return pulumi.get(self, "parent")

