# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['QualityprofileProjectAssociationArgs', 'QualityprofileProjectAssociation']

@pulumi.input_type
class QualityprofileProjectAssociationArgs:
    def __init__(__self__, *,
                 language: pulumi.Input[builtins.str],
                 project: pulumi.Input[builtins.str],
                 quality_profile: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a QualityprofileProjectAssociation resource.
        :param pulumi.Input[builtins.str] language: Quality profile language. Must be a langauge in this list https://next.sonarqube.com/sonarqube/web_api/api/languages/list
        :param pulumi.Input[builtins.str] project: Name of the project
        :param pulumi.Input[builtins.str] quality_profile: Name of the Quality Profile
        """
        pulumi.set(__self__, "language", language)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "quality_profile", quality_profile)

    @property
    @pulumi.getter
    def language(self) -> pulumi.Input[builtins.str]:
        """
        Quality profile language. Must be a langauge in this list https://next.sonarqube.com/sonarqube/web_api/api/languages/list
        """
        return pulumi.get(self, "language")

    @language.setter
    def language(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "language", value)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[builtins.str]:
        """
        Name of the project
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="qualityProfile")
    def quality_profile(self) -> pulumi.Input[builtins.str]:
        """
        Name of the Quality Profile
        """
        return pulumi.get(self, "quality_profile")

    @quality_profile.setter
    def quality_profile(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "quality_profile", value)


@pulumi.input_type
class _QualityprofileProjectAssociationState:
    def __init__(__self__, *,
                 language: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 quality_profile: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering QualityprofileProjectAssociation resources.
        :param pulumi.Input[builtins.str] language: Quality profile language. Must be a langauge in this list https://next.sonarqube.com/sonarqube/web_api/api/languages/list
        :param pulumi.Input[builtins.str] project: Name of the project
        :param pulumi.Input[builtins.str] quality_profile: Name of the Quality Profile
        """
        if language is not None:
            pulumi.set(__self__, "language", language)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if quality_profile is not None:
            pulumi.set(__self__, "quality_profile", quality_profile)

    @property
    @pulumi.getter
    def language(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Quality profile language. Must be a langauge in this list https://next.sonarqube.com/sonarqube/web_api/api/languages/list
        """
        return pulumi.get(self, "language")

    @language.setter
    def language(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "language", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the project
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="qualityProfile")
    def quality_profile(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the Quality Profile
        """
        return pulumi.get(self, "quality_profile")

    @quality_profile.setter
    def quality_profile(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "quality_profile", value)


class QualityprofileProjectAssociation(pulumi.CustomResource):

    pulumi_type = "sonarqube:index/qualityprofileProjectAssociation:QualityprofileProjectAssociation"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 language: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 quality_profile: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides a Sonarqube Quality Profile Project association resource. This can be used to associate a Quality Profile to a Project

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        main_qualityprofile = sonarqube.Qualityprofile("mainQualityprofile", language="js")
        main_project = sonarqube.Project("mainProject",
            project="my_project",
            visibility="public")
        main_qualityprofile_project_association = sonarqube.QualityprofileProjectAssociation("mainQualityprofileProjectAssociation",
            quality_profile=main_qualityprofile.name,
            project=main_project.project,
            language="js")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] language: Quality profile language. Must be a langauge in this list https://next.sonarqube.com/sonarqube/web_api/api/languages/list
        :param pulumi.Input[builtins.str] project: Name of the project
        :param pulumi.Input[builtins.str] quality_profile: Name of the Quality Profile
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: QualityprofileProjectAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Sonarqube Quality Profile Project association resource. This can be used to associate a Quality Profile to a Project

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        main_qualityprofile = sonarqube.Qualityprofile("mainQualityprofile", language="js")
        main_project = sonarqube.Project("mainProject",
            project="my_project",
            visibility="public")
        main_qualityprofile_project_association = sonarqube.QualityprofileProjectAssociation("mainQualityprofileProjectAssociation",
            quality_profile=main_qualityprofile.name,
            project=main_project.project,
            language="js")
        ```

        :param str resource_name: The name of the resource.
        :param QualityprofileProjectAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(QualityprofileProjectAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 language: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 quality_profile: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = QualityprofileProjectAssociationArgs.__new__(QualityprofileProjectAssociationArgs)

            if language is None and not opts.urn:
                raise TypeError("Missing required property 'language'")
            __props__.__dict__["language"] = language
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            if quality_profile is None and not opts.urn:
                raise TypeError("Missing required property 'quality_profile'")
            __props__.__dict__["quality_profile"] = quality_profile
        super(QualityprofileProjectAssociation, __self__).__init__(
            'sonarqube:index/qualityprofileProjectAssociation:QualityprofileProjectAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            language: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            quality_profile: Optional[pulumi.Input[builtins.str]] = None) -> 'QualityprofileProjectAssociation':
        """
        Get an existing QualityprofileProjectAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] language: Quality profile language. Must be a langauge in this list https://next.sonarqube.com/sonarqube/web_api/api/languages/list
        :param pulumi.Input[builtins.str] project: Name of the project
        :param pulumi.Input[builtins.str] quality_profile: Name of the Quality Profile
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _QualityprofileProjectAssociationState.__new__(_QualityprofileProjectAssociationState)

        __props__.__dict__["language"] = language
        __props__.__dict__["project"] = project
        __props__.__dict__["quality_profile"] = quality_profile
        return QualityprofileProjectAssociation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def language(self) -> pulumi.Output[builtins.str]:
        """
        Quality profile language. Must be a langauge in this list https://next.sonarqube.com/sonarqube/web_api/api/languages/list
        """
        return pulumi.get(self, "language")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        Name of the project
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="qualityProfile")
    def quality_profile(self) -> pulumi.Output[builtins.str]:
        """
        Name of the Quality Profile
        """
        return pulumi.get(self, "quality_profile")

