# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['RuleArgs', 'Rule']

@pulumi.input_type
class RuleArgs:
    def __init__(__self__, *,
                 custom_key: pulumi.Input[builtins.str],
                 markdown_description: pulumi.Input[builtins.str],
                 template_key: pulumi.Input[builtins.str],
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 params: Optional[pulumi.Input[builtins.str]] = None,
                 prevent_reactivation: Optional[pulumi.Input[builtins.str]] = None,
                 severity: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Rule resource.
        :param pulumi.Input[builtins.str] custom_key: key of the custom rule should only contain : a-z, 0-9, \\_
        :param pulumi.Input[builtins.str] markdown_description: Rule description
        :param pulumi.Input[builtins.str] template_key: Key of the template rule in order to create a custom rule (mandatory for custom rule) - [Example
               values](https://docs.sonarqube.org/latest/user-guide/rules/#header-4)
        :param pulumi.Input[builtins.str] name: Rule name
        :param pulumi.Input[builtins.str] params: Parameters as semi-colon list of =, for example 'params=key1=v1;key2=v2' (Only for custom rule) - parameter order:
               expression=value;filePattern=value;message=value
        :param pulumi.Input[builtins.str] prevent_reactivation: If set to true and if the rule has been deactivated (status 'REMOVED'), a status 409 will be returned - Possible values
               - true, false, yes, no
        :param pulumi.Input[builtins.str] severity: Rule severity - Possible values - INFO, MINOR, MAJOR, CRITICAL, BLOCKER
        :param pulumi.Input[builtins.str] status: Rule status - Possible values - BETA, DEPRECATED, READY, REMOVED - Default value - READY
        :param pulumi.Input[builtins.str] type: Rule type - Possible values - CODE_SMELL, BUG, VULNERABILITY, SECURITY_HOTSPOT
        """
        pulumi.set(__self__, "custom_key", custom_key)
        pulumi.set(__self__, "markdown_description", markdown_description)
        pulumi.set(__self__, "template_key", template_key)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if params is not None:
            pulumi.set(__self__, "params", params)
        if prevent_reactivation is not None:
            pulumi.set(__self__, "prevent_reactivation", prevent_reactivation)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="customKey")
    def custom_key(self) -> pulumi.Input[builtins.str]:
        """
        key of the custom rule should only contain : a-z, 0-9, \\_
        """
        return pulumi.get(self, "custom_key")

    @custom_key.setter
    def custom_key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "custom_key", value)

    @property
    @pulumi.getter(name="markdownDescription")
    def markdown_description(self) -> pulumi.Input[builtins.str]:
        """
        Rule description
        """
        return pulumi.get(self, "markdown_description")

    @markdown_description.setter
    def markdown_description(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "markdown_description", value)

    @property
    @pulumi.getter(name="templateKey")
    def template_key(self) -> pulumi.Input[builtins.str]:
        """
        Key of the template rule in order to create a custom rule (mandatory for custom rule) - [Example
        values](https://docs.sonarqube.org/latest/user-guide/rules/#header-4)
        """
        return pulumi.get(self, "template_key")

    @template_key.setter
    def template_key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "template_key", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Rule name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def params(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Parameters as semi-colon list of =, for example 'params=key1=v1;key2=v2' (Only for custom rule) - parameter order:
        expression=value;filePattern=value;message=value
        """
        return pulumi.get(self, "params")

    @params.setter
    def params(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "params", value)

    @property
    @pulumi.getter(name="preventReactivation")
    def prevent_reactivation(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If set to true and if the rule has been deactivated (status 'REMOVED'), a status 409 will be returned - Possible values
        - true, false, yes, no
        """
        return pulumi.get(self, "prevent_reactivation")

    @prevent_reactivation.setter
    def prevent_reactivation(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "prevent_reactivation", value)

    @property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Rule severity - Possible values - INFO, MINOR, MAJOR, CRITICAL, BLOCKER
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "severity", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Rule status - Possible values - BETA, DEPRECATED, READY, REMOVED - Default value - READY
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Rule type - Possible values - CODE_SMELL, BUG, VULNERABILITY, SECURITY_HOTSPOT
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _RuleState:
    def __init__(__self__, *,
                 custom_key: Optional[pulumi.Input[builtins.str]] = None,
                 markdown_description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 params: Optional[pulumi.Input[builtins.str]] = None,
                 prevent_reactivation: Optional[pulumi.Input[builtins.str]] = None,
                 severity: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 template_key: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Rule resources.
        :param pulumi.Input[builtins.str] custom_key: key of the custom rule should only contain : a-z, 0-9, \\_
        :param pulumi.Input[builtins.str] markdown_description: Rule description
        :param pulumi.Input[builtins.str] name: Rule name
        :param pulumi.Input[builtins.str] params: Parameters as semi-colon list of =, for example 'params=key1=v1;key2=v2' (Only for custom rule) - parameter order:
               expression=value;filePattern=value;message=value
        :param pulumi.Input[builtins.str] prevent_reactivation: If set to true and if the rule has been deactivated (status 'REMOVED'), a status 409 will be returned - Possible values
               - true, false, yes, no
        :param pulumi.Input[builtins.str] severity: Rule severity - Possible values - INFO, MINOR, MAJOR, CRITICAL, BLOCKER
        :param pulumi.Input[builtins.str] status: Rule status - Possible values - BETA, DEPRECATED, READY, REMOVED - Default value - READY
        :param pulumi.Input[builtins.str] template_key: Key of the template rule in order to create a custom rule (mandatory for custom rule) - [Example
               values](https://docs.sonarqube.org/latest/user-guide/rules/#header-4)
        :param pulumi.Input[builtins.str] type: Rule type - Possible values - CODE_SMELL, BUG, VULNERABILITY, SECURITY_HOTSPOT
        """
        if custom_key is not None:
            pulumi.set(__self__, "custom_key", custom_key)
        if markdown_description is not None:
            pulumi.set(__self__, "markdown_description", markdown_description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if params is not None:
            pulumi.set(__self__, "params", params)
        if prevent_reactivation is not None:
            pulumi.set(__self__, "prevent_reactivation", prevent_reactivation)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if template_key is not None:
            pulumi.set(__self__, "template_key", template_key)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="customKey")
    def custom_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        key of the custom rule should only contain : a-z, 0-9, \\_
        """
        return pulumi.get(self, "custom_key")

    @custom_key.setter
    def custom_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "custom_key", value)

    @property
    @pulumi.getter(name="markdownDescription")
    def markdown_description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Rule description
        """
        return pulumi.get(self, "markdown_description")

    @markdown_description.setter
    def markdown_description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "markdown_description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Rule name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def params(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Parameters as semi-colon list of =, for example 'params=key1=v1;key2=v2' (Only for custom rule) - parameter order:
        expression=value;filePattern=value;message=value
        """
        return pulumi.get(self, "params")

    @params.setter
    def params(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "params", value)

    @property
    @pulumi.getter(name="preventReactivation")
    def prevent_reactivation(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If set to true and if the rule has been deactivated (status 'REMOVED'), a status 409 will be returned - Possible values
        - true, false, yes, no
        """
        return pulumi.get(self, "prevent_reactivation")

    @prevent_reactivation.setter
    def prevent_reactivation(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "prevent_reactivation", value)

    @property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Rule severity - Possible values - INFO, MINOR, MAJOR, CRITICAL, BLOCKER
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "severity", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Rule status - Possible values - BETA, DEPRECATED, READY, REMOVED - Default value - READY
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="templateKey")
    def template_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Key of the template rule in order to create a custom rule (mandatory for custom rule) - [Example
        values](https://docs.sonarqube.org/latest/user-guide/rules/#header-4)
        """
        return pulumi.get(self, "template_key")

    @template_key.setter
    def template_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "template_key", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Rule type - Possible values - CODE_SMELL, BUG, VULNERABILITY, SECURITY_HOTSPOT
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


class Rule(pulumi.CustomResource):

    pulumi_type = "sonarqube:index/rule:Rule"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_key: Optional[pulumi.Input[builtins.str]] = None,
                 markdown_description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 params: Optional[pulumi.Input[builtins.str]] = None,
                 prevent_reactivation: Optional[pulumi.Input[builtins.str]] = None,
                 severity: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 template_key: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides a Sonarqube Rules resource. This can be used to manage Sonarqube rules.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] custom_key: key of the custom rule should only contain : a-z, 0-9, \\_
        :param pulumi.Input[builtins.str] markdown_description: Rule description
        :param pulumi.Input[builtins.str] name: Rule name
        :param pulumi.Input[builtins.str] params: Parameters as semi-colon list of =, for example 'params=key1=v1;key2=v2' (Only for custom rule) - parameter order:
               expression=value;filePattern=value;message=value
        :param pulumi.Input[builtins.str] prevent_reactivation: If set to true and if the rule has been deactivated (status 'REMOVED'), a status 409 will be returned - Possible values
               - true, false, yes, no
        :param pulumi.Input[builtins.str] severity: Rule severity - Possible values - INFO, MINOR, MAJOR, CRITICAL, BLOCKER
        :param pulumi.Input[builtins.str] status: Rule status - Possible values - BETA, DEPRECATED, READY, REMOVED - Default value - READY
        :param pulumi.Input[builtins.str] template_key: Key of the template rule in order to create a custom rule (mandatory for custom rule) - [Example
               values](https://docs.sonarqube.org/latest/user-guide/rules/#header-4)
        :param pulumi.Input[builtins.str] type: Rule type - Possible values - CODE_SMELL, BUG, VULNERABILITY, SECURITY_HOTSPOT
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Sonarqube Rules resource. This can be used to manage Sonarqube rules.

        :param str resource_name: The name of the resource.
        :param RuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_key: Optional[pulumi.Input[builtins.str]] = None,
                 markdown_description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 params: Optional[pulumi.Input[builtins.str]] = None,
                 prevent_reactivation: Optional[pulumi.Input[builtins.str]] = None,
                 severity: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 template_key: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RuleArgs.__new__(RuleArgs)

            if custom_key is None and not opts.urn:
                raise TypeError("Missing required property 'custom_key'")
            __props__.__dict__["custom_key"] = custom_key
            if markdown_description is None and not opts.urn:
                raise TypeError("Missing required property 'markdown_description'")
            __props__.__dict__["markdown_description"] = markdown_description
            __props__.__dict__["name"] = name
            __props__.__dict__["params"] = params
            __props__.__dict__["prevent_reactivation"] = prevent_reactivation
            __props__.__dict__["severity"] = severity
            __props__.__dict__["status"] = status
            if template_key is None and not opts.urn:
                raise TypeError("Missing required property 'template_key'")
            __props__.__dict__["template_key"] = template_key
            __props__.__dict__["type"] = type
        super(Rule, __self__).__init__(
            'sonarqube:index/rule:Rule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            custom_key: Optional[pulumi.Input[builtins.str]] = None,
            markdown_description: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            params: Optional[pulumi.Input[builtins.str]] = None,
            prevent_reactivation: Optional[pulumi.Input[builtins.str]] = None,
            severity: Optional[pulumi.Input[builtins.str]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            template_key: Optional[pulumi.Input[builtins.str]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None) -> 'Rule':
        """
        Get an existing Rule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] custom_key: key of the custom rule should only contain : a-z, 0-9, \\_
        :param pulumi.Input[builtins.str] markdown_description: Rule description
        :param pulumi.Input[builtins.str] name: Rule name
        :param pulumi.Input[builtins.str] params: Parameters as semi-colon list of =, for example 'params=key1=v1;key2=v2' (Only for custom rule) - parameter order:
               expression=value;filePattern=value;message=value
        :param pulumi.Input[builtins.str] prevent_reactivation: If set to true and if the rule has been deactivated (status 'REMOVED'), a status 409 will be returned - Possible values
               - true, false, yes, no
        :param pulumi.Input[builtins.str] severity: Rule severity - Possible values - INFO, MINOR, MAJOR, CRITICAL, BLOCKER
        :param pulumi.Input[builtins.str] status: Rule status - Possible values - BETA, DEPRECATED, READY, REMOVED - Default value - READY
        :param pulumi.Input[builtins.str] template_key: Key of the template rule in order to create a custom rule (mandatory for custom rule) - [Example
               values](https://docs.sonarqube.org/latest/user-guide/rules/#header-4)
        :param pulumi.Input[builtins.str] type: Rule type - Possible values - CODE_SMELL, BUG, VULNERABILITY, SECURITY_HOTSPOT
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RuleState.__new__(_RuleState)

        __props__.__dict__["custom_key"] = custom_key
        __props__.__dict__["markdown_description"] = markdown_description
        __props__.__dict__["name"] = name
        __props__.__dict__["params"] = params
        __props__.__dict__["prevent_reactivation"] = prevent_reactivation
        __props__.__dict__["severity"] = severity
        __props__.__dict__["status"] = status
        __props__.__dict__["template_key"] = template_key
        __props__.__dict__["type"] = type
        return Rule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="customKey")
    def custom_key(self) -> pulumi.Output[builtins.str]:
        """
        key of the custom rule should only contain : a-z, 0-9, \\_
        """
        return pulumi.get(self, "custom_key")

    @property
    @pulumi.getter(name="markdownDescription")
    def markdown_description(self) -> pulumi.Output[builtins.str]:
        """
        Rule description
        """
        return pulumi.get(self, "markdown_description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Rule name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def params(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Parameters as semi-colon list of =, for example 'params=key1=v1;key2=v2' (Only for custom rule) - parameter order:
        expression=value;filePattern=value;message=value
        """
        return pulumi.get(self, "params")

    @property
    @pulumi.getter(name="preventReactivation")
    def prevent_reactivation(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        If set to true and if the rule has been deactivated (status 'REMOVED'), a status 409 will be returned - Possible values
        - true, false, yes, no
        """
        return pulumi.get(self, "prevent_reactivation")

    @property
    @pulumi.getter
    def severity(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Rule severity - Possible values - INFO, MINOR, MAJOR, CRITICAL, BLOCKER
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Rule status - Possible values - BETA, DEPRECATED, READY, REMOVED - Default value - READY
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="templateKey")
    def template_key(self) -> pulumi.Output[builtins.str]:
        """
        Key of the template rule in order to create a custom rule (mandatory for custom rule) - [Example
        values](https://docs.sonarqube.org/latest/user-guide/rules/#header-4)
        """
        return pulumi.get(self, "template_key")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Rule type - Possible values - CODE_SMELL, BUG, VULNERABILITY, SECURITY_HOTSPOT
        """
        return pulumi.get(self, "type")

