# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['SettingArgs', 'Setting']

@pulumi.input_type
class SettingArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[builtins.str],
                 field_values: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]]] = None,
                 value: Optional[pulumi.Input[builtins.str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Setting resource.
        :param pulumi.Input[builtins.str] key: Setting key
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]] field_values: Setting field values for the supplied key
        :param pulumi.Input[builtins.str] value: Setting value. To reset a value, please use the reset web service.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] values: Setting multi values for the supplied key
        """
        pulumi.set(__self__, "key", key)
        if field_values is not None:
            pulumi.set(__self__, "field_values", field_values)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[builtins.str]:
        """
        Setting key
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="fieldValues")
    def field_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]]]:
        """
        Setting field values for the supplied key
        """
        return pulumi.get(self, "field_values")

    @field_values.setter
    def field_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]]]):
        pulumi.set(self, "field_values", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Setting value. To reset a value, please use the reset web service.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Setting multi values for the supplied key
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class _SettingState:
    def __init__(__self__, *,
                 field_values: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 value: Optional[pulumi.Input[builtins.str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Setting resources.
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]] field_values: Setting field values for the supplied key
        :param pulumi.Input[builtins.str] key: Setting key
        :param pulumi.Input[builtins.str] value: Setting value. To reset a value, please use the reset web service.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] values: Setting multi values for the supplied key
        """
        if field_values is not None:
            pulumi.set(__self__, "field_values", field_values)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="fieldValues")
    def field_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]]]:
        """
        Setting field values for the supplied key
        """
        return pulumi.get(self, "field_values")

    @field_values.setter
    def field_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]]]):
        pulumi.set(self, "field_values", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Setting key
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Setting value. To reset a value, please use the reset web service.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Setting multi values for the supplied key
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "values", value)


class Setting(pulumi.CustomResource):

    pulumi_type = "sonarqube:index/setting:Setting"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 field_values: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 value: Optional[pulumi.Input[builtins.str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a Sonarqube Settings resource. This can be used to manage Sonarqube settings.

        ## Example Usage

        ### Example: create a setting with multiple values
        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        multi_value_setting = sonarqube.Setting("multiValueSetting",
            key="sonar.global.exclusions",
            values=[
                "foo",
                "bar/**/*.*",
            ])
        ```

        ### Example: create a setting with multiple field values
        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        multi_field_setting = sonarqube.Setting("multiFieldSetting",
            key="sonar.issue.ignore.multicriteria",
            field_values=[
                {
                    "ruleKey": "foo",
                    "resourceKey": "bar",
                },
                {
                    "ruleKey": "foo2",
                    "resourceKey": "bar2",
                },
            ])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]] field_values: Setting field values for the supplied key
        :param pulumi.Input[builtins.str] key: Setting key
        :param pulumi.Input[builtins.str] value: Setting value. To reset a value, please use the reset web service.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] values: Setting multi values for the supplied key
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SettingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Sonarqube Settings resource. This can be used to manage Sonarqube settings.

        ## Example Usage

        ### Example: create a setting with multiple values
        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        multi_value_setting = sonarqube.Setting("multiValueSetting",
            key="sonar.global.exclusions",
            values=[
                "foo",
                "bar/**/*.*",
            ])
        ```

        ### Example: create a setting with multiple field values
        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        multi_field_setting = sonarqube.Setting("multiFieldSetting",
            key="sonar.issue.ignore.multicriteria",
            field_values=[
                {
                    "ruleKey": "foo",
                    "resourceKey": "bar",
                },
                {
                    "ruleKey": "foo2",
                    "resourceKey": "bar2",
                },
            ])
        ```

        :param str resource_name: The name of the resource.
        :param SettingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SettingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 field_values: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 value: Optional[pulumi.Input[builtins.str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SettingArgs.__new__(SettingArgs)

            __props__.__dict__["field_values"] = field_values
            if key is None and not opts.urn:
                raise TypeError("Missing required property 'key'")
            __props__.__dict__["key"] = key
            __props__.__dict__["value"] = value
            __props__.__dict__["values"] = values
        super(Setting, __self__).__init__(
            'sonarqube:index/setting:Setting',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            field_values: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]]] = None,
            key: Optional[pulumi.Input[builtins.str]] = None,
            value: Optional[pulumi.Input[builtins.str]] = None,
            values: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'Setting':
        """
        Get an existing Setting resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]] field_values: Setting field values for the supplied key
        :param pulumi.Input[builtins.str] key: Setting key
        :param pulumi.Input[builtins.str] value: Setting value. To reset a value, please use the reset web service.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] values: Setting multi values for the supplied key
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SettingState.__new__(_SettingState)

        __props__.__dict__["field_values"] = field_values
        __props__.__dict__["key"] = key
        __props__.__dict__["value"] = value
        __props__.__dict__["values"] = values
        return Setting(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="fieldValues")
    def field_values(self) -> pulumi.Output[Optional[Sequence[Mapping[str, builtins.str]]]]:
        """
        Setting field values for the supplied key
        """
        return pulumi.get(self, "field_values")

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[builtins.str]:
        """
        Setting key
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Setting value. To reset a value, please use the reset web service.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def values(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Setting multi values for the supplied key
        """
        return pulumi.get(self, "values")

