# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['UserArgs', 'User']

@pulumi.input_type
class UserArgs:
    def __init__(__self__, *,
                 login_name: pulumi.Input[builtins.str],
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 is_local: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a User resource.
        :param pulumi.Input[builtins.str] login_name: The login name of the User to create. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] email: The email of the User to create.
        :param pulumi.Input[builtins.bool] is_local: `True` if the User should be of type `local`. Defaults to `true`.
        :param pulumi.Input[builtins.str] name: The name of the User to create. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] password: The password of User to create. This is only used if the user is of type `local`.
        """
        pulumi.set(__self__, "login_name", login_name)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if is_local is not None:
            pulumi.set(__self__, "is_local", is_local)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)

    @property
    @pulumi.getter(name="loginName")
    def login_name(self) -> pulumi.Input[builtins.str]:
        """
        The login name of the User to create. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "login_name")

    @login_name.setter
    def login_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "login_name", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The email of the User to create.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="isLocal")
    def is_local(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        `True` if the User should be of type `local`. Defaults to `true`.
        """
        return pulumi.get(self, "is_local")

    @is_local.setter
    def is_local(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_local", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the User to create. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The password of User to create. This is only used if the user is of type `local`.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)


@pulumi.input_type
class _UserState:
    def __init__(__self__, *,
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 is_local: Optional[pulumi.Input[builtins.bool]] = None,
                 login_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering User resources.
        :param pulumi.Input[builtins.str] email: The email of the User to create.
        :param pulumi.Input[builtins.bool] is_local: `True` if the User should be of type `local`. Defaults to `true`.
        :param pulumi.Input[builtins.str] login_name: The login name of the User to create. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name of the User to create. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] password: The password of User to create. This is only used if the user is of type `local`.
        """
        if email is not None:
            pulumi.set(__self__, "email", email)
        if is_local is not None:
            pulumi.set(__self__, "is_local", is_local)
        if login_name is not None:
            pulumi.set(__self__, "login_name", login_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The email of the User to create.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="isLocal")
    def is_local(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        `True` if the User should be of type `local`. Defaults to `true`.
        """
        return pulumi.get(self, "is_local")

    @is_local.setter
    def is_local(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_local", value)

    @property
    @pulumi.getter(name="loginName")
    def login_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The login name of the User to create. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "login_name")

    @login_name.setter
    def login_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "login_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the User to create. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The password of User to create. This is only used if the user is of type `local`.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)


class User(pulumi.CustomResource):

    pulumi_type = "sonarqube:index/user:User"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 is_local: Optional[pulumi.Input[builtins.bool]] = None,
                 login_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides a Sonarqube User resource. This can be used to manage Sonarqube Users.

        ## Example Usage

        ### Example: create a local user
        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        user = sonarqube.User("user",
            login_name="terraform-test",
            password="secret-sauce37!")
        ```

        ### Example: create a remote user
        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        remote_user = sonarqube.User("remoteUser",
            email="terraform-test@sonarqube.com",
            is_local=False,
            login_name="terraform-test")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] email: The email of the User to create.
        :param pulumi.Input[builtins.bool] is_local: `True` if the User should be of type `local`. Defaults to `true`.
        :param pulumi.Input[builtins.str] login_name: The login name of the User to create. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name of the User to create. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] password: The password of User to create. This is only used if the user is of type `local`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Sonarqube User resource. This can be used to manage Sonarqube Users.

        ## Example Usage

        ### Example: create a local user
        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        user = sonarqube.User("user",
            login_name="terraform-test",
            password="secret-sauce37!")
        ```

        ### Example: create a remote user
        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        remote_user = sonarqube.User("remoteUser",
            email="terraform-test@sonarqube.com",
            is_local=False,
            login_name="terraform-test")
        ```

        :param str resource_name: The name of the resource.
        :param UserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 is_local: Optional[pulumi.Input[builtins.bool]] = None,
                 login_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserArgs.__new__(UserArgs)

            __props__.__dict__["email"] = email
            __props__.__dict__["is_local"] = is_local
            if login_name is None and not opts.urn:
                raise TypeError("Missing required property 'login_name'")
            __props__.__dict__["login_name"] = login_name
            __props__.__dict__["name"] = name
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(User, __self__).__init__(
            'sonarqube:index/user:User',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            email: Optional[pulumi.Input[builtins.str]] = None,
            is_local: Optional[pulumi.Input[builtins.bool]] = None,
            login_name: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            password: Optional[pulumi.Input[builtins.str]] = None) -> 'User':
        """
        Get an existing User resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] email: The email of the User to create.
        :param pulumi.Input[builtins.bool] is_local: `True` if the User should be of type `local`. Defaults to `true`.
        :param pulumi.Input[builtins.str] login_name: The login name of the User to create. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name of the User to create. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] password: The password of User to create. This is only used if the user is of type `local`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserState.__new__(_UserState)

        __props__.__dict__["email"] = email
        __props__.__dict__["is_local"] = is_local
        __props__.__dict__["login_name"] = login_name
        __props__.__dict__["name"] = name
        __props__.__dict__["password"] = password
        return User(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The email of the User to create.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="isLocal")
    def is_local(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        `True` if the User should be of type `local`. Defaults to `true`.
        """
        return pulumi.get(self, "is_local")

    @property
    @pulumi.getter(name="loginName")
    def login_name(self) -> pulumi.Output[builtins.str]:
        """
        The login name of the User to create. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "login_name")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the User to create. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The password of User to create. This is only used if the user is of type `local`.
        """
        return pulumi.get(self, "password")

