# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['UserExternalIdentityArgs', 'UserExternalIdentity']

@pulumi.input_type
class UserExternalIdentityArgs:
    def __init__(__self__, *,
                 external_identity: pulumi.Input[builtins.str],
                 external_provider: pulumi.Input[builtins.str],
                 login_name: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a UserExternalIdentity resource.
        :param pulumi.Input[builtins.str] external_identity: The identifier of the User used by the Authentication Provider. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] external_provider: The key of the Authentication Provider. The Authentication Provider must be activated on Sonarqube. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] login_name: The login name of the User to update. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "external_identity", external_identity)
        pulumi.set(__self__, "external_provider", external_provider)
        pulumi.set(__self__, "login_name", login_name)

    @property
    @pulumi.getter(name="externalIdentity")
    def external_identity(self) -> pulumi.Input[builtins.str]:
        """
        The identifier of the User used by the Authentication Provider. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "external_identity")

    @external_identity.setter
    def external_identity(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "external_identity", value)

    @property
    @pulumi.getter(name="externalProvider")
    def external_provider(self) -> pulumi.Input[builtins.str]:
        """
        The key of the Authentication Provider. The Authentication Provider must be activated on Sonarqube. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "external_provider")

    @external_provider.setter
    def external_provider(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "external_provider", value)

    @property
    @pulumi.getter(name="loginName")
    def login_name(self) -> pulumi.Input[builtins.str]:
        """
        The login name of the User to update. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "login_name")

    @login_name.setter
    def login_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "login_name", value)


@pulumi.input_type
class _UserExternalIdentityState:
    def __init__(__self__, *,
                 external_identity: Optional[pulumi.Input[builtins.str]] = None,
                 external_provider: Optional[pulumi.Input[builtins.str]] = None,
                 login_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering UserExternalIdentity resources.
        :param pulumi.Input[builtins.str] external_identity: The identifier of the User used by the Authentication Provider. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] external_provider: The key of the Authentication Provider. The Authentication Provider must be activated on Sonarqube. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] login_name: The login name of the User to update. Changing this forces a new resource to be created.
        """
        if external_identity is not None:
            pulumi.set(__self__, "external_identity", external_identity)
        if external_provider is not None:
            pulumi.set(__self__, "external_provider", external_provider)
        if login_name is not None:
            pulumi.set(__self__, "login_name", login_name)

    @property
    @pulumi.getter(name="externalIdentity")
    def external_identity(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The identifier of the User used by the Authentication Provider. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "external_identity")

    @external_identity.setter
    def external_identity(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_identity", value)

    @property
    @pulumi.getter(name="externalProvider")
    def external_provider(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The key of the Authentication Provider. The Authentication Provider must be activated on Sonarqube. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "external_provider")

    @external_provider.setter
    def external_provider(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_provider", value)

    @property
    @pulumi.getter(name="loginName")
    def login_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The login name of the User to update. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "login_name")

    @login_name.setter
    def login_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "login_name", value)


class UserExternalIdentity(pulumi.CustomResource):

    pulumi_type = "sonarqube:index/userExternalIdentity:UserExternalIdentity"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 external_identity: Optional[pulumi.Input[builtins.str]] = None,
                 external_provider: Optional[pulumi.Input[builtins.str]] = None,
                 login_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Updates the _external identity_ of a _non local_ Sonarqube User. This can be used to set the _Identity Provider_ which should be used to
        authenticate a specific user.

        The Sonarqube API currently does not provide an endpoint to read the _external identity_ setting of an user.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        ## Example: change the external identity to SAML
        remote_user_user = sonarqube.User("remoteUserUser",
            login_name="terraform-test",
            email="terraform-test@sonarqube.com",
            is_local=False)
        remote_user_user_external_identity = sonarqube.UserExternalIdentity("remoteUserUserExternalIdentity",
            login_name=remote_user_user.login_name,
            external_identity="terraform-test@sonarqube.com",
            external_provider="saml")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] external_identity: The identifier of the User used by the Authentication Provider. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] external_provider: The key of the Authentication Provider. The Authentication Provider must be activated on Sonarqube. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] login_name: The login name of the User to update. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserExternalIdentityArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Updates the _external identity_ of a _non local_ Sonarqube User. This can be used to set the _Identity Provider_ which should be used to
        authenticate a specific user.

        The Sonarqube API currently does not provide an endpoint to read the _external identity_ setting of an user.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        ## Example: change the external identity to SAML
        remote_user_user = sonarqube.User("remoteUserUser",
            login_name="terraform-test",
            email="terraform-test@sonarqube.com",
            is_local=False)
        remote_user_user_external_identity = sonarqube.UserExternalIdentity("remoteUserUserExternalIdentity",
            login_name=remote_user_user.login_name,
            external_identity="terraform-test@sonarqube.com",
            external_provider="saml")
        ```

        :param str resource_name: The name of the resource.
        :param UserExternalIdentityArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserExternalIdentityArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 external_identity: Optional[pulumi.Input[builtins.str]] = None,
                 external_provider: Optional[pulumi.Input[builtins.str]] = None,
                 login_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserExternalIdentityArgs.__new__(UserExternalIdentityArgs)

            if external_identity is None and not opts.urn:
                raise TypeError("Missing required property 'external_identity'")
            __props__.__dict__["external_identity"] = external_identity
            if external_provider is None and not opts.urn:
                raise TypeError("Missing required property 'external_provider'")
            __props__.__dict__["external_provider"] = external_provider
            if login_name is None and not opts.urn:
                raise TypeError("Missing required property 'login_name'")
            __props__.__dict__["login_name"] = login_name
        super(UserExternalIdentity, __self__).__init__(
            'sonarqube:index/userExternalIdentity:UserExternalIdentity',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            external_identity: Optional[pulumi.Input[builtins.str]] = None,
            external_provider: Optional[pulumi.Input[builtins.str]] = None,
            login_name: Optional[pulumi.Input[builtins.str]] = None) -> 'UserExternalIdentity':
        """
        Get an existing UserExternalIdentity resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] external_identity: The identifier of the User used by the Authentication Provider. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] external_provider: The key of the Authentication Provider. The Authentication Provider must be activated on Sonarqube. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] login_name: The login name of the User to update. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserExternalIdentityState.__new__(_UserExternalIdentityState)

        __props__.__dict__["external_identity"] = external_identity
        __props__.__dict__["external_provider"] = external_provider
        __props__.__dict__["login_name"] = login_name
        return UserExternalIdentity(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="externalIdentity")
    def external_identity(self) -> pulumi.Output[builtins.str]:
        """
        The identifier of the User used by the Authentication Provider. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "external_identity")

    @property
    @pulumi.getter(name="externalProvider")
    def external_provider(self) -> pulumi.Output[builtins.str]:
        """
        The key of the Authentication Provider. The Authentication Provider must be activated on Sonarqube. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "external_provider")

    @property
    @pulumi.getter(name="loginName")
    def login_name(self) -> pulumi.Output[builtins.str]:
        """
        The login name of the User to update. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "login_name")

