# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['UserTokenArgs', 'UserToken']

@pulumi.input_type
class UserTokenArgs:
    def __init__(__self__, *,
                 expiration_date: Optional[pulumi.Input[builtins.str]] = None,
                 login_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_key: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a UserToken resource.
        :param pulumi.Input[builtins.str] expiration_date: The expiration date of the token being generated, in ISO 8601 format (YYYY-MM-DD). If not set, default to no expiration.
        :param pulumi.Input[builtins.str] login_name: The login name of the User for which the token should be created. If not set, the token is created for the authenticated user. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name of the Token to create. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] project_key: The key of the only project that can be analyzed by the PROJECT_ANALYSIS TOKEN being created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] type: The kind of Token to create. Changing this forces a new resource to be created. Possible values are USER*TOKEN, GLOBAL*ANALYSIS*TOKEN, or PROJECT*ANALYSIS*TOKEN. Defaults to USER*TOKEN. If set to PROJECT*ANALYSIS*TOKEN, then the project_key must also be specified.
        """
        if expiration_date is not None:
            pulumi.set(__self__, "expiration_date", expiration_date)
        if login_name is not None:
            pulumi.set(__self__, "login_name", login_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_key is not None:
            pulumi.set(__self__, "project_key", project_key)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The expiration date of the token being generated, in ISO 8601 format (YYYY-MM-DD). If not set, default to no expiration.
        """
        return pulumi.get(self, "expiration_date")

    @expiration_date.setter
    def expiration_date(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expiration_date", value)

    @property
    @pulumi.getter(name="loginName")
    def login_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The login name of the User for which the token should be created. If not set, the token is created for the authenticated user. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "login_name")

    @login_name.setter
    def login_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "login_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Token to create. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectKey")
    def project_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The key of the only project that can be analyzed by the PROJECT_ANALYSIS TOKEN being created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "project_key")

    @project_key.setter
    def project_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_key", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The kind of Token to create. Changing this forces a new resource to be created. Possible values are USER*TOKEN, GLOBAL*ANALYSIS*TOKEN, or PROJECT*ANALYSIS*TOKEN. Defaults to USER*TOKEN. If set to PROJECT*ANALYSIS*TOKEN, then the project_key must also be specified.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _UserTokenState:
    def __init__(__self__, *,
                 expiration_date: Optional[pulumi.Input[builtins.str]] = None,
                 login_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_key: Optional[pulumi.Input[builtins.str]] = None,
                 token: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering UserToken resources.
        :param pulumi.Input[builtins.str] expiration_date: The expiration date of the token being generated, in ISO 8601 format (YYYY-MM-DD). If not set, default to no expiration.
        :param pulumi.Input[builtins.str] login_name: The login name of the User for which the token should be created. If not set, the token is created for the authenticated user. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name of the Token to create. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] project_key: The key of the only project that can be analyzed by the PROJECT_ANALYSIS TOKEN being created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] token: The token value.
        :param pulumi.Input[builtins.str] type: The kind of Token to create. Changing this forces a new resource to be created. Possible values are USER*TOKEN, GLOBAL*ANALYSIS*TOKEN, or PROJECT*ANALYSIS*TOKEN. Defaults to USER*TOKEN. If set to PROJECT*ANALYSIS*TOKEN, then the project_key must also be specified.
        """
        if expiration_date is not None:
            pulumi.set(__self__, "expiration_date", expiration_date)
        if login_name is not None:
            pulumi.set(__self__, "login_name", login_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_key is not None:
            pulumi.set(__self__, "project_key", project_key)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The expiration date of the token being generated, in ISO 8601 format (YYYY-MM-DD). If not set, default to no expiration.
        """
        return pulumi.get(self, "expiration_date")

    @expiration_date.setter
    def expiration_date(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expiration_date", value)

    @property
    @pulumi.getter(name="loginName")
    def login_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The login name of the User for which the token should be created. If not set, the token is created for the authenticated user. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "login_name")

    @login_name.setter
    def login_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "login_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Token to create. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectKey")
    def project_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The key of the only project that can be analyzed by the PROJECT_ANALYSIS TOKEN being created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "project_key")

    @project_key.setter
    def project_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_key", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The token value.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The kind of Token to create. Changing this forces a new resource to be created. Possible values are USER*TOKEN, GLOBAL*ANALYSIS*TOKEN, or PROJECT*ANALYSIS*TOKEN. Defaults to USER*TOKEN. If set to PROJECT*ANALYSIS*TOKEN, then the project_key must also be specified.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


class UserToken(pulumi.CustomResource):

    pulumi_type = "sonarqube:index/userToken:UserToken"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 expiration_date: Optional[pulumi.Input[builtins.str]] = None,
                 login_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_key: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides a Sonarqube User token resource. This can be used to manage Sonarqube User tokens.

        ## Example Usage

        ### Example: create a user, user token and output the token value
        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        user = sonarqube.User("user",
            login_name="terraform-test",
            password="secret-sauce37!")
        token = sonarqube.UserToken("token", login_name=user.login_name)
        pulumi.export("userToken", token.token)
        ```

        ### Example: create an expiring global analysis token and output the token value
        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        token = sonarqube.UserToken("token",
            type="GLOBAL_ANALYSIS_TOKEN",
            expiration_date="2099-01-01")
        pulumi.export("globalAnalysisToken", token.token)
        ```

        ### Example: create a project, project analysis token, and output the token value
        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        token = sonarqube.UserToken("token",
            type="PROJECT_ANALYSIS_TOKEN",
            project_key="my-project")
        pulumi.export("projectAnalysisToken", token.token)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] expiration_date: The expiration date of the token being generated, in ISO 8601 format (YYYY-MM-DD). If not set, default to no expiration.
        :param pulumi.Input[builtins.str] login_name: The login name of the User for which the token should be created. If not set, the token is created for the authenticated user. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name of the Token to create. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] project_key: The key of the only project that can be analyzed by the PROJECT_ANALYSIS TOKEN being created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] type: The kind of Token to create. Changing this forces a new resource to be created. Possible values are USER*TOKEN, GLOBAL*ANALYSIS*TOKEN, or PROJECT*ANALYSIS*TOKEN. Defaults to USER*TOKEN. If set to PROJECT*ANALYSIS*TOKEN, then the project_key must also be specified.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[UserTokenArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Sonarqube User token resource. This can be used to manage Sonarqube User tokens.

        ## Example Usage

        ### Example: create a user, user token and output the token value
        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        user = sonarqube.User("user",
            login_name="terraform-test",
            password="secret-sauce37!")
        token = sonarqube.UserToken("token", login_name=user.login_name)
        pulumi.export("userToken", token.token)
        ```

        ### Example: create an expiring global analysis token and output the token value
        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        token = sonarqube.UserToken("token",
            type="GLOBAL_ANALYSIS_TOKEN",
            expiration_date="2099-01-01")
        pulumi.export("globalAnalysisToken", token.token)
        ```

        ### Example: create a project, project analysis token, and output the token value
        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        token = sonarqube.UserToken("token",
            type="PROJECT_ANALYSIS_TOKEN",
            project_key="my-project")
        pulumi.export("projectAnalysisToken", token.token)
        ```

        :param str resource_name: The name of the resource.
        :param UserTokenArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserTokenArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 expiration_date: Optional[pulumi.Input[builtins.str]] = None,
                 login_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project_key: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserTokenArgs.__new__(UserTokenArgs)

            __props__.__dict__["expiration_date"] = expiration_date
            __props__.__dict__["login_name"] = login_name
            __props__.__dict__["name"] = name
            __props__.__dict__["project_key"] = project_key
            __props__.__dict__["type"] = type
            __props__.__dict__["token"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["token"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(UserToken, __self__).__init__(
            'sonarqube:index/userToken:UserToken',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            expiration_date: Optional[pulumi.Input[builtins.str]] = None,
            login_name: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project_key: Optional[pulumi.Input[builtins.str]] = None,
            token: Optional[pulumi.Input[builtins.str]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None) -> 'UserToken':
        """
        Get an existing UserToken resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] expiration_date: The expiration date of the token being generated, in ISO 8601 format (YYYY-MM-DD). If not set, default to no expiration.
        :param pulumi.Input[builtins.str] login_name: The login name of the User for which the token should be created. If not set, the token is created for the authenticated user. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name of the Token to create. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] project_key: The key of the only project that can be analyzed by the PROJECT_ANALYSIS TOKEN being created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] token: The token value.
        :param pulumi.Input[builtins.str] type: The kind of Token to create. Changing this forces a new resource to be created. Possible values are USER*TOKEN, GLOBAL*ANALYSIS*TOKEN, or PROJECT*ANALYSIS*TOKEN. Defaults to USER*TOKEN. If set to PROJECT*ANALYSIS*TOKEN, then the project_key must also be specified.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserTokenState.__new__(_UserTokenState)

        __props__.__dict__["expiration_date"] = expiration_date
        __props__.__dict__["login_name"] = login_name
        __props__.__dict__["name"] = name
        __props__.__dict__["project_key"] = project_key
        __props__.__dict__["token"] = token
        __props__.__dict__["type"] = type
        return UserToken(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> pulumi.Output[builtins.str]:
        """
        The expiration date of the token being generated, in ISO 8601 format (YYYY-MM-DD). If not set, default to no expiration.
        """
        return pulumi.get(self, "expiration_date")

    @property
    @pulumi.getter(name="loginName")
    def login_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The login name of the User for which the token should be created. If not set, the token is created for the authenticated user. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "login_name")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Token to create. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectKey")
    def project_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The key of the only project that can be analyzed by the PROJECT_ANALYSIS TOKEN being created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "project_key")

    @property
    @pulumi.getter
    def token(self) -> pulumi.Output[builtins.str]:
        """
        The token value.
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The kind of Token to create. Changing this forces a new resource to be created. Possible values are USER*TOKEN, GLOBAL*ANALYSIS*TOKEN, or PROJECT*ANALYSIS*TOKEN. Defaults to USER*TOKEN. If set to PROJECT*ANALYSIS*TOKEN, then the project_key must also be specified.
        """
        return pulumi.get(self, "type")

