# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['WebhookArgs', 'Webhook']

@pulumi.input_type
class WebhookArgs:
    def __init__(__self__, *,
                 url: pulumi.Input[builtins.str],
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 secret: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Webhook resource.
        :param pulumi.Input[builtins.str] url: The URL to send event payloads to. This must begin with either `https://` or `http://`.
        :param pulumi.Input[builtins.str] name: The name of the webhook to create. This will be displayed in the Sonarqube administration console.
        :param pulumi.Input[builtins.str] project: The key of the project that will own the webhook.
        :param pulumi.Input[builtins.str] secret: The secret to send with the event payload.
        """
        pulumi.set(__self__, "url", url)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[builtins.str]:
        """
        The URL to send event payloads to. This must begin with either `https://` or `http://`.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the webhook to create. This will be displayed in the Sonarqube administration console.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The key of the project that will own the webhook.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def secret(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The secret to send with the event payload.
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secret", value)


@pulumi.input_type
class _WebhookState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 secret: Optional[pulumi.Input[builtins.str]] = None,
                 url: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Webhook resources.
        :param pulumi.Input[builtins.str] name: The name of the webhook to create. This will be displayed in the Sonarqube administration console.
        :param pulumi.Input[builtins.str] project: The key of the project that will own the webhook.
        :param pulumi.Input[builtins.str] secret: The secret to send with the event payload.
        :param pulumi.Input[builtins.str] url: The URL to send event payloads to. This must begin with either `https://` or `http://`.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the webhook to create. This will be displayed in the Sonarqube administration console.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The key of the project that will own the webhook.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def secret(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The secret to send with the event payload.
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secret", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL to send event payloads to. This must begin with either `https://` or `http://`.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "url", value)


class Webhook(pulumi.CustomResource):

    pulumi_type = "sonarqube:index/webhook:Webhook"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 secret: Optional[pulumi.Input[builtins.str]] = None,
                 url: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides a Sonarqube Webhook resource. This can be used to manage Sonarqube webhooks.

        ## Example Usage

        ### Example: create a webhook
        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        webhook = sonarqube.Webhook("webhook", url="https://my-webhook-destination.example.com")
        ```

        ### Example: create a webhook owned by a project
        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        project = sonarqube.Project("project",
            project="project",
            visibility="public")
        webhook = sonarqube.Webhook("webhook",
            url="https://my-webhook-destination.example.com",
            project=project.name)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] name: The name of the webhook to create. This will be displayed in the Sonarqube administration console.
        :param pulumi.Input[builtins.str] project: The key of the project that will own the webhook.
        :param pulumi.Input[builtins.str] secret: The secret to send with the event payload.
        :param pulumi.Input[builtins.str] url: The URL to send event payloads to. This must begin with either `https://` or `http://`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WebhookArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Sonarqube Webhook resource. This can be used to manage Sonarqube webhooks.

        ## Example Usage

        ### Example: create a webhook
        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        webhook = sonarqube.Webhook("webhook", url="https://my-webhook-destination.example.com")
        ```

        ### Example: create a webhook owned by a project
        ```python
        import pulumi
        import pulumi_sonarqube as sonarqube

        project = sonarqube.Project("project",
            project="project",
            visibility="public")
        webhook = sonarqube.Webhook("webhook",
            url="https://my-webhook-destination.example.com",
            project=project.name)
        ```

        :param str resource_name: The name of the resource.
        :param WebhookArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WebhookArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 secret: Optional[pulumi.Input[builtins.str]] = None,
                 url: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WebhookArgs.__new__(WebhookArgs)

            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["secret"] = None if secret is None else pulumi.Output.secret(secret)
            if url is None and not opts.urn:
                raise TypeError("Missing required property 'url'")
            __props__.__dict__["url"] = url
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["secret"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Webhook, __self__).__init__(
            'sonarqube:index/webhook:Webhook',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            secret: Optional[pulumi.Input[builtins.str]] = None,
            url: Optional[pulumi.Input[builtins.str]] = None) -> 'Webhook':
        """
        Get an existing Webhook resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] name: The name of the webhook to create. This will be displayed in the Sonarqube administration console.
        :param pulumi.Input[builtins.str] project: The key of the project that will own the webhook.
        :param pulumi.Input[builtins.str] secret: The secret to send with the event payload.
        :param pulumi.Input[builtins.str] url: The URL to send event payloads to. This must begin with either `https://` or `http://`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WebhookState.__new__(_WebhookState)

        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["secret"] = secret
        __props__.__dict__["url"] = url
        return Webhook(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the webhook to create. This will be displayed in the Sonarqube administration console.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The key of the project that will own the webhook.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def secret(self) -> pulumi.Output[builtins.str]:
        """
        The secret to send with the event payload.
        """
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[builtins.str]:
        """
        The URL to send event payloads to. This must begin with either `https://` or `http://`.
        """
        return pulumi.get(self, "url")

