# Security Policy

## Supported Versions

We provide security updates for the following versions:

| Version | Supported          |
| ------- | ------------------ |
| 0.1.x   | :white_check_mark: |
| < 0.1   | :x:                |

## Reporting a Vulnerability

If you discover a security vulnerability in DagRuff, please report it by:

1. **Email**: Send an email to the maintainers (see repository contacts)
2. **Private Security Advisory**: Use GitHub's private vulnerability reporting feature if available

Please do **not** create a public GitHub issue for security vulnerabilities.

### What to include

- Description of the vulnerability
- Steps to reproduce
- Potential impact
- Suggested fix (if any)

We will acknowledge receipt of your report within 48 hours and provide an update on the status within 7 days.

## Security Best Practices

When using DagRuff:

- Always use the latest version
- Review configuration files before execution
- Be cautious with auto-fix on untrusted code
- Validate DAG files in a controlled environment before production use

