"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WatchfulAspect = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const apigw = require("aws-cdk-lib/aws-apigateway");
const dynamodb = require("aws-cdk-lib/aws-dynamodb");
const ecs_patterns = require("aws-cdk-lib/aws-ecs-patterns");
const lambda = require("aws-cdk-lib/aws-lambda");
const rds = require("aws-cdk-lib/aws-rds");
const stepfunctions = require("aws-cdk-lib/aws-stepfunctions");
/**
 * A CDK aspect that can automatically watch all resources within a scope.
 *
 * @stability stable
 */
class WatchfulAspect {
    /**
     * Defines a watchful aspect.
     *
     * @param watchful The watchful to add those resources to.
     * @param props Options.
     * @stability stable
     */
    constructor(watchful, props = {}) {
        this.watchful = watchful;
        this.props = props;
    }
    /**
     * All aspects can visit an IConstruct.
     *
     * @stability stable
     */
    visit(node) {
        const watchApiGateway = this.props.apiGateway === undefined ? true : this.props.apiGateway;
        const watchDynamo = this.props.dynamodb === undefined ? true : this.props.dynamodb;
        const watchLambda = this.props.lambda === undefined ? true : this.props.lambda;
        const watchStateMachine = this.props.stateMachine === undefined ? true : this.props.stateMachine;
        const watchRdsAuroraCluster = this.props.rdsaurora === undefined ? true : this.props.rdsaurora;
        const watchFargateEcs = this.props.fargateecs === undefined ? true : this.props.fargateecs;
        const watchEc2Ecs = this.props.ec2ecs === undefined ? true : this.props.ec2ecs;
        if (watchApiGateway && node instanceof apigw.RestApi) {
            this.watchful.watchApiGateway(node.node.path, node);
        }
        if (watchDynamo && node instanceof dynamodb.Table) {
            this.watchful.watchDynamoTable(node.node.path, node);
        }
        if (watchLambda && node instanceof lambda.Function) {
            this.watchful.watchLambdaFunction(node.node.path, node);
        }
        if (watchStateMachine && node instanceof stepfunctions.StateMachine) {
            this.watchful.watchStateMachine(node.node.path, node);
        }
        if (watchRdsAuroraCluster && node instanceof rds.DatabaseCluster) {
            this.watchful.watchRdsAuroraCluster(node.node.path, node);
        }
        if (watchFargateEcs && node instanceof ecs_patterns.ApplicationLoadBalancedFargateService) {
            this.watchful.watchFargateEcs(node.node.path, node.service, node.targetGroup);
        }
        if (watchEc2Ecs && node instanceof ecs_patterns.ApplicationLoadBalancedEc2Service) {
            this.watchful.watchEc2Ecs(node.node.path, node.service, node.targetGroup);
        }
    }
}
exports.WatchfulAspect = WatchfulAspect;
_a = JSII_RTTI_SYMBOL_1;
WatchfulAspect[_a] = { fqn: "cdk-watchful.WatchfulAspect", version: "0.6.29" };
//# sourceMappingURL=data:application/json;base64,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