import * as ecs from 'aws-cdk-lib/aws-ecs';
import { ApplicationTargetGroup } from 'aws-cdk-lib/aws-elasticloadbalancingv2';
import { Construct } from 'constructs';
import { IWatchful } from './api';
/**
 * @stability stable
 */
export interface WatchEcsServiceOptions {
    /**
     * Threshold for the Cpu Maximum utilization.
     *
     * @default 80
     * @stability stable
     */
    readonly cpuMaximumThresholdPercent?: number;
    /**
     * Threshold for the Memory Maximum utilization.
     *
     * @default - 0.
     * @stability stable
     */
    readonly memoryMaximumThresholdPercent?: number;
    /**
     * Threshold for the Target Response Time.
     *
     * @default - 0.
     * @stability stable
     */
    readonly targetResponseTimeThreshold?: number;
    /**
     * Threshold for the Number of Requests.
     *
     * @default - 0.
     * @stability stable
     */
    readonly requestsThreshold?: number;
    /**
     * Threshold for the Number of Request Errors.
     *
     * @default - 0.
     * @stability stable
     */
    readonly requestsErrorRateThreshold?: number;
}
/**
 * @stability stable
 */
export interface WatchEcsServiceProps extends WatchEcsServiceOptions {
    /**
     * @stability stable
     */
    readonly title: string;
    /**
     * @stability stable
     */
    readonly watchful: IWatchful;
    /**
     * @stability stable
     */
    readonly fargateService?: ecs.FargateService;
    /**
     * @stability stable
     */
    readonly ec2Service?: ecs.Ec2Service;
    /**
     * @stability stable
     */
    readonly targetGroup: ApplicationTargetGroup;
}
/**
 * @stability stable
 */
export declare class WatchEcsService extends Construct {
    private readonly watchful;
    private readonly ecsService;
    private readonly targetGroup;
    private readonly serviceName;
    private readonly clusterName;
    private readonly targetGroupName;
    private readonly loadBalancerName;
    private readonly metrics;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: WatchEcsServiceProps);
    private createCpuUtilizationMonitor;
    private createMemoryUtilizationMonitor;
    private createTargetResponseTimeMonitor;
    private createRequestsMonitor;
    private createHttpRequestsMetrics;
    private createHostCountMetrics;
    private requestsErrorRate;
}
