"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RedshiftMetricFactory = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const Namespace = 'AWS/Redshift';
class RedshiftMetricFactory {
    metricAverageConnectionCount(clusterIdentifier) {
        return this.metric("DatabaseConnections" /* DatabaseConnections */, clusterIdentifier).with({ statistic: aws_cloudwatch_1.Statistic.AVERAGE });
    }
    metricAverageDiskSpaceUsageInPercent(clusterIdentifier) {
        return this.metric("PercentageDiskSpaceUsed" /* PercentageDiskSpaceUsed */, clusterIdentifier).with({ statistic: aws_cloudwatch_1.Statistic.AVERAGE });
    }
    metricAverageCpuUsageInPercent(clusterIdentifier) {
        return this.metric("CPUUtilization" /* CPUUtilization */, clusterIdentifier).with({ statistic: aws_cloudwatch_1.Statistic.AVERAGE });
    }
    metricAverageQueryDurationInMicros(clusterIdentifier) {
        return {
            shortQueries: this.metricQueryDuration('short', clusterIdentifier).with({ statistic: aws_cloudwatch_1.Statistic.AVERAGE }),
            mediumQueries: this.metricQueryDuration('medium', clusterIdentifier).with({ statistic: aws_cloudwatch_1.Statistic.AVERAGE }),
            longQueries: this.metricQueryDuration('long', clusterIdentifier).with({ statistic: aws_cloudwatch_1.Statistic.AVERAGE }),
        };
    }
    metricAverageLatencyInSeconds(clusterIdentifier) {
        return {
            read: this.metric("ReadLatency" /* ReadLatency */, clusterIdentifier).with({ statistic: aws_cloudwatch_1.Statistic.AVERAGE }),
            write: this.metric("WriteLatency" /* WriteLatency */, clusterIdentifier).with({ statistic: aws_cloudwatch_1.Statistic.AVERAGE }),
        };
    }
    metricMaintenanceModeEnabled(clusterIdentifier) {
        return this.metric("MaintenanceMode" /* MaintenanceMode */, clusterIdentifier).with({ statistic: aws_cloudwatch_1.Statistic.MAXIMUM });
    }
    metricQueryDuration(latency, clusterIdentifier) {
        return new aws_cloudwatch_1.Metric({
            metricName: "QueryDuration" /* QueryDuration */,
            namespace: Namespace,
            period: aws_cdk_lib_1.Duration.minutes(5),
            dimensionsMap: {
                DBClusterIdentifier: clusterIdentifier,
                latency,
            },
        });
    }
    metric(metric, clusterIdentifier) {
        return new aws_cloudwatch_1.Metric({
            metricName: metric,
            namespace: Namespace,
            period: aws_cdk_lib_1.Duration.minutes(5),
            dimensionsMap: {
                DBClusterIdentifier: clusterIdentifier,
            },
        });
    }
}
exports.RedshiftMetricFactory = RedshiftMetricFactory;
//# sourceMappingURL=data:application/json;base64,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