"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnsMetricFactory = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const Namespace = 'AWS/SNS';
class SnsMetricFactory {
    metricNumberOfMessagesPublished(topicName) {
        return this.metric("NumberOfMessagesPublished" /* NumberOfMessagesPublished */, topicName).with({ statistic: aws_cloudwatch_1.Statistic.SUM });
    }
    metricNumberOfMessagesDelivered(topicName) {
        return this.metric("NumberOfNotificationsDelivered" /* NumberOfNotificationsDelivered */, topicName).with({ statistic: aws_cloudwatch_1.Statistic.SUM });
    }
    metricNumberOfNotificationsFailed(topicName) {
        return this.metric("NumberOfNotificationsFailed" /* NumberOfNotificationsFailed */, topicName).with({ statistic: aws_cloudwatch_1.Statistic.SUM });
    }
    metricAverageMessageSizeInBytes(topicName) {
        return this.metric("PublishSize" /* PublishSize */, topicName).with({ statistic: aws_cloudwatch_1.Statistic.AVERAGE });
    }
    metric(metric, topicName) {
        return new aws_cloudwatch_1.Metric({
            metricName: metric,
            namespace: Namespace,
            period: aws_cdk_lib_1.Duration.minutes(5),
            dimensionsMap: {
                TopicName: topicName,
            },
        });
    }
}
exports.SnsMetricFactory = SnsMetricFactory;
//# sourceMappingURL=data:application/json;base64,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