"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StateMachineMetricFactory = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const Namespace = 'AWS/States';
class StateMachineMetricFactory {
    metricExecutions(stateMachineArn) {
        return {
            total: this.metric("ExecutionsStarted" /* ExecutionsStarted */, stateMachineArn).with({ label: 'Total', statistic: aws_cloudwatch_1.Statistic.SUM }),
            succeeded: this.metric("ExecutionsSucceeded" /* ExecutionsSucceeded */, stateMachineArn).with({ label: 'Executions Succeeded', statistic: aws_cloudwatch_1.Statistic.SUM }),
            failed: this.metric("ExecutionsFailed" /* ExecutionsFailed */, stateMachineArn).with({ label: 'Failed Executions', statistic: aws_cloudwatch_1.Statistic.SUM }),
            aborted: this.metric("ExecutionsAborted" /* ExecutionsAborted */, stateMachineArn).with({ label: 'Aborted Executions', statistic: aws_cloudwatch_1.Statistic.SUM }),
            throttled: this.metric("ExecutionThrottled" /* ExecutionThrottled */, stateMachineArn).with({ label: 'Executions Throttled', statistic: aws_cloudwatch_1.Statistic.SUM }),
            timedOut: this.metric("ExecutionsTimedOut" /* ExecutionsTimedOut */, stateMachineArn).with({ label: 'Executions TimedOut', statistic: aws_cloudwatch_1.Statistic.SUM }),
        };
    }
    metric(metric, stateMachineArn) {
        return new aws_cloudwatch_1.Metric({
            metricName: metric,
            namespace: Namespace,
            period: aws_cdk_lib_1.Duration.minutes(1),
            dimensionsMap: {
                StateMachineArn: stateMachineArn,
            },
        });
    }
}
exports.StateMachineMetricFactory = StateMachineMetricFactory;
//# sourceMappingURL=data:application/json;base64,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