import * as rds from 'aws-cdk-lib/aws-rds';
import { Construct } from 'constructs';
import { IWatchful } from './api';
/**
 * @stability stable
 */
export interface WatchRdsAuroraOptions {
    /**
     * Threshold for the Cpu Maximum utilization.
     *
     * @default 80
     * @stability stable
     */
    readonly cpuMaximumThresholdPercent?: number;
    /**
     * Threshold for the Maximum Db Connections.
     *
     * @default - 0.
     * @stability stable
     */
    readonly dbConnectionsMaximumThreshold?: number;
    /**
     * Threshold for the Maximum Db ReplicaLag.
     *
     * @default - 0.
     * @stability stable
     */
    readonly dbReplicaLagMaximumThreshold?: number;
    /**
     * Threshold for the Maximum Db Throughput.
     *
     * @default - 0.
     * @stability stable
     */
    readonly dbThroughputMaximumThreshold?: number;
    /**
     * Threshold for the Minimum Db Buffer Cache.
     *
     * @default - 0.
     * @stability stable
     */
    readonly dbBufferCacheMinimumThreshold?: number;
}
/**
 * @stability stable
 */
export interface WatchRdsAuroraProps extends WatchRdsAuroraOptions {
    /**
     * @stability stable
     */
    readonly title: string;
    /**
     * @stability stable
     */
    readonly watchful: IWatchful;
    /**
     * @stability stable
     */
    readonly cluster: rds.DatabaseCluster;
}
/**
 * @stability stable
 */
export declare class WatchRdsAurora extends Construct {
    private readonly watchful;
    private readonly cluster;
    private readonly metrics;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: WatchRdsAuroraProps);
    private createCpuUtilizationMonitor;
    private createDbConnectionsMonitor;
    private createDbReplicaLagMonitor;
    private createDbBufferCacheMonitor;
    private createDbDmlThroughputMonitor;
}
