import { StateMachine } from 'aws-cdk-lib/aws-stepfunctions';
import { Construct } from 'constructs';
import { IWatchful } from './api';
/**
 * @stability stable
 */
export interface WatchStateMachineOptions {
    /**
     * Alarm when execution failures reach this threshold over 1 minute.
     *
     * @default 1 any execution failure will trigger the alarm
     * @stability stable
     */
    readonly metricFailedThreshold?: number;
}
/**
 * @stability stable
 */
export interface WatchStateMachineProps extends WatchStateMachineOptions {
    /**
     * @stability stable
     */
    readonly title: string;
    /**
     * @stability stable
     */
    readonly watchful: IWatchful;
    /**
     * @stability stable
     */
    readonly stateMachine: StateMachine;
}
/**
 * @stability stable
 */
export declare class WatchStateMachine extends Construct {
    private readonly title;
    private readonly watchful;
    private readonly stateMachine;
    private readonly metricFailedThreshold;
    private readonly metrics;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: WatchStateMachineProps);
    private createExecutionMetrics;
    private createLinks;
}
